<?php
/**
 * $Id: NuCoderTask.php  $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://phing.info>.
 */

require_once 'phing/Task.php';

/**
 * Invokes the NuCoder Encoder. see at the end of this file for more info. 
 *
 * @author Nadir Boussoukaia <nad4reg@gmail.com>
 * 
 * initially based on the code for ioncube from Michiel Rook <michiel.rook@gmail.com> & Andrew Eddie <andrew.eddie@jamboworks.com>
 * @version $Id: NuCoderTask.php  $
 * @package phing.tasks.ext.nucoder
 * @since 2.2.0
 */
class NuCoderTask extends Task
{
    private $NuCoder_Switches = array();

    private $NuCoder_Options = array();

    private $NuCoder_OptionsXS = array();

    private $fromDir = '';
    private $toDir = '';

    private $nucoderPath = '/usr/local/nucoder';

    function setNoShortTags($value)
    {
        $this->ionSwitches['noshorttags'] = $value;
    }
    
    function setRecursive($value)
    {
        $this->NuCoder_Switches['recursive'] = $value;
    }
    function setObfuscation($value)
    {
        $this->NuCoder_Options['obfuscation'] = $value;
    }
    function setCopyall($value)
    {
        $this->NuCoder_Switches['copyall'] = $value;
    }
    function setLineinfo($value)
    {
        $this->NuCoder_Switches['lineinfo'] = $value;
    }
    function setExclude($value)
    {
        $this->NuCoder_OptionsXS['exclude'] = $value;
    }  
    function setVersion($value)
    {
        $this->NuCoder_Options['c'] = $value;
    }
    function setHeader($value)
    {
        $this->NuCoder_OptionsXS['header'] = $value;
    }      
    function setNoDl($value)
    {
        $this->NuCoder_Switches['nodl'] = $value;
    }
    function setnoheader($value)
    {
        $this->NuCoder_Switches['noheader'] = $value;
    }
 
    /**
     * Sets the source directory
     */
    function setFromDir($value)
    {
        $this->fromDir = $value;
    }

    /**
     * Returns the source directory
     */
    function getFromDir()
    {
        return $this->fromDir;
    }

    /**
     * Sets the path to the NuCoder encoder
     */
    function setNuCoderPath($value)
    {
        $this->nucoderPath = $value;
    }

  
    /**
     * Sets the target directory
     */
    function setToDir($value)
    {
        $this->toDir = $value;
    }

    /**
     * Returns the target directory
     */
    function getToDir()
    {
        return $this->toDir;
    }

    /**
     * The main entry point
     *
     * @throws BuildException
     */
    function main()
    {
        $arguments = $this->constructArguments();
           
        $encoder = new PhingFile($this->nucoderPath);

        $this->log("Running NuCoder...");
//$cmdline='"'.$encoder->__toString().'"' . ' ' . $arguments . " 2>&1";
$cmdline='"'.$encoder->__toString().'"' . ' ' . $arguments ;
$cmdline='""'.$encoder->__toString().'"' . ' ' . $arguments.'"' ;

//exec('""C:\Program Files\Internet Explorer\iexplore.exe" "http://www.google.com/search?q=php with spaces""');

        $this->log($cmdline, $output, $return);

        exec($cmdline, $output, $return);
        
        if ($return != 0)
        {
            throw new BuildException("Could not execute NuCoder: " . implode(' ', $output));
        }        
    }

    /**
     * Constructs an argument string for the NuCoder encoder
     */
    private function constructArguments()
    {
        $arguments = '';

        foreach ($this->NuCoder_Switches as $name => $value)
        {
            if ($value)
            {
                $arguments.= "--$name ";
            }
        }

        foreach ($this->NuCoder_Options as $name => $value)
        {
            $arguments.= "--$name $value ";
        }

        foreach ($this->NuCoder_OptionsXS as $name => $value)
        {
            foreach (explode(' ', $value) as $arg)
            {
                $arguments.= "--$name \"$arg\" ";
            }
        }

 //<srcdir> <targetdir>  Encode files in srcdir directory and save results into targetdir directory
        if ($this->fromDir != '')
        {
            $arguments .= $this->fromDir . ' ';
        }

        if ($this->toDir != '')
        {
            $arguments .= " " . $this->toDir . ' ';
        }

        return $arguments;
    }
}


/*

How to install
---------------

Tested on phing-2.4.5 on Windows.

1/
copy NuCoderTask.php in \phing-2.4.5\classes\phing\tasks\ext


2/
update the file Q:\phing-2.4.5\classes\phing\tasks\defaults.properties
with the following:
nucoder=phing.tasks.ext.NuCoderTask

3/
that's all.

sample build XML task:
  
<target name="obfuscation" description="">
  <nucoder
     recursive="true"
     obfuscation="1"
     copyall="true"
     lineinfo="true"
     exclude="config.php *.cache.php index.php"  
     noheader="false"
     nodl="false"
     header="Q:/RELEASE/nucoder-header.txt"
     fromdir="${DST_DIR}/build/source"
    todir="${DST_DIR}/build/dest"
    nucoderpath="C:\Program Files (x86)\NuSphere\NuCoder\nu-coder.exe"
  >

  </nucoder>
</target>

where DST_DIR is a property set this way
 <property name="DST_DIR" value="." description="source folder" />

Refer to nu-coder doc for details on the commands

4/
Not all the properties have been coded.
Only those I needed.

Author:
Nadir Boussoukaia
03/09/2011
*/


