
; /********************************************************************/
; /*                                                                  */
; /*  author: Nadir Boussoukaia (boussou@ismea.imt-mrs.fr)            */
; /*  on june 1993                                                    */
; /*                                                                  */
; /*                                                                  */
; /*  big thanks to OLIVIER PONS who designed most part of existing   */
; /*  level...      ~~~~~~~~~~~~                                      */
; /*                                                                  */
; /*  Hello to Matthieu Fauqueux                                      */
; /*  Hello to Fabrice Pestre                                         */
; /*                                                                  */
; /********************************************************************/

.model small

; portion of my 'C' include file:
;
;  #define VOID            ' '
;  #define WALL            '' /* character 177 */
;  #define GUM             'G'
;  #define BIGGUM          'B'
;  #define SECRET_PASSAGE  '' /* character 178 */
;  #define WARDROBE_ENTRY  '' /* character 219 */
;
;a level structure is composed of a fixed matrix (beware to not change
;its size !), followed by its parameters, which are:
;
;                   - GUM_IMAGE_NUMBER
;                   - BIGGUM_IMAGE_NUMBER
;                   - WALLS_SET_NUMBER
;                   - DELAY_IN_WARDROBE
;                   - AFRAID_DELAY
;
;you put characters defined above to build your level. then you transform it by
;using 'build.bat' file.
;and that's all.
;
;the best is to copy an existing level and to alter it. put your level in the
;beginning of the file (just after the words '.data' so it will be the first
;level to come.
;
;beware to allways preserve a safe backup of your levels file.
;
;
;to build the levels file, execute the file build.bat, which looks like:
;
;                    masm levels;
;                    link levels;
;                    exe2bin levels.exe levels.dat
;                    del levels.exe
;                    del levels.obj
;
;you can use another assembler like tasm instead of this (tlink provides the
;option /TDc that make file already useable, without need to use exe2bin.)
;
;I've provided exe2bin since i'm not sure it is still distributed with DOS.
;
;for non asm-users:
;~~~~~~~~~~~~~~~~~~
;            there are asm directives that you should not modify !
;            these are:
;
;            - .model small
;            - .data
;            - db
;            - dw
;            - comments begin with a ';' character
;
;
;CONSTRUCTION:
;~~~~~~~~~~~~~
;here is a example level (this could be a template level)
;
;                            ----------levelmap-----------
;                    db      ""
;                    db      "G G G G G G G G G G G G G"
;                    db      "                         "
;                    db      "G G G G G G G G G G G G G"
;                    db      "                         "
;                    db      "G G G G G G G G G G G G G"
;                    db      "                         "
;                    db      "G G G G G       G G G G G"
;                    db      "         ۱         "
;                    db      "G G G G G     G G G G G"
;                    db      "                  "
;                    db      "G G G G G       G G G G G"
;                    db      "                         "
;                    db      "G G G G G G G G G G G G G"
;                    db      "                         "
;                    db      "G G G G G G G G G G G G G"
;                    db      "                         "
;                    db      "G G G G G G G G G G G G G"
;                    db      ""
;
;                    dw 1      ;gum_image_number
;                    dw 8      ;biggum_image_number
;                    dw 1      ;walls_set_number
;                    dw 25     ;delay_in_WARDROBE
;                    dw 500    ;afraid_delay
;
;- gums and biggums could only be putted in even lines and columns.
;
;- when PACMAN or GHOSTS go through a secret passage, it reappears on same
;  line but on the opposit side of the level. so beware to preserve a way for
;  them.
;- the WARDROBE is fixed. do not move it since ghosts allways appear in center
;  of map.
;- PACMAN also allways appear just below the WARDROBE. preserve a way around
;  this place !
;
;- don't expect bugs corrections if you build crippled levels...
;  this will not blow up everything, but strange things could appear !
;
;
;parameters of a level structure:
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;
;WALLS_SET_NUMBER:  valid range 0..4
;                   this defines the walls design.
;                   0=BLUE 1=GREEN 2=VIOLET 3=GREY 4=RED
;
;
;GUM_IMAGE_NUMBER:  valid range 0..31
;                   sets the gums design.
;                   i've joined the gums original picture in the archive.
;                   if you choose 0, it is the first gum of this picture, etc..
;
;BIGGUM_IMAGE_NUMBER
;                   valid range 0..31
;                   sets the BIGGUMS design.
;                   shared with gums in the same picture.
;                   theses gums are those which make ghosts 'afraid' (blue).
;                   generally they are bigger than others gums, but this is
;                   not an obligation.
;
;DELAY_IN_WARDROBE  delay in frame (1/60 sec).
;                   choosing 60 will make them wait 1 second inside wardrobe
;
;AFRAID_DELAY       delay in frame (1/60 sec).
;                   when PACMAN eats biggum, time ghosts remain afraid.
;                   choosing 600 will keep them afraid 10 seconds
;
;
;last words:
;~~~~~~~~~~
;
;- i've putted all levels between this two comment lines:
; ;------------------------------------------------------------LEVEL STRUCTURE
; ...
; ;---------------------------------------------------------LEVEL ENDSTRUCTURE
;  complete data for one level is contained inside.
;  so when you copy a level, include them !
;
;
;- no time to code a real mouse driven level editor...
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



.data


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "B GG G GG G GG G GG B"
                    db      "          "
                    db      "G G G G G G G G G G G G"
                    db      "        "
                    db      " GG G GG G GG G GG "
                    db      "       "
                    db      " G G G G       G G G G "
                    db      "  ۱  "
                    db      "  G G GG     GG G G  "
                    db      "      "
                    db      " GG G G       G G GG "
                    db      "        "
                    db      " G G G G G G G G G G G "
                    db      "      "
                    db      "B GG G GG G GG G GG B"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 18     ;GUM_IMAGE_NUMBER
                    dw 5      ;BIGGUM_IMAGE_NUMBER
                    dw 0      ;WALLS_SET_NUMBER
                    dw 30     ;DELAY_IN_WARDROBE
                    dw 600    ;AFRAID_DELAY

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "     G G G G G G G     "
                    db      "     "
                    db      "B G G G GG G GG G G G B"
                    db      "         "
                    db      "GG G GG GGG GG G GG"
                    db      "       "
                    db      "G GG G G       G G GG G"
                    db      "   ۱   "
                    db      "G G GG G     G GG G G"
                    db      "        "
                    db      "G GG GG       GG GG G"
                    db      "       "
                    db      " G G G G G G G G G G G "
                    db      "        "
                    db      "B GGG GG GG GGG B"
                    db      "        "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 9      ;gum_image_number    
                    dw 4      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G GG G G G GG G G G"
                    db      "        "
                    db      "BG G G GG G GG G G GB"
                    db      "         "
                    db      "G GG GG G GG GG G"
                    db      "        "
                    db      "  GG G G       G G GG  "
                    db      "  ۱  "
                    db      " G G G G     G GG G "
                    db      "         "
                    db      " GG GG       GG GG "
                    db      "      "
                    db      "G G G G G G   G G G G G G"
                    db      "        "
                    db      "B GG GG G GG GG B"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 12     ;gum_image_number    
                    dw 26     ;biggum_image_number
                    dw 4      ;walls_set_number
                    dw 20     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G GG G GG G G G G"
                    db      "         "
                    db      "BGG G G G G G G G GGB"
                    db      "         "
                    db      "GG G   G G G G G   G GG"
                    db      "      "
                    db      "G G G G       G G G G"
                    db      "   ۱   "
                    db      " GG G G     G G GG "
                    db      "        "
                    db      " G G GG       GG G G "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      "       "
                    db      "B GG G GGGGG G GG B"
                    db      "           "
                    db      "G G G G GG G GG G G G G"
                    db      ""
         
                    dw 16     ;gum_image_number    
                    dw 7      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 20     ;delay_in_WARDROBE
                    dw 300    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G BG G G G G G GB G  "
                    db      "       "
                    db      " G GG GG G GG GG G "
                    db      "      "
                    db      "G G G G G G G G G G G G G"
                    db      "       "
                    db      "G G GG G       G GG G G"
                    db      "  ۱  "
                    db      "G G G G G     G G G G G"
                    db      "      "
                    db      "G GG GG       GG GG G"
                    db      "      "
                    db      "G G G G G G G G G G G G G"
                    db      "        "
                    db      "BG G G GG G GG G G GB"
                    db      "       "
                    db      "G G GG G G G G G GG G G"
                    db      ""
         
                    dw 29     ;gum_image_number    
                    dw 30     ;biggum_image_number 
                    dw 2      ;walls_set_number
                    dw 20     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "       "
                    db      "B G G G G G G G B"
                    db      "       "
                    db      "G G G G G G G G G G G"
                    db      "      "
                    db      "G G G G       G G G G"
                    db      "   ۱   "
                    db      "G G G G     G G G G"
                    db      "      "
                    db      "G G G G       G G G G"
                    db      "      "
                    db      "G G G G G G G G G G G"
                    db      "       "
                    db      "B G G G G G G G G G B"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 13     ;gum_image_number    
                    dw 23     ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "B G GG G G G G G GG G B"
                    db      "         "
                    db      "G G G GG GGG GG G G G"
                    db      "       "
                    db      " GG G GG G GG G GG "
                    db      "          "
                    db      " GGG G       G GGG "
                    db      "    ۱    "
                    db      "  G G GG     GG G G  "
                    db      "      "
                    db      " GG G G       G G GG "
                    db      "      "
                    db      "G G G   G G G   G G G"
                    db      "      "
                    db      "G G G G G G G G G G G G"
                    db      "        "
                    db      "B GG G G G G G G G GG B"
                    db      ""
         
                    dw 27     ;gum_image_number    
                    dw 4      ;biggum_image_number 
                    dw 0      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE




;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "B G G G G G G G G G G G B"
                    db      "         "
                    db      "G G G GGGGG G G G"
                    db      "         "
                    db      "  G G GG G G G GG G G  "
                    db      "    "
                    db      " GG G G       G G GG "
                    db      "    ۱    "
                    db      "  G G GG     GG G G  "
                    db      "    "
                    db      " G G G G       G G G G "
                    db      "      "
                    db      "  G G GG G GG G G  "
                    db      "        "
                    db      "B G G GG G G GG G G B"
                    db      "        "
                    db      "G G GG G G G G G GG G G"
                    db      ""



                    dw 20     ;gum_image_number    
                    dw 31     ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 2      ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   


;---------------------------------------------------------LEVEL ENDSTRUCTURE


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G GG G G G G G GG G  "
                    db      "          "
                    db      "B GG  GG G GGG GG B"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      " GG GG       GG GG "
                    db      "   ۱   "
                    db      "  G G G G     G G G G  "
                    db      "      "
                    db      " GG GG       GG GG "
                    db      "      "
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      "BG GG GG G GG GG GB"
                    db      "        "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 29     ;gum_image_number    
                    dw 23     ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G GG G G G GG G G G"
                    db      "         "
                    db      "B  G  GG G GG     B"
                    db      "        "
                    db      "G G G G G G G G G G G G"
                    db      "      "
                    db      " GG G G       G G GG "
                    db      "  ۱  "
                    db      "   G G G     G G G   "
                    db      "      "
                    db      " G G G       G G G "
                    db      "       "
                    db      "  GG G GG   GG G GG  "
                    db      "      "
                    db      "B G GG G G G G GG G B"
                    db      "      "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 14     ;gum_image_number    
                    dw 22     ;biggum_image_number 
                    dw 2      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      "B GG GG G GG GG B"
                    db      "         "
                    db      " G G G G GGG G G G G "
                    db      "       "
                    db      " G GG G       G GG G "
                    db      "    ۱    "
                    db      "  GG GG     GG GG  "
                    db      "    "
                    db      "G G G G G       G G G G G"
                    db      "        "
                    db      "G G GG GG G GG GG G G"
                    db      "       "
                    db      "B G G GG G GG G G B"
                    db      "        "
                    db      "G G GG G G G G G GG G G"
                    db      ""
         
                    dw 28     ;gum_image_number    
                    dw 30     ;biggum_image_number 
                    dw 4      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "B G G G G G G G G G G G B"
                    db      "      "
                    db      "G GG G G G G G GG G"
                    db      "       "
                    db      "G G GGG G G G GGG G G"
                    db      "      "
                    db      "G GG G G       G G GG G"
                    db      "   ۱   "
                    db      "G GG G G     G G GG G"
                    db      "      "
                    db      "G GG G       G GG G"
                    db      "      "
                    db      "G GB G G G G G G G BG G"
                    db      "    "
                    db      "G GG G GG GG G GG G"
                    db      "        "
                    db      "G G G G G G G G G G G"
                    db      ""
         
                    dw 3      ;gum_image_number    
                    dw 5      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 1      ;delay_in_WARDROBE
                    dw 1000   ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "   G G G G G G G G G   "
                    db      "     "
                    db      " GG G G G G G G G GG "
                    db      "      "
                    db      " G G G G G G G G G G G "
                    db      " "
                    db      "G G G G G       G G G G G"
                    db      "   ۱   "
                    db      "G G B   G     G G B G G"
                    db      "      "
                    db      "G G G G G       G G G G G"
                    db      "      "
                    db      "G g GG G G G G G GG G G"
                    db      "      "
                    db      " G G G G G G G G G "
                    db      "      "
                    db      "    G G G G G G    "
                    db      ""
         
                    dw 28     ;gum_image_number    
                    dw 26     ;biggum_image_number 
                    dw 0      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G G G G G G G G G G G  "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      "    "
                    db      "  G G G G       G G G G  "
                    db      "  ۱  "
                    db      "  G G G G     G G G G  "
                    db      "    "
                    db      "  G G G G       G G G G  "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      "    "
                    db      "  G G G G G G G G G G G  "
                    db      ""
         
                    dw 29     ;gum_image_number    
                    dw 26     ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G B G G G G G"
                    db      "  "
                    db      "G G G G G G G G G G G G G"
                    db      "       "
                    db      "GGGGGB G G G G G G G"
                    db      "       "
                    db      "G GGGG       GG GG G"
                    db      "     ۱     "
                    db      "GGGGG     GGGGG"
                    db      "          "
                    db      "G G GGB       G G G GG"
                    db      "    "
                    db      "G G GG G G G GB GG B G"
                    db      "        "
                    db      "G G G G GG GGGG G"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 9      ;gum_image_number    
                    dw 23     ;biggum_image_number 
                    dw 2      ;walls_set_number
                    dw 50     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "B G G G G G G G G G G G B"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      "                     "
                    db      "  G G G G       G G G G  "
                    db      "       ۱       "
                    db      "G G G G G     G G G G G"
                    db      "                  "
                    db      "G G G G G       G G G G G"
                    db      "                     "
                    db      "  G G G G G G G G G G G  "
                    db      "                     "
                    db      "B G G G G G G G G G G G B"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      ""
                    
                    dw 1      ;gum_image_number    
                    dw 25     ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      "           "            
                    db      "                 "
                    db      "                "
                    db      "                 "
                    db      "               "
                    db      "                           "
                    db      "        "
                    db      "    G G G       G G G    "
                    db      "      ۱      "
                    db      "    B G G     G B    "
                    db      "            "
                    db      "    G G       G G G    "
                    db      "            "
                    db      "    G G G G G G G G G    "
                    db      "        "
                    db      "                           "
                    db      "                           "
                    db      "                           "
                    db      "                           "
         
                    dw 11     ;gum_image_number    
                    dw 7      ;biggum_image_number 
                    dw 0      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE



;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************

; born dead levels.
; they must be putted right...



;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G B G G G G G"
                    db      "   "
                    db      "B G G G GG G B GG G G B"
                    db      "         "
                    db      "GG G BB GGGG G G GG"
                    db      "         "
                    db      "G BG G G       GB GGG"
                    db      "   ۱    "
                    db      "G GG G     G G G GG"
                    db      "       "
                    db      "G BG G       G G GG G"
                    db      "        "
                    db      "GGG G G G G G G G GG B"
                    db      "          "
                    db      "G GG G   GG BGG G"
                    db      "       "
                    db      "G G B G G G B G G G G G G"
                    db      ""
         
                    dw 14     ;gum_image_number    
                    dw 0      ;biggum_image_number 
                    dw 0      ;walls_set_number
                    dw 1      ;delay_in_WARDROBE
                    dw 50     ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "B G G G G G G B G G G G B"
                    db      "  "
                    db      "GB G G G G G G G G G G G"
                    db      "     "
                    db      "GGGG G G G G G G G G G"
                    db      "    "
                    db      "GGG G G       G G G G G"
                    db      "     ۱  "
                    db      "GGGGG     G G G GG"
                    db      "        "
                    db      "GGGG G       G G G GG"
                    db      "          "
                    db      "GGGGGG G GGGB GG"
                    db      "             "
                    db      "GGGG G G G G G G G GG"
                    db      "    "
                    db      "G G G G G G G G G G G G B"
                    db      ""
         
                    dw 18     ;gum_image_number    
                    dw 0      ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 50     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G B G G G G G"
                    db      "  "
                    db      "GG G G G G G G G G G G G"
                    db      "      "
                    db      "GG G G G G G G G G G GG"
                    db      "        "
                    db      "G GGGB       BGGGG"
                    db      "    ۱     "
                    db      "GG GGB     GG GGG"
                    db      "           "
                    db      "GGGGB       GGGGG"
                    db      "            "
                    db      "GGGGB B BGGGGG G"
                    db      "         "
                    db      "GG GG G G G G GG GG"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 500    ;delay_in_WARDROBE
                    dw 50     ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G B G G G G G"
                    db      "  "
                    db      "G G G G G G G G G G G G G"
                    db      "   "
                    db      "GG G G G G G G G G G GG"
                    db      "    "
                    db      "G GG G G       G G GGG"
                    db      "  ۱     "
                    db      "G GG GG     GGGGG"
                    db      "         "
                    db      "G BGGG       G G G GG"
                    db      "         "
                    db      "G GG G GGGG G G BGG"
                    db      "         "
                    db      "G GG G G GGG G G GGG"
                    db      "      "
                    db      "B G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 1      ;delay_in_WARDROBE
                    dw 1000   ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      "GGG G G G G G GG G G G"
                    db      "         "
                    db      "G G G G G GG GG GG GG"
                    db      "        "
                    db      "GG G GG       GG GG G"
                    db      "    ۱     "
                    db      "GG G GG     GGGGG"
                    db      "         "
                    db      "GG G GG       G G GG G"
                    db      "        "
                    db      "G GG G G G G GG GG GG"
                    db      "          "
                    db      "G G G G G G GG G GG GG"
                    db      "  "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G G G G B G G G G G G  "
                    db      "       "
                    db      "G G G G G GG G GG G G G"
                    db      "                  "
                    db      "GG G GG G G G GG G GG"
                    db      "    "
                    db      "GG G G G       GG G GG"
                    db      "     ۱      "
                    db      "GG G GG     GGG BG"
                    db      "        "
                    db      "G GG GG       GGB GG"
                    db      "             "
                    db      "G GGG GGG G G GG GG"
                    db      "             "
                    db      "G GGG GGG G G G G GG"
                    db      "     "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 9      ;gum_image_number    
                    dw 0      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 500    ;delay_in_WARDROBE
                    dw 5000   ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE






;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      " GG G G G G GG G G G B"
                    db      "           "
                    db      "  G G G G G GG G G G"
                    db      "           "
                    db      "B GG G G G G GG G G G "
                    db      "          "
                    db      " GG G G       G G G G "
                    db      "     ۱       "
                    db      "  GG GG     G G G G  "
                    db      "         "
                    db      " G G GG       G G GG "
                    db      "                     "
                    db      " G G GG G G G G G G G "
                    db      "    "
                    db      "B GG GG G G GG G GG B"
                    db      "                  "
                    db      "G G G G G GG G G G G G G"
                    db      ""
         
                    dw 21     ;gum_image_number    
                    dw 0      ;biggum_image_number 
                    dw 2      ;walls_set_number
                    dw 30     ;delay_in_WARDROBE
                    dw 600    ;afraid_delay        

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "                     "
                    db      "GG GG G G G G GG GG B"
                    db      "               "
                    db      "GB GG G G B G GG GG G"
                    db      "                     "
                    db      "GG GG G       GG GG G"
                    db      "       ۱       "
                    db      "GG GG G     GG GG G"
                    db      "              "
                    db      "GG GG G       G G GG G"
                    db      "                    "
                    db      "GG GG GG G G GG GG G"
                    db      "                "
                    db      "BG GG GG G G GG GG B"
                    db      "                    "
                    db      "G G G G G G G G GG G G G"
                    db      ""
                    
                    dw 13     ;gum_image_number    
                    dw 7      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 37     ;delay_in_WARDROBE
                    dw 700    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G G G G G G G GG G G  "
                    db      "          "
                    db      "G BG G G G G G G     "
                    db      "                   "
                    db      "G GG G G G G G G    G  "
                    db      "          "
                    db      "G GG G             G B"
                    db      "     ۱       "
                    db      "G G B G          G G"
                    db      "               "
                    db      "G G G G             G G"
                    db      "            "
                    db      "G G G GG GGG G G  G  "
                    db      "     "
                    db      "G G G G G G G G GG G G G"
                    db      "    "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 19     ;gum_image_number    
                    dw 4      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE



;chr

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G G G G G G G G G G G  "
                    db      "  "  
                    db      "G GG G G G G G G G GG G" 
                    db      "      "
                    db      "GGGG G G G G G GGGG"
                    db      "        "  
                    db      "GGGGG G G G GGGGG" 
                    db      "     ۱     " 
                    db      "GGGGG     GGGGG" 
                    db      "          " 
                    db      "GGGGG B G G G GGGG" 
                    db      "       "
                    db      "GGGG G G G G G G GGG"
                    db      "     " 
                    db      "GGG G G G G G G G G GG"
                    db      "   " 
                    db      "B G G G G G G G G G G G G"
                    db      ""
         
                    dw 18     ;gum_image_number    
                    dw 1      ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 210     ;delay_in_WARDROBE
                    dw 600    ;afraid_delay        

;---------------------------------------------------------LEVEL ENDSTRUCTURE





;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "  G G G G G G G G G G G  "
                    db      "         "
                    db      "G G G GGG GG GG G G G"
                    db      "                "
                    db      "G G G GGG BG GG G GG"
                    db      "             "
                    db      "GG G G G G G G G G GGG"
                    db      "     ۱   B "
                    db      "GB GG G     G G  G"
                    db      "           "
                    db      "G G G G G G G G G G G GG"
                    db      "            "            
                    db      "G G G GG BGG G  GG G"
                    db      "        B     "
                    db      "G G GGGGG G  G  G"
                    db      "              "
                    db      "  G G G G G G G G G G G  "
                    db      ""
                             
                             
         
                    dw 19     ;gum_image_number    
                    dw 4      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
                             
                             
;olive

;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "    "
                    db      "G G G G G G G GG G GGG"
                    db      "         "
                    db      "G G G G G G G G G G GG G"
                    db      "      "
                    db      "GGGG G G G G G G G GG"
                    db      "      ۱   "
                    db      "G GG G G     G G GGG"
                    db      "      "
                    db      "G G G GG G G G G G GGG"
                    db      "       "
                    db      "G G GGG G G G G G G GG"
                    db      "    "
                    db      "G GG G G G G G G G G G G"
                    db      "      "
                    db      "G G G G G GG G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "    "
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      "G GG         GG G G"
                    db      "       "
                    db      "G GG G G G G GGG G G"
                    db      "     ۱    "
                    db      "G GGG     GGG G G"
                    db      "         "
                    db      "G G GGG G G G G GG G G"
                    db      "       "
                    db      "G GGG G G G G G GGGG"
                    db      "             "
                    db      "GGG G GG G G G G G G G"
                    db      "   "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G GG G G G G G"
                    db      "         "
                    db      "G G GG G G GG G G G GG"
                    db      "      "
                    db      "G G GG G G G G G GGG G"
                    db      "      "
                    db      "G GG G G G G G GGG GG"
                    db      "    ۱    "
                    db      "GGGG G     GGG G G"
                    db      "           "
                    db      "GGG GG G G G GG GGG"
                    db      "          "
                    db      "GGG G GGG GGG G GG"
                    db      "        "
                    db      "GGG G G G G GGG G G G"
                    db      "     "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "  "
                    db      "GB GG GG GG GG GG G"
                    db      "                 "
                    db      "GG G G GG GG GG GG G"
                    db      "      "
                    db      "GG G G G G G G G G G G"
                    db      "      ۱  "
                    db      "GG GGG     G G G G G"
                    db      "     "
                    db      "GG G G G G G G G G G GG"
                    db      "       "
                    db      "GG GGG G GG GG GGG"
                    db      "            "
                    db      "GG GGB GG GG GG GG"
                    db      "     "
                    db      "G GG G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G B G G G G G"
                    db      "  "
                    db      "GG G G G G G G G G G G G"
                    db      "      "
                    db      "GG G G G G G G G G G GG"
                    db      "        "
                    db      "G GGGB B B B BGGGG"
                    db      "    ۱     "
                    db      "GG GGB     GG GGG"
                    db      "           "
                    db      "GGGGB B B G GGGGG"
                    db      "            "
                    db      "GGGGB B BGGGGG G"
                    db      "         "
                    db      "GG GG G G G G GG GG"
                    db      "       "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 3      ;walls_set_number
                    dw 500    ;delay_in_WARDROBE
                    dw 50     ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "      "
                    db      "GGG G G G G G GG G G G"
                    db      "         "
                    db      "G G G G G GG GG GG GG"
                    db      "        "
                    db      "GG G GG G G G GG GG G"
                    db      "    ۱     "
                    db      "GG G GG     GGGGG"
                    db      "         "
                    db      "GG G GG G G G G G GG G"
                    db      "        "
                    db      "G GG G G G G GG GG GG"
                    db      "          "
                    db      "G G G G G G GG G GG GG"
                    db      "  "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE
;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G B G G G G G G G"
                    db      "      "
                    db      "G G G G G GG G GGG G G"
                    db      "               "
                    db      "GG G GG G G G GG G GG"
                    db      "    "
                    db      "GG G G G G G G GG G GG"
                    db      "     ۱      "
                    db      "GG G GG     GGG BG"
                    db      "        "
                    db      "G GG GG G G G GGB GG"
                    db      "             "
                    db      "G GGG GGG G G GG GG"
                    db      "             "
                    db      "G GGG GGG G G G G GG"
                    db      "     "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 9      ;gum_image_number    
                    dw 0      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 500    ;delay_in_WARDROBE
                    dw 5000   ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "G G G G G       G G G G G"
                    db      "         ۱         "
                    db      "G G G G G     G G G G G"
                    db      "                  "
                    db      "G G G G G       G G G G G"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      "                         "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE


;------------------------------------------------------------LEVEL STRUCTURE
;                           ----------levelmap-----------
                    db      ""
                    db      "G G G G G G G G G G G G G"
                    db      "             "
                    db      "G G G G G G G G G G G G G"
                    db      "             "
                    db      "G G G G G G G G G G G G G"
                    db      "             "
                    db      "G G G G G       G G G G G"
                    db      "     ۱     "
                    db      "G G G G G     G G G G G"
                    db      "          "
                    db      "G G G G G       G G G G G"
                    db      "             "
                    db      "G G G G G G G G G G G G G"
                    db      "             "
                    db      "G G G G G G G G G G G G G"
                    db      "             "
                    db      "G G G G G G G G G G G G G"
                    db      ""
         
                    dw 1      ;gum_image_number    
                    dw 8      ;biggum_image_number 
                    dw 1      ;walls_set_number
                    dw 25     ;delay_in_WARDROBE
                    dw 500    ;afraid_delay   

;---------------------------------------------------------LEVEL ENDSTRUCTURE

end

