
     /*--------------------------------------------------------*/
    /*                                                        */
   /* module de chargement d'une image IFF dans l'ecran MODX */
  /* prend pour acquis que l'ecran a deja t ouvert.       */
 /*                                                        */
/*--------------------------------------------------------*/

#ifndef _IFF_H_
#define _IFF_H_
/*-------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

#define DWORD unsigned long
#define WORD unsigned int
#define BYTE unsigned char

typedef struct{ WORD w,h;            //width & height de la page
                WORD x,y;            //decalage de la page
                BYTE BitPlanes;      //profondeur
		BYTE Masking;
		BYTE Compression;    // methode de compression
                BYTE Padbyte;
                WORD TransCol;
		BYTE XAspect,YAspect;
		WORD Width,Height;     //de l'ecran d'affichage physique
	      } BitMapHeader;
/*-------------------------------------------------------------------------*/
/* module de chargement d'une image IFF dans l'ecran MODX  l'offset
   specifi. L'ecran doit DEJA avoir t ouvert.
   error messages:
    ( 0) ok
    (-1) file not found
    (-2) not an iff file
    (-3) not an ilbm(iff picture) file
    (-4) bad iff-ilbm file format
*/
extern int load_IFF(char *filename,WORD ScreenOffs);


/*-------------------------------------------------------------------------*/
/* charge une brush IFF. la brush doit faire moins de 64 ko !
   un ptr far sur la brush est retourne, au format LINEAR BITMAP.
   Brush est alloue  l'intrieur de la fonction.
   ne pas oublier de liberer la memoire (farfree !).
   si y'a le moindre probleme, renvoie NULL (peu precis, mais enfin...)
  ...renvoie un LINEAR BITMAP avec brush[0]=BMHD.w; brush[1]=BMHD.h;
  attention que ces taille sont modulo 256 car sur BYTE...                */
extern BYTE far* load_brush(char *filename);

/*-------------------------------------------------------------------------*/
// recherche et lit un BitMapHeader dans le fichier F,
// et le transfere en BMHD apres conversion  la norme INTEL.
// attention, si le BMHD n'est pas trouv, le message d'erreur est que tout
// les champs de BMHD sont  0.
extern BitMapHeader IFF_bitmap_info (char *filename);

/*-------------------------------------------------------------------------*/
/* pas de message d'erreur. j'ai la flemme...
/* debrouille-toi...    						   */
extern void load_palette(char *filename,char far *palette);

#ifdef __cplusplus
}
#endif

#endif