
#ifndef _KBD_HDL_H_
#define _KBD_HDL_H_

/* CONSTANTS  ========================================================== */

#define Joy_Fires(J) ((J & 48)>>4) //donne un numero entre 0 et 3

#define Joy_Fire2(J) (J & 32)
#define Joy_Fire1(J) (J & 16)
#define Joy_Up(J)    (J & 8 ) 
#define Joy_Down(J)  (J & 4 ) 
#define Joy_Right(J) (J & 2 ) 
#define Joy_Left(J)  (J & 1 ) 

// les defines sont  utiliser lors des test:
// while(key_press){
// while(key_release){

#define key_press   (Inkey<0x80)
#define key_release (Inkey>=0x80)

// les defines sont  utiliser comme des commandes:
// wait_key_press;
// wait_key_release;
// wait_key;


#define wait_key_press   while(key_release)
#define wait_key_release while(key_press)
#define wait_key         wait_key_release; wait_key_press; wait_key_release


    /*----------------------------------------------------------------------*/
   /* les noms des touches sont choisis par rapport au clavier francais... */ 
  /*         seuls les make code sont donns (touche enfonce).           */
 /*   break code (touche relache) = make code + 80h (le bit 7 est mis)  */
/*----------------------------------------------------------------------*/
#define Key_Esc             0x01

#define Key_F1              0x3B
#define Key_F2              0x3C
#define Key_F3              0x3D
#define Key_F4              0x3E
#define Key_F7              0x41
#define Key_F5              0x3F
#define Key_F6              0x40
#define Key_F8              0x42
#define Key_F9              0x43
#define Key_F10             0x44
#define Key_F11             0x57
#define Key_F12             0x58

#define Key_Square          0x29
#define Key_Up1             0x02
#define Key_Up2             0x03
#define Key_Up3             0x04
#define Key_Up4             0x05
#define Key_Up5             0x06
#define Key_Up6             0x07
#define Key_Up7             0x08
#define Key_Up8             0x09
#define Key_Up9             0x0A
#define Key_Up0             0x0B
#define Key_Degree          0x0C
#define Key_Plus            0x0D
#define Key_Backspace       0x0E

#define Key_Tab             0x0F
#define Key_A               0x10
#define Key_Z               0x11
#define Key_E               0x12
#define Key_R               0x13
#define Key_T               0x14
#define Key_Y               0x15
#define Key_U               0x16
#define Key_I               0x17
#define Key_O               0x18
#define Key_P               0x19
#define Key_Trema           0x1A
#define Key_Livres          0x1B

#define Key_Caps_Lock       0x3A
#define Key_Q               0x1E
#define Key_S               0x1F
#define Key_D               0x20
#define Key_F               0x21
#define Key_G               0x22
#define Key_H               0x23
#define Key_J               0x24
#define Key_K               0x25
#define Key_L               0x26
#define Key_M               0x27
#define Key_Pourcent        0x28
#define Key_Micro           0x2B

#define Key_Superior        0x56
#define Key_W               0x2C
#define Key_X               0x2D
#define Key_C               0x2E
#define Key_V               0x2F
#define Key_B               0x30
#define Key_N               0x31
#define Key_Interrogation   0x32
#define Key_Point           0x33
#define Key_Slash           0x34
#define Key_Exclamation     0x35


#define Key_Alt             0x38
#define Key_Ctrl            0x1D
#define Key_Left_Shift      0x2A
#define Key_Right_Shift     0x36

#define Key_Num_Lock        0x45
#define Key_Scroll_Lock     0x46

#define Key_Del             0x53
#define Key_End             0x4F
#define Key_Home            0x47
#define Key_Ins             0x52
#define Key_PgDn            0x51
#define Key_PgUp            0x49

#define Key_Left_arrow      0x4B
#define Key_Right_arrow     0x4D
#define Key_Up_arrow        0x48
#define Key_Down_arrow      0x50

#define Key_Space           0x39
#define Key_Return          0x1C
#define Key_Enter           0x1C


/*  Keypad Keys  as numlock is off */
#define Key_pad0         0x52
#define Key_pad1         0x4F
#define Key_pad2         0x50
#define Key_pad3         0x51
#define Key_pad4         0x4B
#define Key_pad5         0x4C
#define Key_pad6         0x4D
#define Key_pad7         0x47
#define Key_pad8         0x48
#define Key_pad9         0x49
#define Key_padPoint     0x53
#define Key_padMul       0x37
#define Key_padMinus     0x4A
#define Key_padPlus      0x4E
#define Key_padSlash     0x35





#define BYTE unsigned char

/* FUNCTIONS =========================================================== */

#ifdef __cplusplus
extern "C" {
#endif

void Install_Keyboard_Handler(void);
void Remove_Keyboard_Handler(void);

void Set_JoyPad1(BYTE FIRE2, BYTE FIRE1, BYTE UP, BYTE DOWN, BYTE RIGHT, BYTE LEFT);
void Set_JoyPad2(BYTE FIRE2, BYTE FIRE1, BYTE UP, BYTE DOWN, BYTE RIGHT, BYTE LEFT);

void Set_JoyPad_Type(BYTE type);   /* Set le mode de gestion des 2 joypads:
                                       0/ Tout est autoris (default).
                                          aucun test particulier.
                                       1/ exclusion mutuelle H/B & D/G (on ne
                                          peut pas aller en haut et en bas en
                                          meme temps, ou  droite et gauche).
                                       2/ diagonales non autorises
                                          une touche  la fois ( la derniere
                                          appuye).
                                   */
#ifdef __cplusplus
}
#endif


extern BYTE Inkey;
extern BYTE JoyPad1;
extern BYTE JoyPad2;

#endif

