
      /*-------------------------------------------------------------------*/
     /*  author: Nadir Boussoukaia                                        */
    /*    on june 1993                                                   */
   /*                                                                   */
  /*    all file access routines (loading time).                       */
 /*                                                                   */
/*-------------------------------------------------------------------*/

/*
   data file neeeded :

   game part :
   GAMEOVER.DAT      :gameover logo
   BONUS.DAT         :bonus images in raw format
   GHOSTS.DAT        :ghosts frames in raw format (order is important)
   PACMAN.DAT        :pacman frames in raw format (order is important)
   WALLS.DAT         :walls blocks in raw format (order is important)
   GUMS.DAT          :different gums images in raw format
   LEVELS.DAT        :structured file for the level definition
   PALETTE.DAT       :raw palette of the game

 */
/*-------------------------------------------------------------------------*/
/* renvoie la taille du fichier. En cas d'erreur (genre fichier non trouv)
   renvoie -1                                                              */
/* returns sizeof file. on error (like file not found) returns -1          */

long get_filesize (char *filename)
{
  long infilesize;
  FILE *fi;

  fi = fopen (filename, "rb+");
  if (!fi)
    return (-1);

  fseek (fi, 0, SEEK_END);
  infilesize = ftell (fi);

  fclose (fi);
  return infilesize;
}
/*-------------------------------------------------------------------------*/
/* function to read a file into a far buffer (when we are in small model).
   same prototype as fread()
 */
void farfread (void far * destptr, size_t size, size_t n, FILE * fp)
{
#define BUFF_LEN 100
  unsigned len;
  unsigned char buff[BUFF_LEN];
  len = size * n;

  while (len >= BUFF_LEN)
    {
      fread (buff, BUFF_LEN, 1, fp);

      movedata ((unsigned) _DS, (unsigned) buff, FP_SEG (destptr), FP_OFF (destptr), BUFF_LEN);

      len -= BUFF_LEN;
      (char far *) destptr += BUFF_LEN;
    }
  if (len > 0)
    {
      fread (buff, len, 1, fp);
      movedata ((unsigned) _DS, (unsigned) buff, FP_SEG (destptr), FP_OFF (destptr), len);
    }
};
/*-------------------------------------------------------------------------*/
/* exit procedure (when file not found) */
void file_error (char *filename)
{
  int i;

  x_text_mode ();
  printf ("File error on %s ... ", filename);
  for (i = 0; i < 50; i++)
    x_wait_vsync ();
  printf ("Press a key to quit.\n");
  WAIT_KEY ();

  exit (-1);
}
/*-------------------------------------------------------------------------*/
void load_walls_images (void)
{
  /* load images and prepare data in memory */

#define filename "WALLS.DAT"
#define width 6
#define height 24

  FILE *f;
  char far *buffer = farmalloc (320 * 24 * 2 + 20);
  char far *tile = farmalloc (4 * width * height + 20);
  int i, x, y, dim1, dim2;
  long filesize;

  int tiles_offsets[26] =
  {
    0 * 24, 1 * 24, 2 * 24, 3 * 24, 4 * 24, 5 * 24, 6 * 24, 7 * 24, 8 * 24, 9 * 24, 10 * 24, 11 * 24, 12 * 24,
    7680 + 0 * 24, 7680 + 1 * 24, 7680 + 2 * 24, 7680 + 3 * 24, 7680 + 4 * 24, 7680 + 1 * 24, 7680 + 6 * 24,
    7680 + 7 * 24, 7680 + 8 * 24, 7680 + 9 * 24, 7680 + 10 * 24, 7680 + 11 * 24, 7680 + 12 * 24};

  filesize = get_filesize (filename);
  if (filesize == -1)
    file_error (filename);
  if (buffer == NULL || tile == NULL)
    alloc_error ();
  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);

  for (dim1 = 0; dim1 < MAX_WALLS_SET; dim1++)
    {

      farfread (buffer, 15360, 1, f);

      for (dim2 = 0; dim2 < 16; dim2++)
	{

	  walls_sets_images[dim1][dim2] = farmalloc (4 * width * height + 20);
	  if (walls_sets_images[dim1][dim2] == NULL)
	    alloc_error ();

	  for (y = 0; y < height; y++)
	    for (x = 0; (x < width * 4); x++)
	      *(tile + x + y * width * 4 + 2) = *(buffer + x + y * 320 + tiles_offsets[dim2]);

	  LBMWidth (tile) = width * 4;
	  LBMHeight (tile) = height;

	  x_bm_to_pbm (tile, walls_sets_images[dim1][dim2]);
	}
    }

  fclose (f);
  farfree (buffer);
  farfree (tile);

#undef filename
#undef width
#undef height

}
/*-------------------------------------------------------------------------*/
void load_pacman_images (void)
{
  /* load images and prepare data in memory */

#define filename "PACMAN.DAT"
#define width 5
#define height 20

  FILE *f;
  char far *buff;
  char far *tile = farmalloc (4 * width * height + 20);
  int x, y, i, j, dim1 = 0, dim2 = 0;
  long filesize;

  filesize = get_filesize (filename);
  if (filesize == -1)
    file_error (filename);

  buff = farmalloc (filesize);
  if (buff == NULL || tile == NULL)
    alloc_error ();

  f = fopen (filename, "rb");
  farfread (buff, filesize, 1, f);
  fclose (f);

  alloc_object (object_width, object_height);

  for (y = 0; y < 256; y += 20)
    for (x = 0; x < 320; x += 20)
      {

	for (i = 0; i < height; i++)
	  for (j = 0; j < (width * 4); j++)
	    *(tile + j + i * width * 4 + 2) = *(buff + j + i * 320 + y * 320 + x);

	LBMWidth (tile) = 20;
	LBMHeight (tile) = 20;
	x_bm_to_pbm (tile, PAC.Images[dim1][dim2]);

	if ((dim1 == dim1_maxpics - 1) && (dim2 == dim2_maxpics - 1))
	  goto fini;

	dim2++;
	dim2 %= 7;
	dim1 += (dim2 == 0);

      }
fini:

  farfree (buff);
  farfree (tile);

#undef filename
#undef width
#undef height

}
/*-------------------------------------------------------------------------*/
void load_ghosts_images (void)
{
  /* load images and prepare data in memory */

#define width 5
#define height 23
#define filename "GHOSTS.DAT"

  FILE *f;
  char far *buff;
  char far *tile = farmalloc (4 * width * height + 20);
  int x, y, i, j, dim1 = 0, dim2 = 0, ghost;
  long filesize;

  filesize = get_filesize (filename);
  if (filesize == -1)
    file_error (filename);
  buff = farmalloc (filesize);
  if (buff == NULL || tile == NULL)
    alloc_error ();

  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);
  farfread (buff, filesize, 1, f);
  fclose (f);

  for (i = 1; i < 5; i++)
    alloc_object (object_width, height);

 /*----------------------------------------*/
  for (ghost = 0; ghost < 4; ghost++)
    {

      for (dim1 = 0, dim2 = 0, y = ghost * height * 2; y < ghost * height * 2 + height * 2; y += height)
	for (x = 0; x < 320; x += (width * 4))
	  {

	    for (i = 0; i < height; i++)
	      for (j = 0; j < (width * 4); j++)

		*(tile + j + i * width * 4 + 2) = *(buff + j + i * 320 + y * 320 + x);

	    LBMWidth (tile) = width * 4;
	    LBMHeight (tile) = height;
	    x_bm_to_pbm (tile, objects[ghost + 1].Images[dim1][dim2]);

	    if (dim1 == dim1_maxpics - 1 && dim2 == dim2_maxpics - 1 - 1)
	      goto fini0;
	    dim2++;
	    dim2 %= 6;
	    dim1 += (dim2 == 0);
	  }
    fini0:

    }
   /*----------------------------------------*/

  farfree (buff);
  farfree (tile);

#undef filename
#undef width
#undef height

}
/*-------------------------------------------------------------------------*/
void load_palette (char far * palette_buffer, char *filename)
{

  /* loads a palette file into palette_buffer */

#define infilesize 768
  FILE *f;

  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);

  farfread (palette_buffer, infilesize, 1, f);
  fclose (f);

#undef infilesize
}
/*-------------------------------------------------------------------------*/
void load_gums_images (void)
{

  /* load images and prepare data in memory */

#define width 5
#define height 20

  FILE *f;
  char far *buff;
  char far *tile = farmalloc (4 * width * height + 20);
  int x, y, i, j, dim1 = 0, filesize;

  filesize = get_filesize ("GUMS.DAT");

  if (filesize == -1)
    file_error ("GUMS.DAT");
  buff = farmalloc (filesize);
  if (buff == NULL || tile == NULL)
    alloc_error ();

  f = fopen ("GUMS.DAT", "rb");
  if (!f)
    file_error ("GUMS.DAT");
  farfread (buff, filesize, 1, f);
  fclose (f);

  for (i = 0; i < MAX_GUMS_IMAGES; i++)
    {
      gums_images[i] = farmalloc (4 * width * height + 20);
      if (gums_images[i] == NULL)
	alloc_error ();
    }

  for (y = 0; y < 200; y += 20)
    for (x = 0; x < 320; x += 20)
      {

	for (i = 0; i < height; i++)
	  for (j = 0; j < (width * 4); j++)
	    *(tile + j + i * width * 4 + 2) = *(buff + j + i * 320 + y * 320 + x);

	LBMWidth (tile) = 20;
	LBMHeight (tile) = 20;

	x_bm_to_pbm (tile, gums_images[dim1]);

        if (dim1++ == MAX_GUMS_IMAGES - 1)
	  goto fini;
      }
fini:

  farfree (buff);
  farfree (tile);

#undef width
#undef height

}
/*-------------------------------------------------------------------------*/
void load_levels (void)
{

  /* load levels raw data. no control ! */

  FILE *f;
  int x, y, i, j, filesize, ptr;

  filesize = get_filesize ("LEVELS.DAT");
  if (filesize == -1)
    file_error ("LEVELS.DAT");
  levels_buffer = farmalloc (filesize);
  if (levels_buffer == NULL)
    alloc_error ();

  f = fopen ("LEVELS.DAT", "rb");
  farfread (levels_buffer, filesize, 1, f);
  fclose (f);

  level_number_max = filesize / sizeof (LEVEL);
}
/*-------------------------------------------------------------------------*/
void load_bonus_images (void)
{

  /* load images and prepare data in memory */

#define width 5
#define height 20
#define filename "BONUS.DAT"

  FILE *f;
  char far *buff;
  char far *tile = farmalloc (4 * width * height + 20);
  int x, y, i, j, dim1 = 0, filesize;

  filesize = get_filesize (filename);

  if (filesize == -1)
    file_error (filename);
  buff = farmalloc (filesize);
  if (buff == NULL || tile == NULL)
    alloc_error ();

  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);
  farfread (buff, filesize, 1, f);
  fclose (f);

  for (i = 0; i < MAX_BONUS_IMAGES; i++)
    {
      bonus_images[i] = farmalloc (4 * width * height + 20);
      if (bonus_images[i] == NULL)
	alloc_error ();
    }

  for (y = 0; y < 200; y += 20)
    for (x = 0; x < 320; x += 20)
      {

	for (i = 0; i < height; i++)
	  for (j = 0; j < (width * 4); j++)
	    *(tile + j + i * width * 4 + 2) = *(buff + j + i * 320 + y * 320 + x);

	LBMWidth (tile) = 20;
	LBMHeight (tile) = 20;

	x_bm_to_pbm (tile, bonus_images[dim1]);

        if (dim1 == MAX_BONUS_IMAGES - 1)
	  goto fini;

	dim1++;
      }
fini:

  farfree (buff);
  farfree (tile);

#undef width
#undef height
#undef filename

}
/*-------------------------------------------------------------------------*/
void load_gameover_image (void)
{

  /* load image and prepare data in memory */

#define width 42
#define height 29
#define filename "GAMEOVER.DAT"

  FILE *f;
  char far *buff;
  char far *tile = farmalloc (4 * width * height + 20);
  int i, j, filesize;

  filesize = get_filesize (filename);

  if (filesize == -1)
    file_error (filename);
  buff = farmalloc (filesize);
  if (buff == NULL || tile == NULL)
    alloc_error ();

  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);
  farfread (buff, filesize, 1, f);
  fclose (f);

  gameover_pbm = farmalloc (4 * width * height + 20);

  for (i = 0; i < height; i++)
    for (j = 0; j < (width * 4); j++)
      *(tile + j + i * width * 4 + 2) = *(buff + j + i * 320);

  LBMWidth (tile) = width * 4;
  LBMHeight (tile) = height;

  x_bm_to_pbm (tile, gameover_pbm);

  farfree (buff);
  farfree (tile);

#undef filename
#undef width
#undef height
}
/*-------------------------------------------------------------------------*/
void load_all_palettes (void)
{

  /* top level function */

  game_palette = farmalloc (768);
  if (game_palette == NULL)
    alloc_error ();
  load_palette (game_palette, "PALETTE.DAT");

}
/*-------------------------------------------------------------------------*/
void loading_sequence (void)
{

  /* top level function to do all the necessary loading */

  load_all_palettes ();
  load_pacman_images ();
  load_ghosts_images ();
  load_gums_images ();
  load_bonus_images ();
  load_walls_images ();
  load_levels ();
  load_gameover_image ();

}
/*-------------------------------------------------------------------------*/

