      /*-------------------------------------------------------------------*/
     /*  author: Nadir Boussoukaia                                        */
    /*    on june 1993                                                   */
   /*                                                                   */
  /*        main() test program for intro part.                        */
 /*                                                                   */
/*-------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <alloc.h>
#include <dos.h>
#include <mem.h>
#include <math.h>

#include <Xlib_all.h>
#include <keyboard.h>

extern void load_intro_stuff (void);
extern BYTE intro_screen (void);

  /*-----------------------------------------------------------------------*/
 /*                    general datas                                      */
/*-----------------------------------------------------------------------*/
#define TRUE 1
#define FALSE 0

typedef char far *image_ptr;

/*-------------------------------------------------------------------------*/
/* renvoie la taille du fichier. En cas d'erreur (genre fichier non trouv)
   renvoie -1                                                              */
/* returns sizeof file. on error (like file not found) returns -1          */

long get_filesize (char *filename)
{
  long infilesize;
  FILE *fi;

  fi = fopen (filename, "rb+");
  if (!fi)
    return (-1);

  fseek (fi, 0, SEEK_END);
  infilesize = ftell (fi);

  fclose (fi);
  return infilesize;
}

/*-------------------------------------------------------------------------*/
void farfread (void far * destptr, size_t size, size_t n, FILE * fp)
{
#define BUFF_LEN 100
  unsigned len;
  unsigned char buff[BUFF_LEN];
  len = size * n;

  while (len >= BUFF_LEN)
    {
      fread (buff, BUFF_LEN, 1, fp);

      movedata ((unsigned) _DS, (unsigned) buff, FP_SEG (destptr), FP_OFF (destptr), BUFF_LEN);

      len -= BUFF_LEN;
      (char far *) destptr += BUFF_LEN;
    }
  if (len > 0)
    {
      fread (buff, len, 1, fp);
      movedata ((unsigned) _DS, (unsigned) buff, FP_SEG (destptr), FP_OFF (destptr), len);
    }
};
/*-------------------------------------------------------------------------*/
/* error exit function */
void alloc_error (void)
{
  int i;

  x_text_mode ();
  printf ("memory allocation error...");
  for (i = 0; i < 100; i++)
    x_wait_vsync ();
  printf ("Press a key to quit.\n");
  wait_key;

  exit (-1);
}
/*-------------------------------------------------------------------------*/
/* error exit function */
void file_error (char *filename)
{
  int i;

  x_text_mode ();
  printf ("File error on %s ... ", filename);
  for (i = 0; i < 100; i++)
    x_wait_vsync ();
  printf ("Press a key to quit.\n");
  wait_key;

  exit (-1);
}
/*-------------------------------------------------------------------------*/
void load_palette (char far * palette_buffer, char *filename)
{
  FILE *f;

  f = fopen (filename, "rb");
  if (!f)
    file_error (filename);

  farfread (palette_buffer, 768, 1, f);		//256*3

  fclose (f);

}
/*-------------------------------------------------------------------------*/

void main (void)
{
  Install_Keyboard_Handler ();
  Set_JoyPad1 (Key_Ctrl, Key_N, Key_Up_arrow, Key_Down_arrow, Key_Right_arrow, Key_Left_arrow);
  Set_JoyPad_Type (2);

  load_intro_stuff ();
  intro_screen ();

  Remove_Keyboard_Handler ();
  x_text_mode ();
  exit (0);
}


