
      /********************************************************************/
     /*                                                                  */
    /*                             PACMAN V0.046                        */
   /*                                                                  */
  /*  author: Nadir Boussoukaia             all rights reserved.      */
 /*   on june 1993                                                   */
 /*                                                                  */
 /*   ahem, i'm not really proud of this code.                       */
 /*   When i started this, i didn't knew anything about P.C. coding, */
 /*   and about C coding.                                            */
 /*   So view it from this point of view.                            */
 /*   nothing garanteed. use it as an "as is" basis.                 */
 /*                                                                  */
 /*   this really is my first C program. And i fucked all of this    */
 /*   crapy code in two week. Not to bad for a "beginner"...         */
 /*                                                                  */
/********************************************************************/

/*
   special keys during game:

   P        = pause
   Ctrl+N   = next level
   N+L      = add lives
   esc      = exit
   arrows   = pacman
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>
#include <mem.h>
#include "Xlib_all.h"

#include <xtra.h>
#include <keyboard.h>

void init_game_screen(void);

extern void load_intro_stuff (void);
extern BYTE intro_screen(void);
extern void hiscore_screen (void);
extern void load_hiscore_stuff (void);
extern void save_hiscore_table (void);

  /*-----------------------------------------------------------------------*/
 /*           data generales  / general data                              */
/*-----------------------------------------------------------------------*/
#define TRUE 1
#define FALSE 0
#define DWORD unsigned long
#define WORD  unsigned int
#define CLS(Page) x_rect_fill(0,0,319,239,Page,0);

int new_direction, new_step;	/* of PACMAN */

DWORD score;
char far *game_palette;
char far *gameover_pbm;

BYTE VBL_TIME = 0;
BYTE EXIT_GAME = FALSE;
BYTE EXIT_LEVEL= FALSE;
  /*-----------------------------------------------------------------------*/
 /*                    data des sprites /sprites data                     */
/*-----------------------------------------------------------------------*/
#define MAX_OBJECTS  7
#define object_width 5
#define object_height 20
#define dim1_maxpics 5
#define dim2_maxpics 7

typedef char far *image_ptr;

typedef struct
  {
    int X, Y;
    int XOtherPage, YOtherPage;
    int Width, Height;  /* needed for bg refresh */
    int direction, step; /* direction is vertical or horizontal */
    image_ptr Images[dim1_maxpics][dim2_maxpics];
  }
AnimatedObject;

AnimatedObject objects[MAX_OBJECTS];
int object_count = 0;

/* for pacman object */
#define PAC objects[0]
int old_direction, old_step;
WORD image_number = 32700;
int PACMAN_IS_DEAD;  /* boolean */

#define vertical   1   /* used for direction */
#define horizontal 2   /* could be enum'ed */

/* i don't remember what is this */
/* -> it's map coordinates of all objects. the second dimension
      contains modulo part of the coordinates ( i planned to do
      calculation into one instruction in asm ) but never did it
      ( 486 processor power was far above what i expected !) */
#define coord 0
#define mod   1
char map_x[2][MAX_OBJECTS], map_y[2][MAX_OBJECTS];

char collisions_on;  /* a boolean */
  /*-----------------------------------------------------------------------*/
 /*                    data des levels  / levels data                     */
/*-----------------------------------------------------------------------*/
 /* special characters */
#define EMPTYNESS  ' '
#define WALL   177		/* '' */
#define GUM   'G'
#define BIGUM 'B'
#define SECRET_PASSAGE 178	/* '' */
#define CLOSET_DOOR 219		/* '' */

int level_number, pacman_lives;
int nb_gums;

  /* converts LEVELMAP coords into graphical coords */
#define MAP2GFX(X) (X*20+(X+1)*4)	/* conversion de coordonnes LEVELMAP
					   en coordonnes GRAPHIQUE */
/*
   explanations :

   map blocs are 24x24, or (20+4)*(20+4)
   each bloc contains void part(20x20) plus walls definition at one side (4x4)

   +-----4-------+
   |+------------+
   4|            |      have a look into walls.lbm
   ||  20x20     |
   ||            |
   ||            |
   +-------------+
*/

#define ClosetX MAP2GFX(6)	/* closet coordinates */
#define ClosetY MAP2GFX(4)

/* have a look at gums.lbm */
#define MAX_GUMS_IMAGES 32
image_ptr gums_images[MAX_GUMS_IMAGES];

/*  have a look into walls.lbm.
    a "wall set" is a group of 16 primitives. it's a binary decomposition.
 */
#define MAX_WALLS_SET 5
image_ptr walls_sets_images[MAX_WALLS_SET][16];

struct LEVEL_STRUCTURE
  {                            /* this correspond to levels.asm structures */
    unsigned char MAP[19][27]; /* hardcoded cos of screen & map size */
    WORD gum_image_number;
    WORD biggum_image_number;
    WORD walls_set_number;
    WORD delay_in_closet;
    WORD afraid_delay;
  }
LEVEL;

unsigned char far *levels_buffer;
int level_number_max;

  /*-----------------------------------------------------------------------*/
 /*                 Data des bonus / bonuses data                         */
/*-----------------------------------------------------------------------*/
#define BonusX MAP2GFX(6)       /* bonus appearing coordinates */
#define BonusY MAP2GFX(5)

#define MAX_BONUS_IMAGES 40
#define STATUS_HIDDEN  1
#define STATUS_VISIBLE 0
#define BONUS_HIDDEN_DELAY 50*12
#define BONUS_VISIBLE_DELAY 50*10

image_ptr bonus_images[MAX_BONUS_IMAGES];
WORD bonus_delay;

unsigned char bonus_number, bonus_status;

int special_bonus_delay, pacman_speed_shl_value = 0;
int points_multiplicator;

   /*-----------------------------------------------------------------------*/
  /*                 Data du passage secret                                */
 /*                 Data for secret passage                               */
/*-----------------------------------------------------------------------*/
WORD secret_passage_controller[MAX_OBJECTS];
/* delay were sprites are inside the passage ( not visible ) */
#define GHOSTS_TIME 100		/* nombre de frames que dure 'le passage' */
			      /* number of frames of passage 'duration' */
#define PACMAN_TIME 50

    /*-----------------------------------------------------------------------*/
   /*                 Les (petits) cerveaux des GHOSTS                      */
  /*                 The (small) GHOSTS's brains                           */
 /* everything is here: a 3x3 decision matrix                             */
/*-----------------------------------------------------------------------*/

#define LEFT    horizontal*-1
#define RIGHT   horizontal* 1
#define UP      vertical*-1
#define DOWN    vertical* 1

/* comportement means behavior in french */
int comportement[4][3][3]=
{
  {{LEFT,UP,RIGHT}, {LEFT,UP,RIGHT}, {LEFT,DOWN,RIGHT} },
  {{UP  ,UP,UP   }, {LEFT,UP,RIGHT}, {DOWN,DOWN,DOWN } },
  {{UP  ,UP,RIGHT}, {LEFT,UP,RIGHT}, {LEFT,DOWN,DOWN } },
  {{LEFT,UP,UP   }, {LEFT,UP,RIGHT}, {DOWN,DOWN,RIGHT} }
};

typedef enum
  {
    Dressed, Nude, Afraid, Glued, Locked
  }
GHOST_STATUS;

typedef struct
  {
    GHOST_STATUS Status;
    WORD State_delay;
    WORD Silly_count;
    WORD Silly_coeff;
  }
GHOST_FEATURE;

GHOST_FEATURE Ghost[4];

/*-------------------------------------------------------------------------*/
void WAIT_KEY (void)
{
  wait_key;
}
/*-------------------------------------------------------------------------*/
void alloc_error (void)
{
    /* deadly end function */
  int i;

  x_text_mode ();
  printf ("memory allocation error...");
  for (i = 0; i < 50; i++)
    x_wait_vsync ();
  printf ("Press a key to quit.\n");
  WAIT_KEY ();

  exit (-1);
}
/*-------------------------------------------------------------------------*/
/* initialize a new object (with buffers allocation) */

void alloc_object (int width, int height)
{
  int i, j;
#define CURRENT objects[object_count]

  CURRENT.Width = width;
  CURRENT.Height = height;

  for (i = 0; i < dim1_maxpics; i++)
    for (j = 0; j < dim2_maxpics; j++)
      {
	CURRENT.Images[i][j] = farmalloc (4 * width * height + 20);
	if (CURRENT.Images[i][j] == NULL)
	  alloc_error ();
      }

  object_count++;

#undef CURRENT
}

/*-------------------------------------------------------------------------*/
// ahem...
#include "filacces.c"
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* alloc_object doit avoir ete appele auparavant !  */
/*    width & height sont iniitialiss              */

/* alloc_object must be called before !             */
/*    width & height are initialized.               */

void init_object (int object_number, int x, int y, int direction, int step)
{

#define CURRENT objects[object_number]

  CURRENT.X = CURRENT.XOtherPage = x;
  CURRENT.Y = CURRENT.YOtherPage = y;
  CURRENT.direction = direction;
  CURRENT.step = step;

#undef CURRENT
}
/*-------------------------------------------------------------------------*/
void MoveObject (int object_number)
{

#define CURRENT objects[object_number]

  /* Remember previous location for erasing purposes */
  CURRENT.XOtherPage = CURRENT.X;
  CURRENT.YOtherPage = CURRENT.Y;

  if (object_number) /*---> si c'est un ghost/ if it's a ghost */
                     /* object_number == 0 is reserved for pacman */
    switch (Ghost[object_number - 1].Status)
      {
      case Locked:  /* do not move .... */
                    break;
      case Nude:  /* on nude state ( only eyes visible ), speed is *2 */
                    if (CURRENT.direction == vertical)
                      CURRENT.Y += CURRENT.step << 1;
                    else
                      CURRENT.X += CURRENT.step << 1;

                    /* step=2 -> if faut X&Y pair! */
                    /* step=2 -> there must be X&Y pair! */
                    CURRENT.Y &= 0xfFFE;
                    CURRENT.X &= 0xfFFE;

                    break;

      case Glued:   /* move speed is divided by two */
      case Afraid:  /* ghost move every two frames */
                    if (image_number & 1)
                      break;
                    /* else continue with default */
      default:
                    /* moves depending on direction and step */
                    if (CURRENT.direction == vertical)
                      CURRENT.Y += CURRENT.step;
                    else
                      CURRENT.X += CURRENT.step;
      }

  else /* c'est PACMAN / it's pacman */
       /* moves depending on direction and step */
  if (CURRENT.direction == vertical)
    CURRENT.Y += CURRENT.step << pacman_speed_shl_value;
  else
    CURRENT.X += CURRENT.step << pacman_speed_shl_value;

  /* des fois, les yeux (status=nude) sortent de la grille. j'ai essay de
     le debugger, mais cela ne devrait pas se faire. etant donn que je ne
     comprend pas, et que j'en ai marre de me faire chier pour rien, voici
     ces 4 ELEGANTS tests qui vont rsoudre bovinement mon probleme.       */

  /* sometimes, eyes (status=nude) go out from the grid. i've tried to debug
     it, but this simply could not be (!). as i do not understand, and i'm
     fed up with this useless work, here there are 4 elegant control that
     will resolve cowly(this word exists?) the problem. */

  if (CURRENT.Y > MAP2GFX (8)) CURRENT.Y = MAP2GFX (9);
  if (CURRENT.Y < MAP2GFX (0)) CURRENT.Y = MAP2GFX (0);
  if (CURRENT.X > MAP2GFX (12)) CURRENT.X = MAP2GFX (12);
  if (CURRENT.X < MAP2GFX (0))  CURRENT.X = MAP2GFX (0);

#undef CURRENT
}
/*-------------------------------------------------------------------------*/
void animate_sprites (void)
{
  int i;
  /* refresh sprite background (triple buffer) */
  for (i = object_count - 1; i >= 0; i--)
    x_cp_v2v_fast (objects[i].XOtherPage, objects[i].YOtherPage, 24, 24,
		   NonVisual_Offs, HiddenPageOffs);

  image_number++; /* frame counter */

  for (i = 0; i < object_count; i++)
    if (secret_passage_controller[i])
      {
        /* if current object is inside secret passage,
           don't move it. when delay counter reaches back 0,
           changes sprites position from one side to another
           */
        if (--secret_passage_controller[i] == 0)
        objects[i].X = (objects[i].X == MAP2GFX (0)) ? MAP2GFX (12) - 2 : MAP2GFX (0) + 2;
       }
       else
        MoveObject (i);

    /*=================================*/
   /*               BONUS             */
 /*=================================*/

 /* display bonus if there is */
  x_cp_v2v_fast (BonusX, BonusY, 20, 20, NonVisual_Offs, HiddenPageOffs);

    /*=================================*/
   /*               PACMAN            */
  /*=================================*/

  if (secret_passage_controller[0] == 0)
    {
      /* if pacman is not inside secret passage,
         display its image  */

      i = (PAC.direction * PAC.step + 2);
      if (i != 2)
	{
	  x_put_masked_pbm (PAC.X, PAC.Y, HiddenPageOffs,
			    PAC.Images[i][image_number % 7]);
	}
      else
        { /* if direction or step is null, then pacman is stopped
             don't animate it.
             */

	  x_put_masked_pbm (PAC.X, PAC.Y, HiddenPageOffs,
			    PAC.Images[old_direction * old_step + 2][0]);
	};
    }
      /*=================================*/
    /*               GHOSTS            */
  /*=================================*/

  for (i = 1; i < 5; i++)
    if (secret_passage_controller[i] == 0)
      /* if it is not inside secret passage, display its image  */
      switch (Ghost[i - 1].Status)
	{
	case Afraid:

         /* doing scale like "(image_number >> 2)" makes image animation four time
            slower (understood what ?)
             there are six frames for each direction of ghost
             */
	  x_put_masked_pbm (objects[i].X, objects[i].Y, HiddenPageOffs,
			    objects[((Ghost[i - 1].State_delay < 100) ? 3 : 1)].Images[2][(image_number >> 2) % 6]);
	  break;

	case Locked:
	case Glued:
	case Dressed:
	  x_put_masked_pbm (objects[i].X, objects[i].Y, HiddenPageOffs,
                            objects[i].Images[objects[i].direction * objects[i].step + 2][(image_number >> 1) % 6]);
	  break;
	case Nude:
	  x_put_masked_pbm (objects[i].X, objects[i].Y, HiddenPageOffs,
			 objects[2].Images[0 + 2][(image_number >> 2) % 6]);
	  break;
	}
}
/*-------------------------------------------------------------------------*/
void x_clr_pbm (char far * bg)
{
  register char far *i;
  WORD max = bg[0] * 4 * bg[1];

  for (i = bg + 2; i < (bg + max); i++)
    *i = 0;
}
/*-------------------------------------------------------------------------*/
void draw_grid (void)
{

  int map_x, map_y, tile_number;

    /*------> il faudra penser a controler walls_set_number ! */
    /*------> in future, think about controlling "walls_set_number" ! */
  LEVEL.walls_set_number %= MAX_WALLS_SET;

  x_rect_fill (0, 0, 320, 240, NonVisual_Offs, 0);

  for (map_y = 0; map_y < 19; map_y += 2)
    for (map_x = 0; map_x < 27; map_x += 2)
      {
        /*  calculate the tile_number from 4 chars of the level definitions
            4chars-> 2**4 possibilities */
        tile_number = ((map_x == 26) ? 0 : (LEVEL.MAP[map_y][map_x + 1] == WALL) << 3)
	  | ((map_y == 18) ? 0 : (LEVEL.MAP[map_y + 1][map_x] == WALL) << 2)
	  | ((map_x == 0) ? 0 : (LEVEL.MAP[map_y][map_x - 1] == WALL) << 1)
	  | ((map_y == 0) ? 0 : (LEVEL.MAP[map_y - 1][map_x] == WALL));

	x_put_masked_pbm_clipx (map_x / 2 * 24, map_y / 2 * 24, NonVisual_Offs,
		    walls_sets_images[LEVEL.walls_set_number][tile_number]);
      }
}
/*-------------------------------------------------------------------------*/
void draw_gums (void)
{
    /* draw gums into screen map (after walls are drawn)
        depending on level map definitions.
    */
  int x, y, xs, ys;

  nb_gums = 0;

  for (y = 1; y < 19; y += 2)  /* 19 and 27 are hardcoded. see above*/
    for (x = 1; x < 27; x += 2)
	if (LEVEL.MAP[y][x] == GUM || LEVEL.MAP[y][x] == BIGUM)
	  {
	    xs = (x - 1) / 2;
	    ys = (y - 1) / 2;
	    x_put_pbm (MAP2GFX (xs), MAP2GFX (ys), NonVisual_Offs,
                       gums_images[(LEVEL.MAP[y][x] == GUM) ?
                       LEVEL.gum_image_number : LEVEL.biggum_image_number]);

	    nb_gums++;
	  }
}

/*-------------------------------------------------------------------------*/
void clear_objects (void)
{
    /* clears ojects from the display */
  int i;

  for (i = 0; i < object_count; i++)
    x_cp_v2v_fast (objects[i].XOtherPage, objects[i].YOtherPage, 24, 24,
		   NonVisual_Offs, HiddenPageOffs);

  x_page_flip (0, 0);
  for (i = 0; i < object_count; i++)
    x_cp_v2v_fast (objects[i].X, objects[i].Y, 24, 24, NonVisual_Offs, HiddenPageOffs);

}
/*-------------------------------------------------------------------------*/
void calc_level_coordinates (void)
{
    /* it's map coordinates of all objects. the second dimension
      contains modulo part of the coordinates */
  int i;

  for (i = 0; i < object_count; i++)
    {
      map_x[coord][i] = (objects[i].X - 4) / 12 + 1;
      map_y[coord][i] = (objects[i].Y - 4) / 12 + 1;

      map_x[mod][i] = (objects[i].X - 4) % 24;
      map_y[mod][i] = (objects[i].Y - 4) % 24;
    }
}
/*-------------------------------------------------------------------------*/
void reset_special_bonus_things (void)
{
   /* resets bonuses swithes and values.
      called at realtime.
      */

  register i;

  pacman_speed_shl_value = 0;
  special_bonus_delay = 0;
  points_multiplicator = 1;
  collisions_on = TRUE;

  for (i = 0; i < 4; i++)
    if (Ghost[i].Status == Glued || Ghost[i].Status == Locked)
      Ghost[i].Status = Dressed;

}
/*-------------------------------------------------------------------------*/
void reset_bonus_things (void)
{
   /* clears bonus displaying if there is.
      called at realtime.
      */

  x_rect_fill (BonusX, BonusY, BonusX + 20, BonusY + 20, NonVisual_Offs, 0);
  x_rect_fill (BonusX, BonusY, BonusX + 20, BonusY + 20, HiddenPageOffs, 0);

  LEVEL.MAP[5 * 2 + 1][6 * 2 + 1] = EMPTYNESS;
  bonus_status = STATUS_HIDDEN;
  bonus_delay = BONUS_HIDDEN_DELAY;
}
/*-------------------------------------------------------------------------*/
void init_new_game (void)
{
  level_number = 0;
  pacman_lives = 3;
  score = 0;

  EXIT_GAME = FALSE;
}
/*-------------------------------------------------------------------------*/
void init_new_level (void)
{
  int x, y, ptr;

  fade_screen (game_palette, 10, TO_BLACK);

  /* gets new level definition (pretty lame fashion) */
  ptr = level_number * sizeof (LEVEL);

  for (y = 0; y < 19; y++)
    for (x = 0; x < 27; x++)
      LEVEL.MAP[y][x] = levels_buffer[ptr++];

  /* this is a word value (why i'e done this in two instructions?)*/
  LEVEL.gum_image_number = levels_buffer[ptr++];
  LEVEL.gum_image_number += levels_buffer[ptr++] << 8;

  /* this is a word value (why i'e done this in two instructions?)*/
  LEVEL.biggum_image_number = levels_buffer[ptr++];
  LEVEL.biggum_image_number += levels_buffer[ptr++] << 8;

  /* this is a word value (why i'e done this in two instructions?)*/
  LEVEL.walls_set_number = levels_buffer[ptr++];
  LEVEL.walls_set_number += levels_buffer[ptr++] << 8;

  /* this is a word value (why i'e done this in two instructions?)*/
  LEVEL.delay_in_closet = levels_buffer[ptr++];
  LEVEL.delay_in_closet += levels_buffer[ptr++] << 8;

  /* this is a word value (why i'e done this in two instructions?)*/
  LEVEL.afraid_delay = levels_buffer[ptr++];
  LEVEL.afraid_delay += levels_buffer[ptr++] << 8;

   /* this was planned to be setted from outside */

  Ghost[0].Silly_coeff = (1 << 5) - 1;	/* ROUGE  :red */
  Ghost[1].Silly_coeff = (1 << 4) - 1;	/* VERT   :green */
  Ghost[2].Silly_coeff = (1 << 3) - 1;	/* VIOLET :magenta */
  Ghost[3].Silly_coeff = (1 << 1) - 1;	/* JAUNE  :yellow */

/*
   table of possible Silly_coeff:
   regle: toute les "Silly_coeff" decisions,il tire au hasard
   rule: this value means
   <every "Silly_coeff" decision making, it make it randomly instead>

   x=0 --> coeff=0  --> TRES CON / VERY SILLY
   x=1 --> coeff=1
   x=2 --> coeff=3
   x=3 --> coeff=7
   x=4 --> coeff=15
   x=5 --> coeff=31
   x=6 --> coeff=63
   x=7 --> coeff=127 --> LE PLUS MECHANT / VERY BAD
 */

  x_rect_fill (0, 0, 319, 239, HiddenPageOffs, 0);
  draw_grid ();
  draw_gums ();

  /* drawings are done on NonVisual_Offs. copy the third buffer
     onto the 2 others */
  x_cp_page (NonVisual_Offs, HiddenPageOffs);
  x_cp_page (HiddenPageOffs, VisiblePageOffs);

  x_printf ((320 - 8 * 8) / 2, ClosetY + 6,
            VisiblePageOffs, 255, "LEVEL %u", level_number + 1);

  /* make all of this visible */
  fade_screen (game_palette, 10, FROM_BLACK);
  WAIT_KEY ();

  /* clears first buffer again */
  x_cp_page (HiddenPageOffs, VisiblePageOffs);

  /* will go to next level next time */
  level_number++;
  level_number %= level_number_max;

  EXIT_LEVEL = FALSE;
}
/*-------------------------------------------------------------------------*/
void update_lifemeter (void)
{
  /* the printing is done on both buffer (making use of
     my fast copy routine) */

  x_rect_fill (320 - 8 * 8, MAP2GFX (9), 320, MAP2GFX (9) + 8, HiddenPageOffs, 0);
  x_printf (320 - 8 * 8, MAP2GFX (9), HiddenPageOffs, 255, "Lives:%i", pacman_lives);

  x_cp_v2v_fast (320 - 8 * 8, MAP2GFX (9), 8 * 8, 8, HiddenPageOffs, VisiblePageOffs);
}
/*-------------------------------------------------------------------------*/
void display_score (void)
{
  int i;
  /*----------- affiche le score / displays score -------------*/
  x_rect_fill (0, MAP2GFX (9), 160, MAP2GFX (9) + 8, HiddenPageOffs, 0);
  x_printf (0, MAP2GFX (9), HiddenPageOffs, 255, "Score:%-lu", score);

/*
   // 4debug, displays ghost coords
   x_rect_fill(0,MAP2GFX(9)+8,320,MAP2GFX(9)+16,HiddenPageOffs,0);
   for (i=1;i<5;i++)
   x_printf(i*8*8-30,MAP2GFX(9)+8,HiddenPageOffs,255,"%i:%i",objects[i].X,objects[i].Y);
*/

}
/*-------------------------------------------------------------------------*/
void init_new_life (void)
{
  int i;

  PACMAN_IS_DEAD = FALSE;

  /* pacman under the closet */
  init_object (0, MAP2GFX (6), MAP2GFX (6), horizontal, 1);

  /* all ghosts inside the closet */
  for (i = 1; i < 5; i++)
    init_object (i, MAP2GFX (5) + (i - 1) * 15, MAP2GFX (4), horizontal, 1);

  /* resets secret_passage_controller */
  for (i = 0; i < object_count; i++)
    secret_passage_controller[i] = 0;

  /* clear all ghosts's state */
  for (i = 0; i < 4; i++)
    {
      Ghost[i].Status = Dressed;
      Ghost[i].State_delay = (i + 1) * LEVEL.delay_in_closet;
    }

  update_lifemeter ();
  reset_bonus_things ();
  x_rect_fill (BonusX, BonusY, BonusX + 20, BonusY + 20, VisiblePageOffs, 0);
  reset_special_bonus_things ();
}
/*-------------------------------------------------------------------------*/
void keyboard_handling (void)
{
 /* do general keyboard input */

  //------8421-------- 8421   bitmask of joypad1
  //------UDRL-------- HBDG

  /*----------> out: sets new_direction & new_step */
  /*            interpreted from outside.          */
  new_direction = 0;
  new_step = 0;

  if ((JoyPad1 & 3))
    new_direction = horizontal;
  if (JoyPad1 & 12)
    new_direction = vertical;
  if (JoyPad1 & 9)
    new_step = -1;
  if (JoyPad1 & 6)
    new_step = 1;

  if (Inkey == Key_L && Joy_Fire1 (JoyPad1)) /* cheat:ctrl+l*/
    {
      pacman_lives++;
      update_lifemeter ();
    }

  if (Inkey == Key_Esc) EXIT_GAME = TRUE;
  if (Inkey == Key_P) WAIT_KEY ();

  if (Inkey == Key_V)   /* vbl benchmark */
    {
      VBL_TIME = !VBL_TIME;
      x_set_rgb (0, 0, 0, 0);
    }

      if (Joy_Fires (JoyPad1) == 3)
      EXIT_LEVEL = TRUE;          //cheat = next level on ctrl+n

}
/*-------------------------------------------------------------------------*/
void pacman_processing (void)
{
  /* do wall testing only when pacman 's block map has changed
     (it's really fast because it occurs only every 24 frames) */
  if (map_x[mod][0] == 0 && map_y[mod][0] == 0
      && secret_passage_controller[0] == 0)
    {
      int tile;
      int xmap, ymap;

      xmap = map_x[coord][0];
      ymap = map_y[coord][0];

     /*-----------------------------------------------------------------*/
     /*-----> si on veut tourner, on autorise que si y'a pas de mur     */
     /*-----> if we want to turn, we permit it only if there's no wall  */
     /*-----------------------------------------------------------------*/
      if (new_direction && new_direction != PAC.direction)
	{
          /* gets side tile */
          tile = (new_direction==vertical) ? LEVEL.MAP[ymap + new_step][xmap] :
                                             LEVEL.MAP[ymap][xmap + new_step] ;
          switch (tile)
	    {
	    case CLOSET_DOOR:
	    case WALL:
	      break;

	    case SECRET_PASSAGE:
	      secret_passage_controller[0] = PACMAN_TIME;

	    default:
              PAC.step = new_step;
	      PAC.direction = new_direction;
	    }
	}

        /*-------------------------------------------------------------*/
        /*------>       test devant PACMAN si y'a un mur               */
        /*------>       test in front of PACMAN if there's a wall      */
        /*-------------------------------------------------------------*/
       /* gets forward tile */
      tile = (PAC.direction == vertical) ? LEVEL.MAP[ymap + PAC.step][xmap] :
                                           LEVEL.MAP[ymap][xmap + PAC.step];
      switch (tile)
	{
	case CLOSET_DOOR:
	case WALL:
	  // utiliss pour l'affichage du sprite
          // used for sprite display to maintain its last position
          old_step = PAC.step;
	  old_direction = PAC.direction;

          //pacman is stopped
          PAC.step = 0;
	  PAC.direction = 0;
	  break;

        case SECRET_PASSAGE:
          //pacman goes through a secret passage
	  secret_passage_controller[0] = PACMAN_TIME;
	}
    }
    /* permits half-turn at any moment !  */
  else if (new_direction == PAC.direction && new_step != PAC.step)
    PAC.step = new_step;
}
/*-------------------------------------------------------------------------*/
int signe (int i)
{ /* get sign for a 16it int */
  return (i ? ((i & 0x8000) ? -1 : 1) : 0);
};
/*-------------------------------------------------------------------------*/
void ghosts_processing (void)
{
  /* the inner (simple) ghost's brain process */

  int new_direction_sens;
  int possible_directions[3], number_of_directions = 0;
  int xmap, ymap, i, j, DX, DY;
  int forward_tile, side1_tile, side2_tile;

#define CURRENT_GHOST objects[i]

  for (i = 1; i < 5; i++)
    {				// processes all 4 ghosts

      /*-----------------------------------------------------------------*/
      /*              Fonctions de l'etat du GHOST                       */
      /*              Fonctions of GHOST's state                         */
      /*-----------------------------------------------------------------*/
      if (Ghost[i - 1].State_delay != 0)
	Ghost[i - 1].State_delay--;

        /* going back to normal state */
      if (Ghost[i - 1].State_delay == 0 && Ghost[i - 1].Status == Afraid)
	Ghost[i - 1].Status = Dressed;

      /*-----------------------------------------------------------------*/
      /*              Fonctions de decision du GHOST                     */
      /*              Fonctions of GHOST's decision                      */
      /*-----------------------------------------------------------------*/
      /* do wall testing only when ghost's block map has changed
         (it's really fast because it occurs only every 24 frames) */
      if (map_x[mod][i] == 0 && map_y[mod][i] == 0
          && secret_passage_controller[i] == 0)
	{
          switch (Ghost[i - 1].Status)
	    {
	    case Nude:
              /* eyes gone back to closet ? */
	      if (CURRENT_GHOST.Y == ClosetY && CURRENT_GHOST.X == ClosetX)
		{
		  Ghost[i - 1].Status = Dressed;
		  Ghost[i - 1].State_delay = LEVEL.delay_in_closet;
		};
	      break;

            /*--> Glued ou Afraid: on sait que si (image_number & 1)==0,
                  le fantome n'avancera pas  cette frame. Pour eviter
                  que les ghosts fassent demi-tour, il vaut mieux quitter.
                  */

            /*--> Glued ou Afraid: we know that if(image_number & 1)==0,
                  then the ghost will not move at this frame. to avoid
                  ghosts making half-turn, we better leave here. */

            case Glued:
	    case Afraid:
	      if ((image_number & 1) != 0)
		break;

	    case Locked:
              continue; // corrected while commenting...
              //return;   /*--> Gestion inutile dans ce cas ! */
                        /*--> process useless in this case ! */
	    }

         /*-----------------------------------------------------------------*/
         /*- on cherche les directions possibles que peux prendre le GHOST -*/
         /*- we search possible directions that the GHOST can take         -*/
         /*-----------------------------------------------------------------*/
          xmap = map_x[coord][i];
	  ymap = map_y[coord][i];

          number_of_directions = 0;

          switch (CURRENT_GHOST.direction)
	    {
	    case vertical:
              /* a ghost could NEVER do a go-back */
              forward_tile = LEVEL.MAP[ymap + CURRENT_GHOST.step][xmap];
	      side1_tile = LEVEL.MAP[ymap][xmap - 1];
	      side2_tile = LEVEL.MAP[ymap][xmap + 1];
	      break;

	    case horizontal:
              /* a ghost could NEVER do a go-back */
              forward_tile = LEVEL.MAP[ymap][xmap + CURRENT_GHOST.step];
	      side1_tile = LEVEL.MAP[ymap - 1][xmap];
	      side2_tile = LEVEL.MAP[ymap + 1][xmap];
	    }

	  switch (forward_tile)
	    {
	    case WALL:
	      break;

	    case SECRET_PASSAGE:
	      secret_passage_controller[i] = GHOSTS_TIME;
	      return;

	    case CLOSET_DOOR:
	      if (!(Ghost[i - 1].State_delay == 0 || Ghost[i - 1].Status == Nude))
                break; /* do not do default */
            default:
              possible_directions[number_of_directions++] =
                CURRENT_GHOST.direction * CURRENT_GHOST.step;
	    }

	  switch (side1_tile)
	    {
	    case WALL:
	      break;

	    case CLOSET_DOOR:
	      if (!(Ghost[i - 1].State_delay == 0 || Ghost[i - 1].Status == Nude))
                break; /* do not do default */
            default:
              possible_directions[number_of_directions++] =
		(CURRENT_GHOST.direction == vertical) ? LEFT : UP;
	    }

	  switch (side2_tile)
	    {
	    case WALL:
	      break;

	    case CLOSET_DOOR:
              if (!(Ghost[i - 1].State_delay == 0 || Ghost[i - 1].Status == Nude))
                break; /* do not do default */
	    default:
              possible_directions[number_of_directions++] =
		(CURRENT_GHOST.direction == vertical) ? RIGHT : DOWN;
	    }

         /*------------------------------------------------------------------*/
         /*- on choisit une direction possibles que peux prendre le GHOST   -*/
         /*- we choose one of the possible directions that the GHOST can take*/
         /*------------------------------------------------------------------*/

          /* get relative position of pacman */
          DX = signe (((Ghost[i - 1].Status == Nude) ? ClosetX : PAC.X) - CURRENT_GHOST.X) + 1;
	  DY = signe (((Ghost[i - 1].Status == Nude) ? ClosetY : PAC.Y) - CURRENT_GHOST.Y) + 1;
	  new_direction_sens = 0;

	  if (Ghost[i - 1].Status == Afraid)
	    {
	      DX = 2 - DX;
	      DY = 2 - DY;
            }; //inversion de priorit / inverts priority

          /* from relative position of pacman, and the possible moves,
             decide what direction to go depending on personality
             (means comportement==behavior) of the ghosts */
          for (j = 0; j < number_of_directions; j++)
            if (possible_directions[j] == comportement[i - 1][DY][DX])
	      {
                new_direction_sens = possible_directions[j];
		break;
	      }

              /* if none of the priority of the ghost have been choosen,
                 of if ghost becomes silly, the direction to go is
                 randomized */
	  if (new_direction_sens == 0 ||
	      ((Ghost[i - 1].Silly_count++) & Ghost[i - 1].Silly_coeff) == 0)
	    {

              if (number_of_directions != 0)
                new_direction_sens = possible_directions[random (number_of_directions)];
              else /* this must be impossible */
              /* a ghost could NEVER do a go-back */
                new_direction_sens = CURRENT_GHOST.direction * CURRENT_GHOST.step * (-1);
	    }
          /* sets final direction */
	  CURRENT_GHOST.direction = abs (new_direction_sens);
          CURRENT_GHOST.step = signe (new_direction_sens);
	}
    }
#undef CURRENT_GHOST
}

/*-------------------------------------------------------------------------*/
void bonus_appearance_processing (void)
{

  /*  at defined delays, a bonus appears or deseappear.
     this is controlled by "bonus_delay".
     realtime function.
   */

  --bonus_delay;

  if (bonus_delay == 0)
    switch (bonus_status)
      {
      case STATUS_HIDDEN:  //alors on en affiche un / then we display one

        bonus_number = random (MAX_BONUS_IMAGES);  //randomly choosed

        x_put_masked_pbm (BonusX, BonusY, NonVisual_Offs, bonus_images[bonus_number]);

	bonus_number += 'a';
	bonus_status = STATUS_VISIBLE;
	bonus_delay = BONUS_VISIBLE_DELAY;
	LEVEL.MAP[5 * 2 + 1][6 * 2 + 1] = bonus_number;
	break;

      case STATUS_VISIBLE:	//alors on le vire / then we remove it
        x_rect_fill (BonusX, BonusY, BonusX + 20, BonusY + 20, NonVisual_Offs, 0);

	LEVEL.MAP[5 * 2 + 1][6 * 2 + 1] = EMPTYNESS;
	bonus_status = STATUS_HIDDEN;
	bonus_delay = BONUS_HIDDEN_DELAY;
      }

/*------------------------------------------------------------------------*/
/*------ ici on s'occupe aussi des bonus speciaux     --------------------*/
/*------ here we also take care of special bonuses     -------------------*/
/*------------------------------------------------------------------------*/
  if (special_bonus_delay != 0)
/*--> on retablit tout aux defauts / we restablish everything into defaults */
    if (--special_bonus_delay == 0)
      reset_special_bonus_things ();
}
/*-------------------------------------------------------------------------*/
void test_collision_pacman_ghost (void)
{
  /* test wether pacman has collided with a ghost */

  register i;
#define limite object_height/2

  for (i = 1; i < object_count; i++)
    /* do a box detection. suffisient!
       when pacman is inside secret passage, nothing could appear.
    */
    if ( abs (objects[i].X - PAC.X) < limite && abs (objects[i].Y - PAC.Y) < limite &&
	(secret_passage_controller[0] | secret_passage_controller[i]) == 0)

      switch (Ghost[i - 1].Status)
	{
	case Locked:
	case Glued:
	case Dressed:
	  if (!collisions_on)
	    break;

	  PACMAN_IS_DEAD = TRUE;
	  pacman_lives--;

          for (i = 0; i < 25; i++)  /* wait a while */
	    x_wait_vsync ();
	  clear_objects ();

          /* death animation */
	  for (i = 0; i < 7; i++)
	    {
	      x_cp_v2v_fast (PAC.X, PAC.Y, 24, 24, NonVisual_Offs, VisiblePageOffs);
	      x_put_masked_pbm (PAC.X, PAC.Y, VisiblePageOffs, PAC.Images[2][i]);
	      x_wait_vsync ();
	      x_wait_vsync ();
	      x_wait_vsync ();
	    }
	  clear_objects ();
	  break;

        case Afraid:  /* ghost is eaten! it goes at reverse direction
                          from pacman */
	  Ghost[i - 1].Status = Nude;

          objects[i].step = -signe (
				    (objects[i].direction == horizontal) ?
			       PAC.X - objects[i].X : PAC.Y - objects[i].Y);
	  objects[i].X &= 0xfffc;
	  objects[i].Y &= 0xfffc;

	  score += (500) * points_multiplicator;
	};
};
/*-------------------------------------------------------------------------*/
void bonus_attributes_processing (WORD bonus_number)
{
  /* a bonus have been eaten. see what sort of bonus it is.
     and do what is to be done.
   */

  int x, y;

  if (bonus_number < 28)
    score += (bonus_number + 1) * 5000 * points_multiplicator;
  else				/* special bonuses process */
    switch (bonus_number - 28)
      {
      case 0:   /*--> JUMP : we jump to a random level */
	level_number = random (level_number_max);

	clear_objects ();

	for (y = 1; y < 19; y += 2)
	  for (x = 1; x < 27; x += 2)
	    switch (LEVEL.MAP[y][x])
	      {
	      case BIGUM:
		score += 500 - 10;
	      case GUM:
		score += 10;
		x_rect_clear (MAP2GFX ((x - 1) / 2), MAP2GFX ((y - 1) / 2), 20, 20, NonVisual_Offs);
		x_rect_clear (MAP2GFX ((x - 1) / 2), MAP2GFX ((y - 1) / 2), 20, 20, HiddenPageOffs);
		x_rect_clear (MAP2GFX ((x - 1) / 2), MAP2GFX ((y - 1) / 2), 20, 20, VisiblePageOffs);
		display_score ();
		x_page_flip (0, 0);
		x_wait_vsync ();
		x_wait_vsync ();
		x_wait_vsync ();
	      }

	nb_gums = 0;
	PACMAN_IS_DEAD = TRUE;	/*
its not true but i use the test     c'est pas vrai mais j'utilise le test
of this var which makes a break      de cette var qui fait un break dans la
in main loop. all of this only       boucle principale juste apres. tout ca
to pass over the pageflip that       pour eviter le pageflip qui fait
make sprites reappear...             reapparaitre les sprite...            */

	break;

      case 1: /*--> scores X2 */
	points_multiplicator = 2;
	special_bonus_delay = 50 * 15;
	break;

      case 2: /*--> scores X5 */
	points_multiplicator = 5;
	special_bonus_delay = 50 * 15;
	break;

      case 3: /*--> ? mystere : gets a random bonus */
	while ((bonus_number - 28) == 3)
          bonus_number = random (MAX_BONUS_IMAGES);

	bonus_attributes_processing (bonus_number);
	return;

      case 4: /*--> Clock : ghosts a stopped a while */
	special_bonus_delay = 50 * 10;
	for (x = 0; x < 4; x++)
	  if (Ghost[x].Status != Nude)
	    Ghost[x].Status = Locked;
	break;

      case 5: /*--> Couronne == scoreX5 +  SPEED + GLUE */

        /*--> scores X5 */
	points_multiplicator = 5;
	special_bonus_delay = 50 * 15;

        /*--> glue */
        for (x = 1; x < 5; x++)
	  if (Ghost[x - 1].Status != Nude)
	    Ghost[x - 1].Status = Glued;

      case 6: /*--> Speed : pacman's speed increased */
	special_bonus_delay = 50 * 15;
	pacman_speed_shl_value = 1;
	break;

      case 7: /*--> TNT : kills all ghosts on screen */
	{
	  char offset[] =
	  {2, 4, 2, 0, 2, 4, 2, 0};
	  char i;
	  //---make screen vibrations
	  for (i = 0; i < 8; i++)
	    {
	      /*x_set_rgb(0,(i&1)*63,(i&1)*63,(i&1)*63); */
	      x_set_start_addr (0, offset[i]);
	      x_wait_vsync ();
	      x_wait_vsync ();
	    }
	}
	for (x = 1; x < 5; x++)
	  if (Ghost[x - 1].Status != Nude)
	    {
	      Ghost[x - 1].Status = Nude;
	      score += (500) * points_multiplicator;
	    }
	break;

      case 8: /*--> glue : ghosts move slowly */

	special_bonus_delay = 50 * 15;
	for (x = 1; x < 5; x++)
	  if (Ghost[x - 1].Status != Nude)
	    Ghost[x - 1].Status = Glued;

	break;

      case 9: /*--> cadeau (gift) : all ghosts in afraid state */
	for (x = 0; x < 4; x++)
	  if (Ghost[x].Status != Nude)
	    {
	      Ghost[x].Status = Afraid;
	      Ghost[x].State_delay = LEVEL.afraid_delay * 2;
	    };
	break;

      case 10: /*--> protection : no collisions for a while */
	special_bonus_delay = 50 * 15;
	collisions_on = FALSE;
	break;

      case 11: /*--> extra life */
	pacman_lives++;
	update_lifemeter ();
      };

  reset_bonus_things ();
}
/*-------------------------------------------------------------------------*/
void test_collision_pacman_gums (void)
{
  /* see if pacman has eaten a pacgum.
     make use of level map for this ( no real collision detection! )
   */

  int i, xmap, ymap;

  /* if pacman has entered a new map block */
  if (map_x[mod][0] == 0 && map_y[mod][0] == 0)
    {
      xmap = map_x[coord][0];
      ymap = map_y[coord][0];

      if (LEVEL.MAP[ymap][xmap] == bonus_number)
        { /* there a bonus here ! */
	  bonus_attributes_processing (bonus_number - 'a');
	  return;
	};

      switch (LEVEL.MAP[ymap][xmap])
	{
	case BIGUM:
          /* all ghosts become afraid */
	  for (i = 0; i < 4; i++)
	    if (Ghost[i].Status != Nude)
	      {
		Ghost[i].Status = Afraid;
		Ghost[i].State_delay = LEVEL.afraid_delay;
	      };
	  score += (500 - 10) * points_multiplicator;

	case GUM:
	  nb_gums--;
	  score += (10) * points_multiplicator;

	  LEVEL.MAP[ymap][xmap] = EMPTYNESS;

	  x_rect_fill (PAC.X, PAC.Y, PAC.X + 20, PAC.Y + 20, NonVisual_Offs, 0);
	};
    };

};
/*-------------------------------------------------------------------------*/
void gameover (void)
{
  /* displays a game over logo,
     wait a while a fades the screen to black */
  int i;

  if (gameover_pbm)
    x_put_masked_pbm ((320 - PBMWidth (gameover_pbm)) / 2,
		      (240 - PBMHeight (gameover_pbm)) / 2,
		      VisiblePageOffs, gameover_pbm);

  for (i = 0; i < 40; i++)
    x_wait_vsync ();

  fade_screen (game_palette, 20, TO_BLACK);
}
/*-------------------------------------------------------------------------*/

void play_game (void)
{

/*-----------------------------------------------------------------------*/
/*-----------------   Boucle principale du jeu  -------------------------*/
/*-----------------   main loop of the game     -------------------------*/
/*-----------------------------------------------------------------------*/
  while ( nb_gums != 0 && !(EXIT_GAME|EXIT_LEVEL) )
    {
      /* i dont remember of calling order is important. i bet so! */

      if (VBL_TIME)
	x_set_rgb (0, 0, 0, 63);

      keyboard_handling ();
      calc_level_coordinates ();

      test_collision_pacman_gums ();
      test_collision_pacman_ghost ();
      if (PACMAN_IS_DEAD)
	break;

      pacman_processing ();
      ghosts_processing ();
      bonus_appearance_processing ();

      display_score ();

      animate_sprites ();

      if (VBL_TIME)
	x_set_rgb (0, 0, 0, 0);

      x_page_flip (0, 0); /* display curent frame */
    }
  clear_objects ();
}
/*-------------------------------------------------------------------------*/
int terminate (void)
{
  /* not used fucntion ? */
  exit (0);
  return 0;
}
/*-------------------------------------------------------------------------*/
void exitfunc (void)
{
  /* atexit() */

  if (levels_buffer != NULL)
    farfree (levels_buffer);

  Remove_Keyboard_Handler ();
  x_text_mode ();
}
/*-------------------------------------------------------------------------*/
void init_game_screen(void)
{
         x_wait_vsync ();
         x_set_mode (X_MODE_320x240, 320);
         x_set_doublebuffer (ScrnPhysicalHeight);
         x_text_init ();
}
/*-------------------------------------------------------------------------*/
void main (void)
{
  Install_Keyboard_Handler ();
  Set_JoyPad1 (Key_Ctrl, Key_N, Key_Up_arrow, Key_Down_arrow, Key_Right_arrow, Key_Left_arrow);
  Set_JoyPad_Type (2);

  randomize ();
  atexit (exitfunc);
  setcbrk (0);

  loading_sequence ();
  load_intro_stuff ();
  load_hiscore_stuff ();

/*-----------------------------------------------------------------------*/
/*                    Boucle principale du programme                     */
/*                    main loop of the program                           */
/*-----------------------------------------------------------------------*/

  for (;;)
    {
      if ( intro_screen () == Key_Esc )
	break;

      init_game_screen();

      init_new_game ();

      while (pacman_lives != 0 && !EXIT_GAME)
	{
          init_new_level ();
          while (pacman_lives != 0 && nb_gums != 0 && !(EXIT_GAME|EXIT_LEVEL))
	    {
              init_new_life ();
              play_game ();
	    }
	}

      update_lifemeter ();
      gameover ();
      hiscore_screen ();

      save_hiscore_table ();
    }

  if (gameover_pbm)
    farfree (gameover_pbm);
}

