/*
 * Decompiled with CFR 0.152.
 */
package plugproxy;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import plugproxy.Parameters;
import plugproxy.util.HexDump;

public class PlugProxyListener
implements Runnable {
    private Parameters params;
    private Thread runner;
    private ServerSocket listener;
    private boolean enabled = true;
    private ActionListener actionListener;
    public static int EVENT_INFO = 1;
    public static int EVENT_DATA = 2;
    public static int STREAM_IN = 4;
    public static int STREAM_OUT = 8;
    private ThreadGroup group = new ThreadGroup("PlugProxyGroup");

    public PlugProxyListener(Parameters params) throws IOException {
        this.params = params;
        this.listener = new ServerSocket(params.localPort);
        this.runner = new Thread(this);
        this.runner.setPriority(4);
        this.runner.start();
    }

    public void run() {
        while (this.enabled) {
            try {
                Socket client = this.listener.accept();
                Socket server = new Socket(this.params.host, this.params.remotePort);
                new PlugProxyThread(client.toString(), server, client, STREAM_IN, this.group).start();
                new PlugProxyThread(server.toString(), client, server, STREAM_OUT, this.group).start();
            }
            catch (IOException e) {
                this.enabled = false;
            }
        }
    }

    public void stop() {
        this.enabled = false;
        try {
            this.listener.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        Thread[] list = new PlugProxyThread[this.group.activeCount()];
        this.group.enumerate(list);
        int i = 0;
        while (i < list.length) {
            Thread thread = list[i];
            ((PlugProxyThread)thread).disable();
            ++i;
        }
    }

    protected void fireEvent(String s, int modifier) {
        if (this.actionListener != null) {
            ActionEvent e = new ActionEvent(this, 1001, s, modifier);
            this.actionListener.actionPerformed(e);
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        if (l != null) {
            this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (l != null) {
            this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
        }
    }

    public String toString() {
        String s = null;
        try {
            s = InetAddress.getLocalHost() + ":" + this.params.localPort + "->" + this.params.host + ":" + this.params.remotePort;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return s;
    }

    class PlugProxyThread
    extends Thread {
        private static final int BUFFER_SIZE = 4096;
        private byte[] buffer = new byte[4096];
        private InputStream in;
        private OutputStream out;
        private int direction;
        private Socket source;
        private Socket dest;

        public PlugProxyThread(String name, Socket source, Socket dest, int direction, ThreadGroup group) throws IOException {
            super(group, name);
            this.source = source;
            this.dest = dest;
            this.in = source.getInputStream();
            this.out = dest.getOutputStream();
            this.direction = direction;
            this.setPriority(4);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int len = 0;
            PlugProxyListener.this.fireEvent(this.getName() + ": Connection established.", EVENT_INFO | this.direction);
            try {
                try {
                    while (PlugProxyListener.this.enabled && (len = this.in.read(this.buffer)) != -1) {
                        this.out.write(this.buffer, 0, len);
                        if (!((PlugProxyListener)PlugProxyListener.this).params.sniff) continue;
                        PlugProxyListener.this.fireEvent(((PlugProxyListener)PlugProxyListener.this).params.hex ? HexDump.toHex(this.buffer, len) + '\n' : new String(this.buffer, 0, len), EVENT_DATA | this.direction);
                    }
                }
                catch (IOException ignore) {
                    Object var4_3 = null;
                    this.cleanUp();
                    PlugProxyListener.this.fireEvent(this.getName() + ": Connection terminated.", EVENT_INFO | this.direction);
                    return;
                }
                Object var4_2 = null;
                this.cleanUp();
                PlugProxyListener.this.fireEvent(this.getName() + ": Connection terminated.", EVENT_INFO | this.direction);
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.cleanUp();
                PlugProxyListener.this.fireEvent(this.getName() + ": Connection terminated.", EVENT_INFO | this.direction);
                throw throwable;
            }
        }

        public void disable() {
            this.cleanUp();
        }

        private void cleanUp() {
            try {
                this.out.flush();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.dest.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                this.source.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.in = null;
            this.out = null;
            this.source = null;
            this.dest = null;
        }
    }
}

