/*
 * Decompiled with CFR 0.152.
 */
package plugproxy.util;

public final class HexDump {
    public static String toHex(byte[] buffer, int size) {
        StringBuffer out = new StringBuffer(size * 80);
        int j = 0;
        int i = 0;
        while (i < size) {
            j = 0;
            while (j < 16) {
                if (i + j < size) {
                    out.append(HexDump.convert(buffer[i + j]));
                    out.append((char)(j == 7 && i + j != size - 1 ? 45 : 32));
                } else {
                    out.append("   ");
                }
                ++j;
            }
            out.append("  ");
            j = 0;
            while (j < 16) {
                char ch = (char)buffer[i + j];
                if (i + j < size) {
                    out.append(ch > ' ' && ch < '\u0080' ? ch : (char)'.');
                } else {
                    out.append(' ');
                }
                ++j;
            }
            out.append("\n");
            i += 16;
        }
        return out.toString();
    }

    private static String convert(byte b) {
        int value = b & 0xFF;
        String s = Integer.toHexString(value).toUpperCase();
        if (value <= 15) {
            s = '0' + s;
        }
        return s;
    }
}

