/*
 * Decompiled with CFR 0.152.
 */
package plugproxy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import plugproxy.Parameters;
import plugproxy.PlugProxyListener;
import plugproxy.util.CommandLineParser;

public class PlugProxyGui
extends JFrame
implements DocumentListener {
    private JButton startButton;
    private JButton clearButton;
    private JTextField hostUI;
    private JTextField hostPortUI;
    private JTextField localPortUI;
    private JTextArea incomingUI;
    private JTextArea outgoingUI;
    private JCheckBox hexModeUI;
    private JLabel statusLabel;
    private JCheckBox quietModeUI;
    private JCheckBox lineWrapUI;
    private boolean isRunning = false;
    private PlugProxyListener ppl;
    private ActionListener listener;
    private Parameters params = new Parameters();

    public PlugProxyGui(String[] args) {
        super("PlugProxy");
        this.setProperties();
        this.createUI();
        this.layoutUI();
        ((Frame)this).setIconImage(this.loadImage("plug.gif"));
        this.parseCommandLine(args);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(-1);
            }
        });
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((ss.width - this.getSize().width) / 2, (ss.height - this.getSize().height) / 4);
        this.doDocEvent();
        this.show();
    }

    public void insertUpdate(DocumentEvent e) {
        this.doDocEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.doDocEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.doDocEvent();
    }

    private void createUI() {
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlugProxyGui.this.isRunning) {
                    PlugProxyGui.this.startListener();
                } else {
                    PlugProxyGui.this.stopListener();
                }
            }
        });
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlugProxyGui.this.incomingUI.setText("");
                PlugProxyGui.this.outgoingUI.setText("");
            }
        });
        this.hostUI = new JTextField();
        this.hostUI.setPreferredSize(new Dimension(120, (int)this.hostUI.getPreferredSize().getHeight()));
        this.hostUI.getDocument().addDocumentListener(this);
        this.hostPortUI = new JTextField();
        this.hostPortUI.setPreferredSize(new Dimension(75, (int)this.hostPortUI.getPreferredSize().getHeight()));
        this.hostPortUI.getDocument().addDocumentListener(this);
        this.localPortUI = new JTextField();
        this.localPortUI.setPreferredSize(new Dimension(75, (int)this.localPortUI.getPreferredSize().getHeight()));
        this.localPortUI.getDocument().addDocumentListener(this);
        this.incomingUI = new JTextArea();
        this.incomingUI.setFont(new Font("Monospaced", 1, 12));
        this.incomingUI.setEditable(false);
        this.outgoingUI = new JTextArea();
        this.outgoingUI.setFont(new Font("Monospaced", 1, 12));
        this.outgoingUI.setEditable(false);
        this.hexModeUI = new JCheckBox("Hex Mode");
        this.hexModeUI.setSelected(false);
        this.hexModeUI.setOpaque(false);
        this.hexModeUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PlugProxyGui)PlugProxyGui.this).params.hex = PlugProxyGui.this.hexModeUI.isSelected();
            }
        });
        this.quietModeUI = new JCheckBox("Quiet Mode");
        this.quietModeUI.setSelected(false);
        this.quietModeUI.setOpaque(false);
        this.quietModeUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PlugProxyGui)PlugProxyGui.this).params.sniff = !PlugProxyGui.this.quietModeUI.isSelected();
            }
        });
        this.lineWrapUI = new JCheckBox("Line Wrap");
        this.lineWrapUI.setSelected(false);
        this.lineWrapUI.setOpaque(false);
        this.lineWrapUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlugProxyGui.this.incomingUI.setLineWrap(PlugProxyGui.this.lineWrapUI.isSelected());
                PlugProxyGui.this.outgoingUI.setLineWrap(PlugProxyGui.this.lineWrapUI.isSelected());
            }
        });
        this.statusLabel = new JLabel();
    }

    private void layoutUI() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add("North", this.makeTopBar());
        p.add("Center", this.makeMessagePanel());
        p.add("South", this.makeBottomBar());
        this.setContentPane(p);
        this.pack();
        ((Component)this).setSize(600, 500);
    }

    private JPanel makeTopBar() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(new JLabel("Host "));
        p.add(this.hostUI);
        p.add(new JLabel("Remote Port"));
        p.add(this.hostPortUI);
        p.add(new JLabel("Local Port "));
        p.add(this.localPortUI);
        return p;
    }

    private JSplitPane makeMessagePanel() {
        JSplitPane p = new JSplitPane(0);
        p.setDividerSize(5);
        p.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        p.add(this.makeOutgoingPanel());
        p.add(this.makeIncomingPanel());
        return p;
    }

    private JPanel makeBottomBar() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout(0));
        leftPanel.add(this.quietModeUI);
        leftPanel.add(this.lineWrapUI);
        leftPanel.add(this.hexModeUI);
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        centerPanel.add(this.statusLabel);
        JPanel rightPanel = new JPanel(new FlowLayout(2));
        rightPanel.add(this.clearButton);
        rightPanel.add(this.startButton);
        p.add("West", leftPanel);
        p.add("Center", centerPanel);
        p.add("East", rightPanel);
        return p;
    }

    private JPanel makeOutgoingPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        TitledBorder border = new TitledBorder("Request");
        border.setTitleColor(new Color(65, 65, 65));
        p.setBorder(border);
        JScrollPane s = new JScrollPane(this.outgoingUI);
        s.getViewport().setBackground(Color.white);
        s.setAutoscrolls(true);
        p.add((Component)s, "Center");
        p.setMinimumSize(new Dimension(310, 100));
        p.setPreferredSize(new Dimension(310, 200));
        return p;
    }

    private JPanel makeIncomingPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        TitledBorder border = new TitledBorder("Response");
        border.setTitleColor(new Color(65, 65, 65));
        p.setBorder(border);
        JScrollPane s = new JScrollPane(this.incomingUI);
        s.getViewport().setBackground(Color.white);
        s.setAutoscrolls(true);
        p.add((Component)s, "Center");
        p.setMinimumSize(new Dimension(310, 100));
        p.setPreferredSize(new Dimension(310, 200));
        return p;
    }

    private void setProperties() {
        UIManager.put("DragAndDrop.selectionBackground", new Color(64, 32, 255));
        UIManager.put("ToolTip.foreground", Color.black);
        UIManager.put("ToolTip.background", new Color(255, 255, 220));
        UIManager.put("ToolTip.border", new EtchedBorder(0));
        Color c = new Color(230, 230, 230);
        UIManager.put("Desktop.background", new Color(120, 150, 170));
        UIManager.put("Panel.background", c);
        UIManager.put("Button.background", c);
        UIManager.put("ToggleButton.background", c);
        UIManager.put("Label.background", c);
        UIManager.put("ComboBox.disabledBackground", c);
        UIManager.put("TabbedPane.background", new Color(140, 140, 140));
        UIManager.put("TabbedPane.foreground", new Color(65, 65, 65));
        UIManager.put("TabbedPane.selected", new Color(240, 240, 255));
        UIManager.put("ComboBox.background", c);
        UIManager.put("Label.foreground", new Color(65, 65, 65));
        UIManager.put("CheckBox.foreground", new Color(65, 65, 65));
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        Font ab = new Font("Verdana", 1, 10);
        Font ar = new Font("Verdana", 0, 10);
        Font at = new Font("Verdana", 0, 12);
        UIManager.put("Button.font", ar);
        UIManager.put("CheckBox.font", ab);
        UIManager.put("CheckBoxMenuItem.font", ab);
        UIManager.put("ComboBox.font", ar);
        UIManager.put("InternalFrame.font", ab);
        UIManager.put("Label.font", ab);
        UIManager.put("List.font", at);
        UIManager.put("Menu.font", ab);
        UIManager.put("MenuBar.font", ab);
        UIManager.put("MenuItem.font", ab);
        UIManager.put("OptionPane.font", ab);
        UIManager.put("Panel.font", ar);
        UIManager.put("PopupMenu.font", ab);
        UIManager.put("RadioButton.font", ab);
        UIManager.put("RadioButtonMenuItem.font", ab);
        UIManager.put("ScrollPane.font", ab);
        UIManager.put("TabbedPane.font", ab);
        UIManager.put("Table.font", at);
        UIManager.put("TableHeader.font", ar);
        UIManager.put("TextArea.font", at);
        UIManager.put("TextField.font", at);
        UIManager.put("PasswordField.font", at);
        UIManager.put("TextPane.font", at);
        UIManager.put("TitledBorder.font", ab);
        UIManager.put("ToggleButton.font", ab);
        UIManager.put("ToolBar.font", ab);
        UIManager.put("ToolTip.font", ar);
        UIManager.put("Tree.font", at);
        UIManager.put("ViewPort.font", ar);
    }

    private void doDocEvent() {
        boolean notEmpty = this.hostUI.getText().length() > 0 && this.hostPortUI.getText().length() > 0 && this.localPortUI.getText().length() > 0;
        boolean portIsNumber = true;
        if (notEmpty) {
            try {
                Integer.parseInt(this.hostPortUI.getText());
                Integer.parseInt(this.localPortUI.getText());
            }
            catch (NumberFormatException e) {
                portIsNumber = false;
            }
        }
        boolean valid = notEmpty && portIsNumber;
        this.startButton.setEnabled(valid);
    }

    private void startListener() {
        this.params.host = this.hostUI.getText();
        this.params.remotePort = Integer.parseInt(this.hostPortUI.getText());
        this.params.localPort = Integer.parseInt(this.localPortUI.getText());
        this.params.sniff = true;
        this.params.hex = this.hexModeUI.isSelected();
        this.statusLabel.setText("Listening.....");
        this.startButton.setText("Stop ");
        this.hostUI.setEnabled(false);
        this.hostPortUI.setEnabled(false);
        this.localPortUI.setEnabled(false);
        this.isRunning = true;
        try {
            new Socket(this.params.host, this.params.remotePort).close();
            this.ppl = new PlugProxyListener(this.params);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Date now = new Date();
                    int modifiers = e.getModifiers();
                    if ((modifiers & PlugProxyListener.EVENT_DATA) != 0) {
                        if ((modifiers & PlugProxyListener.STREAM_IN) != 0) {
                            PlugProxyGui.this.incomingUI.append("[" + now + "]" + '\n');
                            PlugProxyGui.this.incomingUI.append(e.getActionCommand());
                            int i = PlugProxyGui.this.incomingUI.getText().length();
                            PlugProxyGui.this.incomingUI.setCaretPosition(i);
                        } else {
                            PlugProxyGui.this.outgoingUI.append("[" + now + "]" + '\n');
                            PlugProxyGui.this.outgoingUI.append(e.getActionCommand());
                            int i = PlugProxyGui.this.outgoingUI.getText().length();
                            PlugProxyGui.this.outgoingUI.setCaretPosition(i);
                        }
                    }
                }
            };
            this.ppl.addActionListener(this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane pane = new JOptionPane(e);
            JDialog dialog = pane.createDialog(this, "Error...");
            ((JComponent)dialog.getContentPane().getComponent(0)).setOpaque(false);
            dialog.show();
        }
    }

    private void stopListener() {
        this.statusLabel.setText("");
        this.startButton.setText("Start");
        this.isRunning = false;
        if (this.ppl != null) {
            this.ppl.stop();
            this.ppl = null;
        }
        this.hostUI.setEnabled(true);
        this.hostPortUI.setEnabled(true);
        this.localPortUI.setEnabled(true);
    }

    protected void parseCommandLine(String[] args) {
        if (args.length < 3) {
            return;
        }
        CommandLineParser cmp = new CommandLineParser(args);
        this.hostUI.setText(args[0]);
        this.hostPortUI.setText(args[1]);
        this.localPortUI.setText(args[2]);
        this.quietModeUI.setSelected(!cmp.containsParameter("s"));
        this.hexModeUI.setSelected(cmp.containsParameter("h"));
    }

    private Image loadImage(String imageName) {
        Image im = null;
        try {
            im = Toolkit.getDefaultToolkit().createImage(this.loadResource(imageName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return im;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] loadResource(String resLocation) throws IOException {
        int c;
        Class<?> refClass = null;
        refClass = this.getClass();
        InputStream is = refClass.getResourceAsStream(resLocation);
        if (is == null) {
            throw new IOException("resource not found: " + resLocation);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) >= 0) {
            void var5_5;
            baos.write((int)var5_5);
        }
        return baos.toByteArray();
    }

    public static void main(String[] args) {
        new PlugProxyGui(args);
    }
}

