/*
 * Decompiled with CFR 0.152.
 */
package plugproxy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import plugproxy.Parameters;
import plugproxy.PlugProxyGui;
import plugproxy.PlugProxyListener;
import plugproxy.util.CommandLineParser;

public class PlugProxy {
    public static final String VERSION = "2.00";

    public PlugProxy(String[] args) throws IOException {
        final Parameters params = this.parseCommandLine(args);
        PlugProxyListener ppl = new PlugProxyListener(params);
        if (params.verbose || params.sniff) {
            ppl.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int modifiers = e.getModifiers();
                    if (params.verbose && (modifiers & PlugProxyListener.EVENT_INFO) != 0 || params.sniff && (modifiers & PlugProxyListener.EVENT_DATA) != 0) {
                        System.out.print((modifiers & PlugProxyListener.STREAM_IN) != 0 ? "<" : ">");
                        System.out.print("[" + new Date() + "] ");
                        if (params.sniff) {
                            System.out.print("\n");
                        }
                        System.out.println(e.getActionCommand());
                    }
                }
            });
            if (params.verbose) {
                System.out.println("[" + new Date() + "]" + " Ready: " + ppl);
            }
        }
    }

    protected Parameters parseCommandLine(String[] args) {
        if (args.length < 3) {
            this.printUsageAndExit();
        }
        Parameters params = new Parameters();
        CommandLineParser cmp = new CommandLineParser(args);
        params.host = args[0];
        try {
            params.localPort = Integer.parseInt(args[2]);
            params.remotePort = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        if (cmp.containsParameter("v")) {
            params.verbose = true;
        }
        if (cmp.containsParameter("s")) {
            params.sniff = true;
        }
        if (cmp.containsParameter("h")) {
            params.hex = true;
        }
        if (cmp.containsParameter("?") || cmp.containsParameter("help") || params.host == null || params.localPort == 0 || params.remotePort == 0) {
            this.printUsageAndExit();
        }
        return params;
    }

    protected void printUsageAndExit() {
        PrintWriter out = new PrintWriter(System.out);
        out.print("PlugProxy version: 2.00\n\n");
        out.print("Usage: PlugProxy [-g] host rport lport [-v] [-s] [-h]\n");
        out.print("\nWhere options are:\n\n");
        out.print("\t-g");
        out.print("\trun the graphical user interface\n");
        out.print("\thost");
        out.print("\tset the host system\n");
        out.print("\trport");
        out.print("\tset the remote (forwarding) port\n");
        out.print("\tlport");
        out.print("\tset the local (listener) port\n");
        out.print("\t-v");
        out.print("\tset verbose mode\n");
        out.print("\t-s");
        out.print("\tsniff (display) the data passed through the proxy.\n");
        out.print("\t-h ");
        out.print("\tuse hexdump format when sniffing (ignored if -s not set)\n\n");
        out.print("Example: \"PlugProxy www.javasoft.com 80 8080\"\n");
        out.print("Forwards data from port 8080 on the localhost to port 80 on www.javasoft.com");
        out.flush();
        out.close();
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("-g")) {
            String[] guiArgs = new String[args.length - 1];
            System.arraycopy(args, 1, guiArgs, 0, args.length - 1);
            new PlugProxyGui(guiArgs);
        } else {
            new PlugProxy(args);
        }
    }
}

