// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef __OB_POAServantLocator_skel_h__
#define __OB_POAServantLocator_skel_h__

#include <OB/POAServantLocator.h>

#include <OB/POAServantManager_skel.h>
#include <OB/POACommon_skel.h>
#include <OB/LocalObject.h>

namespace POA_PortableServer
{

//
// A delegation class so that _this() can work with non reference
// counted servants.
//
class ServantLocatorDelegate;
typedef ServantLocatorDelegate* ServantLocatorDelegate_ptr;

}

void OBDuplicate(POA_PortableServer::ServantLocatorDelegate_ptr);
void OBRelease(POA_PortableServer::ServantLocatorDelegate_ptr);

namespace POA_PortableServer
{

typedef OB::ObjVar<ServantLocatorDelegate> ServantLocatorDelegate_var;

}

namespace POA_PortableServer
{

class ServantLocator : virtual public PortableServer::ServantLocator,
		       virtual public PortableServer::ServantBase,
		       virtual public OBCORBA::LocalObjectBase
{
    ServantLocator(const ServantLocator&);
    void operator=(const ServantLocator&);

    ServantLocatorDelegate_var delegate_;

public:

    ServantLocator();
    ~ServantLocator();

    PortableServer::ServantLocator_ptr _this();

    //
    // ServantBase methods
    //
    virtual CORBA::RepositoryId
    _primary_interface(const PortableServer::ObjectId&,
		       PortableServer::POA_ptr);

    virtual void
    _OB_dispatch(OB::Upcall_ptr);
};

} // End of namespace POA_PortableServer

#endif
