// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef __OB_POAAdapterActivator_skel_h__
#define __OB_POAAdapterActivator_skel_h__

#include <OB/POAAdapterActivator.h>
#include <OB/LocalObject.h>

namespace POA_PortableServer
{

//
// A delegation class so that _this() can work with non reference
// counted servants.
//
class AdapterActivatorDelegate;
typedef AdapterActivatorDelegate* AdapterActivatorDelegate_ptr;

}

void OBDuplicate(POA_PortableServer::AdapterActivatorDelegate_ptr);
void OBRelease(POA_PortableServer::AdapterActivatorDelegate_ptr);

namespace POA_PortableServer
{

typedef OB::ObjVar<AdapterActivatorDelegate> AdapterActivatorDelegate_var;

}

namespace POA_PortableServer
{

class AdapterActivator : virtual public PortableServer::AdapterActivator,
		         virtual public PortableServer::ServantBase,
			 virtual public OBCORBA::LocalObjectBase
{
    AdapterActivator(const AdapterActivator&);
    void operator=(const AdapterActivator&);

    AdapterActivatorDelegate_var delegate_;

public:

    AdapterActivator();
    ~AdapterActivator();

    PortableServer::AdapterActivator_ptr _this();

    //
    // ServantBase methods
    //
    virtual CORBA::RepositoryId
    _primary_interface(const PortableServer::ObjectId&,
		       PortableServer::POA_ptr);

    virtual void
    _OB_dispatch(OB::Upcall_ptr);
};

} // End of namespace POA_PortableServer

#endif
