// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_NAMED_VALUE_H
#define OB_NAMED_VALUE_H

#include <OB/NamedValue_fwd.h>

#include <OB/AnyDeclaration.h>

namespace OBCORBA
{

class ORB_impl; // For the friend declaration

} // End namespace OBCORBA

namespace CORBA
{

//
// The NamedValue class
//
class NamedValue : public OB::RefCount
{
    String_var name_;
    mutable Any_var value_;
    Flags flags_;

    //
    // Hide copy-constructor and assignment operator
    //
    NamedValue(const NamedValue&);
    void operator=(const NamedValue&);

protected:

    NamedValue();
    NamedValue(char*, Any*, Flags);

    friend class ::OBCORBA::ORB_impl; // OBORB_impl creates NamedValue
    friend class NVList; // NVList creates NamedValue
    friend class Request; // Request creates NamedValue

public:

    static inline NamedValue_ptr _duplicate(NamedValue_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline NamedValue_ptr _nil()
    { return 0; }

    const char* name() const;
    Any* value() const;
    Flags flags() const;
};

inline void
release(NamedValue_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(NamedValue_ptr p)
{
    return p == 0;
}

//
// The NVList class
//
class NVList : public OB::RefCount
{
    OB::ObjSeq< NamedValue, int > namedValues_;
    
    //
    // Hide copy-constructor and assignment operator
    //
    NVList(const NVList&);
    void operator=(const NVList&);

protected:

    NVList() { };
    NVList(ULong);

    friend class Context; // Context may create NVLists
    friend class Request; // Request may create NVLists
    friend class ::OBCORBA::ORB_impl; // OBORB_impl may create NVLists

public:

    static inline NVList_ptr _duplicate(NVList_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline NVList_ptr _nil()
    { return 0; }

    ULong count() const;

    NamedValue_ptr add(Flags);
    NamedValue_ptr add_item(const char*, Flags);
    NamedValue_ptr add_value(const char*, const Any&, Flags);

    NamedValue_ptr add_item_consume(char*, Flags);
    NamedValue_ptr add_value_consume(char*, Any*, Flags);

    NamedValue_ptr item(ULong);

    void remove(ULong);
};

inline void
release(NVList_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(NVList_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
