// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_LOCAL_OBJECT_H
#define OB_LOCAL_OBJECT_H

#include <OB/LocalObject_fwd.h>

#include <OB/Object.h>

namespace OBCORBA
{

class LocalObjectBase : virtual public CORBA::Object
{
protected:

    LocalObjectBase();
    ~LocalObjectBase();

public:

    virtual CORBA::InterfaceDef_ptr _get_interface();
    virtual CORBA::Boolean _is_a(const char*);
    virtual CORBA::Boolean _non_existent();

    virtual CORBA::Boolean _is_equivalent(CORBA::Object_ptr);
    virtual CORBA::ULong _hash(CORBA::ULong);

    virtual void _create_request(CORBA::Context_ptr, const char*,
				 CORBA::NVList_ptr,
				 CORBA::NamedValue_ptr,
				 CORBA::Request_out, CORBA::Flags);

    virtual void _create_request(CORBA::Context_ptr, const char*,
				 CORBA::NVList_ptr,
				 CORBA::NamedValue_ptr,
				 CORBA::ExceptionList_ptr,
				 CORBA::ContextList_ptr,
				 CORBA::Request_out, CORBA::Flags);

    virtual CORBA::Request_ptr _request(const char*);

    virtual CORBA::Policy_ptr _get_policy(CORBA::PolicyType);
    virtual CORBA::Policy_ptr _get_client_policy(CORBA::PolicyType);
    virtual CORBA::Object_ptr _set_policy_overrides(
	const CORBA::PolicyList&, CORBA::SetOverrideType);
    virtual CORBA::PolicyList* _get_policy_overrides(
	const CORBA::PolicyTypeSeq&);
    virtual CORBA::Boolean _validate_connection(
	CORBA::PolicyList_out);

    //
    // Additional ORBacus-specific functions
    //
    virtual OCI::ConnectorInfo_ptr _get_oci_connector_info();
    virtual OCI::TransportInfo_ptr _get_oci_transport_info();

    virtual CORBA::AbstractBase_ptr _OB_toAbstractBase();
    virtual OB::RefCountIOR_ptr _OB_origIOR() const;
    virtual OB::RefCountIOR_ptr _OB_IOR() const;
    virtual void _OB_marshalOrigIOR(OB::OutputStreamImpl*) const;
    virtual const char** _OB_ids() const;
};

} // End namespace OBCORBA

namespace CORBA
{

class LocalObject : public OBCORBA::LocalObjectBase
{
protected:

    LocalObject();
    ~LocalObject();

public:

    virtual void _add_ref();
    virtual void _remove_ref();
};

} // End namespace CORBA

namespace OBCORBA
{

class RefCountLocalObject : virtual public CORBA::LocalObject,
			    virtual public OB::RefCount
{
protected:
    
    RefCountLocalObject() { }
    RefCountLocalObject(const RefCountLocalObject&) { }
    RefCountLocalObject&
    operator=(const RefCountLocalObject&) { return *this; }

public:
    
    virtual void _add_ref();
    virtual void _remove_ref();
};

} // End namespace OBCORBA

#endif
