// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_TYPE_CODE_CACHE_H
#define OB_TYPE_CODE_CACHE_H

#include <OB/Hashtable.h>

namespace OB
{

class TypeCodeCache : public JTCMutex
{
    typedef Hashtable<const char*, CORBA::TypeCode_var, StringHasher> TCCache;

    TCCache cache_;
    
    //
    // The TypeCodeCache singleton
    //
    static JTCMutex instanceMutex_;
    static OB_IMPORT TypeCodeCache* instance_;
    friend class TypeCodeCacheDestroyer;

public:

    TypeCodeCache();
    virtual ~TypeCodeCache();

    //
    // Get singleton instance
    //
    static TypeCodeCache* instance();

    //
    // Get a TypeCode with the given repository id
    //
    bool get(const char*, CORBA::TypeCode_var&);

    //
    // Add the given TypeCode to the cache
    //
    void put(const char*, CORBA::TypeCode_ptr);
};

} // End of namespace OB

#endif
