// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_OBJECT_KEY_H
#define OB_OBJECT_KEY_H

#include <OB/NativeTypes.h>
#include <OB/Any.h>
#include <OB/TypeCodeConst.h>
#include <OB/OCITypes.h>
#include <OB/Except.h>
#include <OB/POACommon.h>

namespace OB
{

//
// The data contained in an object key
//
struct ObjectKeyData
{
    CORBA::String_var serverId; // The Server Id
    CORBA::StringSeq poaId; // The POA to which this key refers
    PortableServer::ObjectId oid; // The object-id to which this key refers
    bool persistent; // Is the POA that created this key persistent?
    time_t createTime; // If transient, what time was the POA created?

    ObjectKeyData();
    ObjectKeyData(const char*, const CORBA::StringSeq&,
		  const PortableServer::ObjectId&, bool, time_t);
};

OCI::ObjectKey* CreateObjectKey(const ObjectKeyData&);
bool ParseObjectKey(const OCI::ObjectKey&, ObjectKeyData&);

} // End of namespace OB

#endif
