// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_NATIVE_TYPES_H
#define OB_NATIVE_TYPES_H

//
// The translator generates a typedef for a native IDL type. For a
// native type defined as follows:
//
// module M
// {
//     native N;
// };
//
// The translator will generate the following:
//
// namespace M
// {
//     typedef OBNative_M::N N;
// }
//
// We must then provide the definition of OBNative_M::N in this header file.
//

namespace CORBA
{

class ValueFactoryBase;

} // End of namespace CORBA

namespace OBNative_CORBA
{

typedef CORBA::ValueFactoryBase* ValueFactory;

} // End of namespace OBNative_CORBA

namespace PortableServer
{

class ServantBase;

} // End of namespace PortableServer


namespace OBNative_PortableServer
{

typedef PortableServer::ServantBase* Servant;

class ServantLocator
{
public:
    typedef void* Cookie;
};

} // End of namespace OBNative_PortableServer

namespace OB
{

class Properties;

class EventHandlerBase;

} // End of namespace OB

namespace OBNative_OB
{

typedef OB::Properties* PropertySet;

typedef OB::EventHandlerBase* EventHandler;

} // End of namespace OBNative_OB

#endif

