// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef EVENT_SERVICE_H
#define EVENT_SERVICE_H

#include <OB/OBEventChannelFactory.h>

//
// Forward declarations
//
class EventChannelFactory_impl;
class Reaper;
typedef JTCHandleT< Reaper > ReaperHandle;

namespace OB
{

//
// This class encapsulates the event service
// 
class EventService
{
    //
    // No copy constructor/assignment operator.
    //
    EventService(const EventService&);
    void operator=(const EventService&);

    //
    // My ORB
    //
    CORBA::ORB_var orb_;

    //
    // My POA
    //
    PortableServer::POA_var poa_;

    //
    // The event channel factory
    //
    EventChannelFactory_impl* channelFactory_;

    //
    // My proxy reaper
    //
    ReaperHandle reaper_;

    //
    // Are we initialized?
    //
    bool initialized_;

public:

    EventService(CORBA::ORB_ptr, PortableServer::POA_ptr);
    ~EventService();

    //
    // Initialize the event service
    //
    void initialize();

    //
    // Get event channel factory
    //
    OBEventChannelFactory::EventChannelFactory_ptr eventChannelFactory();
};

} // End of namespace OB

#endif
