// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_DII_FWD_H
#define OB_DII_FWD_H

#include <OB/Template.h>

namespace CORBA
{

class ExceptionList;
typedef ExceptionList* ExceptionList_ptr;
typedef ExceptionList_ptr ExceptionListRef;

class ContextList;
typedef ContextList* ContextList_ptr;
typedef ContextList_ptr ContextListRef;

class Request;
typedef Request* Request_ptr;
typedef Request_ptr RequestRef;

} // End of namespace CORBA

void OBDuplicate(CORBA::ExceptionList_ptr);
void OBRelease(CORBA::ExceptionList_ptr);

void OBDuplicate(CORBA::ContextList_ptr);
void OBRelease(CORBA::ContextList_ptr);

void OBDuplicate(CORBA::Request_ptr);
void OBRelease(CORBA::Request_ptr);

namespace CORBA
{

typedef OB::ObjVar< ExceptionList > ExceptionList_var;
typedef OB::ObjOut< ExceptionList > ExceptionList_out;

typedef OB::ObjVar< ContextList > ContextList_var;
typedef OB::ObjOut< ContextList > ContextList_out;

typedef OB::ObjVar< Request > Request_var;
typedef OB::ObjOut< Request > Request_out;

} // End of namespace CORBA

#endif
