/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import test.common.TestBase;
import test.poa.PMSTestThread;
import test.poa.POAManagerProxy;
import test.poa.POAManagerProxyPOA;
import test.poa.POAManagerProxyPackage.AdapterInactive;
import test.poa.POAManagerProxyPackage.State;
import test.poa.Test;
import test.poa.TestDSI_impl;
import test.poa.TestHelper;
import test.poa.TestInfo;
import test.poa.TestPOAManagerCommon;
import test.poa.TestServer;
import test.poa.TestServer_impl;
import test.poa.TestUtil;
import test.poa.Test_impl;

final class TestPOAManagerServer
extends TestBase {
    TestPOAManagerServer() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            java.lang.Object file;
            orb = ORB.init((String[])args, (Properties)props);
            POA root = TestUtil.GetRootPOA(orb);
            POAManager manager = root.the_POAManager();
            Policy[] policies = new Policy[]{root.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), root.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), root.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), root.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), root.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID)};
            POA retain = null;
            try {
                retain = root.create_POA("retain", null, policies);
            }
            catch (AdapterAlreadyExists ex) {
                throw new RuntimeException();
            }
            catch (InvalidPolicy ex) {
                throw new RuntimeException();
            }
            POAManager retainManager = retain.the_POAManager();
            POAManagerProxy_impl proxyImpl = new POAManagerProxy_impl(retainManager);
            POAManagerProxy proxy = proxyImpl._this(orb);
            Test_impl testImpl = new Test_impl(orb, retain);
            byte[] oid = "test".getBytes();
            try {
                retain.activate_object_with_id(oid, (Servant)testImpl);
            }
            catch (ObjectAlreadyActive ex) {
                TestPOAManagerServer.TEST(false);
            }
            catch (ServantAlreadyActive ex) {
                TestPOAManagerServer.TEST(false);
            }
            catch (WrongPolicy ex) {
                TestPOAManagerServer.TEST(false);
            }
            Test test = testImpl._this();
            TestDSI_impl testDSIImpl = new TestDSI_impl(orb, retain);
            byte[] oidDSI = "testDSI".getBytes();
            try {
                retain.activate_object_with_id(oidDSI, (Servant)testDSIImpl);
            }
            catch (ObjectAlreadyActive ex) {
                TestPOAManagerServer.TEST(false);
            }
            catch (ServantAlreadyActive ex) {
                TestPOAManagerServer.TEST(false);
            }
            catch (WrongPolicy ex) {
                TestPOAManagerServer.TEST(false);
            }
            Object objDSI = retain.create_reference_with_id(oidDSI, "IDL:Test:1.0");
            Test testDSI = TestHelper.narrow(objDSI);
            TestInfo[] info = new TestInfo[]{new TestInfo(), new TestInfo()};
            info[0].obj = test;
            info[0].except_id = "";
            info[1].obj = testDSI;
            info[1].except_id = "";
            TestServer_impl serverImpl = new TestServer_impl(orb, info);
            TestServer server = serverImpl._this(orb);
            PMSTestThread t = new PMSTestThread(test);
            t.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            TestPOAManagerServer.TEST(t.callState() == 1);
            try {
                manager.activate();
                retainManager.activate();
            }
            catch (org.omg.PortableServer.POAManagerPackage.AdapterInactive ex) {
                throw new RuntimeException();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            TestPOAManagerServer.TEST(t.callState() == 3);
            new TestPOAManagerCommon(proxy, info);
            String refFile = "Test.ref";
            try {
                FileOutputStream file2 = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter(file2);
                out.println(orb.object_to_string((Object)server));
                out.flush();
                file2.close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            String refFileMgr = "POAManagerProxy.ref";
            try {
                file = new FileOutputStream(refFileMgr);
                PrintWriter out = new PrintWriter((OutputStream)file);
                out.println(orb.object_to_string((Object)proxy));
                out.flush();
                ((FileOutputStream)file).close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            orb.run();
            file = new File(refFile);
            ((File)file).delete();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static final class POAManagerProxy_impl
    extends POAManagerProxyPOA {
        private POAManager manager_;

        POAManagerProxy_impl(POAManager manager) {
            this.manager_ = manager;
        }

        public void activate() throws AdapterInactive {
            try {
                this.manager_.activate();
            }
            catch (org.omg.PortableServer.POAManagerPackage.AdapterInactive ex) {
                throw new AdapterInactive();
            }
        }

        public void hold_requests(boolean a) throws AdapterInactive {
            try {
                this.manager_.hold_requests(a);
            }
            catch (org.omg.PortableServer.POAManagerPackage.AdapterInactive ex) {
                throw new AdapterInactive();
            }
        }

        public void discard_requests(boolean a) throws AdapterInactive {
            try {
                this.manager_.discard_requests(a);
            }
            catch (org.omg.PortableServer.POAManagerPackage.AdapterInactive ex) {
                throw new AdapterInactive();
            }
        }

        public void deactivate(boolean a, boolean b) throws AdapterInactive {
            try {
                this.manager_.deactivate(a, b);
            }
            catch (org.omg.PortableServer.POAManagerPackage.AdapterInactive ex) {
                throw new AdapterInactive();
            }
        }

        public State get_state() {
            return State.from_int(this.manager_.get_state().value());
        }
    }
}

