/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import test.common.TestBase;
import test.poa.Test;
import test.poa.TestPOA;
import test.poa.TestUtil;

final class TestDestroy
extends TestBase {
    TestDestroy() {
    }

    static void TestDestroyThreaded(ORB orb, POA root) {
        POAManager rootMgr = root.the_POAManager();
        TestDestroy.TEST(rootMgr != null);
        Policy[] policies = new Policy[]{root.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        POA poa = null;
        try {
            poa = root.create_POA("poa1", rootMgr, policies);
        }
        catch (InvalidPolicy ex) {
            throw new RuntimeException();
        }
        catch (AdapterAlreadyExists ex) {
            throw new RuntimeException();
        }
        Test_impl2 impl = new Test_impl2(poa);
        Test t = impl._this(orb);
        LongCaller thr = new LongCaller(t);
        thr.start();
        impl.blockUntilCalled();
        poa.destroy(true, true);
        TestDestroy.TEST(impl.callComplete());
        while (thr.isAlive()) {
            try {
                thr.join();
            }
            catch (InterruptedException ex) {}
        }
    }

    static void TestDestroyBlocking(ORB orb, POA root) {
        POA poa;
        Policy[] policies = new Policy[]{};
        POAManager rootMgr = root.the_POAManager();
        TestDestroy.TEST(rootMgr != null);
        try {
            poa = root.create_POA("poa1", rootMgr, policies);
        }
        catch (InvalidPolicy ex) {
            throw new RuntimeException();
        }
        catch (AdapterAlreadyExists ex) {
            throw new RuntimeException();
        }
        poa.destroy(true, true);
        try {
            root.find_POA("poa1", false);
            TestDestroy.TEST(false);
        }
        catch (AdapterNonExistent ex) {
            // empty catch block
        }
        try {
            poa = root.create_POA("poa1", rootMgr, policies);
        }
        catch (AdapterAlreadyExists ex) {
            throw new RuntimeException();
        }
        catch (InvalidPolicy ex) {
            throw new RuntimeException();
        }
        try {
            POA poa2 = poa.create_POA("child1", rootMgr, policies);
        }
        catch (AdapterAlreadyExists ex) {
            throw new RuntimeException();
        }
        catch (InvalidPolicy ex) {
            throw new RuntimeException();
        }
        poa.destroy(true, true);
        try {
            root.find_POA("poa1", false);
            TestDestroy.TEST(false);
        }
        catch (AdapterNonExistent ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            POA root = TestUtil.GetRootPOA(orb);
            POAManager rootMgr = root.the_POAManager();
            TestDestroy.TEST(rootMgr != null);
            try {
                rootMgr.activate();
            }
            catch (AdapterInactive ex) {
                throw new RuntimeException();
            }
            System.out.print("Testing POA::destroy... ");
            System.out.flush();
            TestDestroy.TestDestroyBlocking(orb, root);
            TestDestroy.TestDestroyThreaded(orb, root);
            System.out.println("Done!");
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }

    static final class LongCaller
    extends Thread {
        private Test t_;

        LongCaller(Test t) {
            this.t_ = t;
        }

        public void run() {
            try {
                this.t_.aMethod();
            }
            catch (SystemException se) {
                System.err.println(se.getMessage());
                se.printStackTrace();
            }
        }
    }

    static final class Test_impl2
    extends TestPOA {
        private POA poa_;
        private boolean called_ = false;
        private boolean finished_ = false;

        Test_impl2(POA poa) {
            this.poa_ = poa;
        }

        public synchronized void aMethod() {
            this.called_ = true;
            this.notify();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.finished_ = true;
        }

        public POA _default_POA() {
            return this.poa_;
        }

        synchronized void blockUntilCalled() {
            while (!this.called_) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized boolean callComplete() {
            return this.finished_;
        }
    }
}

