/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import test.poa.TestDSIRef_impl;
import test.poa.TestHelper;
import test.poa.TestInfo;
import test.poa.TestServer;
import test.poa.TestServer_impl;
import test.poa.TestUtil;
import test.poa.Test_impl;

final class TestDefaultServantServer {
    TestDefaultServantServer() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            java.lang.Object file;
            orb = ORB.init((String[])args, (Properties)props);
            POA root = TestUtil.GetRootPOA(orb);
            POAManager manager = root.the_POAManager();
            Policy[] policies = new Policy[]{root.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), root.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), root.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), root.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), root.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), root.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
            POA persistentPOA = null;
            try {
                persistentPOA = root.create_POA("persistent", manager, policies);
            }
            catch (AdapterAlreadyExists ex) {
                throw new RuntimeException();
            }
            catch (InvalidPolicy ex) {
                throw new RuntimeException();
            }
            TestDSIRef_impl defaultServant = new TestDSIRef_impl(orb, "", false);
            defaultServant.setDefaultServant(true);
            try {
                persistentPOA.set_servant((Servant)defaultServant);
            }
            catch (WrongPolicy ex) {
                throw new RuntimeException();
            }
            Test_impl test1 = new Test_impl(orb, "test1", false);
            Test_impl test2 = new Test_impl(orb, "test2", false);
            byte[] oid1 = "test1".getBytes();
            byte[] oid2 = "test2".getBytes();
            byte[] oid3 = "testDefault".getBytes();
            try {
                persistentPOA.activate_object_with_id(oid1, (Servant)test1);
                persistentPOA.activate_object_with_id(oid2, (Servant)test2);
            }
            catch (ObjectAlreadyActive ex) {
                throw new RuntimeException();
            }
            catch (ServantAlreadyActive ex) {
                throw new RuntimeException();
            }
            catch (WrongPolicy ex) {
                throw new RuntimeException();
            }
            Object reference1 = persistentPOA.create_reference_with_id(oid1, "IDL:Test:1.0");
            Object reference2 = persistentPOA.create_reference_with_id(oid2, "IDL:Test:1.0");
            Object reference3 = persistentPOA.create_reference_with_id(oid3, "IDL:Test:1.0");
            TestInfo[] info = new TestInfo[]{new TestInfo(), new TestInfo(), new TestInfo()};
            info[0].obj = TestHelper.narrow(reference1);
            info[0].except_id = "";
            info[1].obj = TestHelper.narrow(reference2);
            info[1].except_id = "";
            info[2].obj = TestHelper.narrow(reference3);
            info[2].except_id = "";
            TestServer_impl serverImpl = new TestServer_impl(orb, info);
            TestServer server = serverImpl._this(orb);
            String refFile = "Test.ref";
            try {
                file = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter((OutputStream)file);
                out.println(orb.object_to_string((Object)server));
                out.flush();
                ((FileOutputStream)file).close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            try {
                manager.activate();
            }
            catch (AdapterInactive ex) {
                throw new RuntimeException();
            }
            orb.run();
            file = new File(refFile);
            ((File)file).delete();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

