/*
 * Decompiled with CFR 0.152.
 */
package test.pi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdAssignmentPolicyValueHelper;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValueHelper;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.LifespanPolicyValueHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.RequestProcessingPolicyValueHelper;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValueHelper;
import test.common.TestBase;
import test.pi.ServerORBInitializer_impl;
import test.pi.ServerTestInterceptor_impl;
import test.pi.TestInterfaceDSI_impl;
import test.pi.TestInterface_impl;
import test.pi.TestLocator_impl;

final class Server
extends TestBase {
    private static TestInterface_impl impl;
    private static TestInterfaceDSI_impl dsiImpl;
    private static String refFile;
    private static TestLocator_impl locatorImpl;

    Server() {
    }

    static void ServerRegisterInterceptors(Properties props) {
        props.put("org.omg.PortableInterceptor.ORBInitializerClass.test.pi.ServerORBInitializer_impl", "");
    }

    static int ServerRun(ORB orb, boolean nonBlocking, String[] args) throws UserException {
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        POAManager manager = poa.the_POAManager();
        manager.activate();
        Any any = orb.create_any();
        Policy[] policies = new Policy[6];
        LifespanPolicyValueHelper.insert((Any)any, (LifespanPolicyValue)LifespanPolicyValue.PERSISTENT);
        policies[0] = orb.create_policy(17, any);
        IdAssignmentPolicyValueHelper.insert((Any)any, (IdAssignmentPolicyValue)IdAssignmentPolicyValue.USER_ID);
        policies[1] = orb.create_policy(19, any);
        RequestProcessingPolicyValueHelper.insert((Any)any, (RequestProcessingPolicyValue)RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
        policies[2] = orb.create_policy(22, any);
        ServantRetentionPolicyValueHelper.insert((Any)any, (ServantRetentionPolicyValue)ServantRetentionPolicyValue.NON_RETAIN);
        policies[3] = orb.create_policy(21, any);
        ImplicitActivationPolicyValueHelper.insert((Any)any, (ImplicitActivationPolicyValue)ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION);
        policies[4] = orb.create_policy(20, any);
        any.insert_long(10);
        policies[5] = orb.create_policy(1010, any);
        POA persistentPOA = poa.create_POA("persistent", manager, policies);
        TestInterface_impl impl = new TestInterface_impl(orb, persistentPOA);
        byte[] oid = "test".getBytes();
        Object objImpl = persistentPOA.create_reference_with_id(oid, "IDL:TestInterface:1.0");
        TestInterfaceDSI_impl dsiImpl = new TestInterfaceDSI_impl(orb, persistentPOA);
        oid = "testDSI".getBytes();
        Object objDSIImpl = persistentPOA.create_reference_with_id(oid, "IDL:TestInterface:1.0");
        locatorImpl = new TestLocator_impl(orb, impl, dsiImpl);
        ServantLocator locator = locatorImpl._this(orb);
        persistentPOA.set_servant_manager((ServantManager)locator);
        try {
            FileOutputStream file = new FileOutputStream(refFile);
            PrintWriter out = new PrintWriter(file);
            String strimpl = orb.object_to_string(objImpl);
            out.println(strimpl);
            strimpl = orb.object_to_string(objDSIImpl);
            out.println(strimpl);
            out.flush();
            file.close();
        }
        catch (IOException ex) {
            System.err.println("Can't write to `" + ex.getMessage() + "'");
            return 1;
        }
        CodecFactory factory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
        Server.TEST(factory != null);
        ServerTestInterceptor_impl interceptor = new ServerTestInterceptor_impl(orb, factory);
        ServerORBInitializer_impl.serverProxyManager.setInterceptor(0, interceptor);
        if (!nonBlocking) {
            orb.run();
            Server.ServerCleanup();
        }
        return 0;
    }

    static void ServerCleanup() {
        File file = new File(refFile);
        file.delete();
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            Server.ServerRegisterInterceptors(props);
            props.put("ooc.orb.id", "myORB");
            orb = ORB.init((String[])args, (Properties)props);
            status = Server.ServerRun(orb, false, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }

    static {
        refFile = "TestInterface.ref";
    }
}

