/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util;

import com.ooc.Util.AbstractOption;
import com.ooc.Util.OptionException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringOption
extends AbstractOption {
    private Vector values_ = new Vector();
    int numParams_ = 1;
    private boolean hasValue_ = false;

    public StringOption(char ch) {
        this(ch, null, null);
    }

    public StringOption(String name) {
        this('\u0000', name, null);
    }

    public StringOption(char ch, String name) {
        this(ch, name, null);
    }

    public StringOption(char ch, String name, String property) {
        super(ch, name, property);
    }

    public StringOption(char ch, String name, String property, int numParams) {
        super(ch, name, property);
        this.numParams_ = numParams;
    }

    public StringOption(char ch, String name, String property, String defaultValue) {
        super(ch, name, property);
        this.hasValue_ = true;
        this.values_.addElement(defaultValue);
    }

    public StringOption(char ch, String name, String property, int numParams, String[] defaultValues) {
        super(ch, name, property);
        if (numParams != defaultValues.length) {
            throw new IllegalArgumentException("Length of defaultValues != numParams");
        }
        this.numParams_ = numParams;
        this.hasValue_ = true;
        for (int i = 0; i < defaultValues.length; ++i) {
            this.values_.addElement(defaultValues[i]);
        }
    }

    public void parseProperty(String value) throws OptionException {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() != this.numParams_) {
            throw new OptionException("Invalid value `" + value + "' for " + "property " + this.getProperty() + " - incorrect number of parameters");
        }
        this.values_.removeAllElements();
        while (tokenizer.hasMoreTokens()) {
            this.values_.addElement(tokenizer.nextToken());
        }
        this.hasValue_ = true;
    }

    public void parse(String[] args, int offset) throws OptionException {
        if (args.length - (offset + 1) < this.numParams_) {
            throw new OptionException("Expected " + this.numParams_ + " argument(s) to option `" + args[offset] + "'");
        }
        this.values_ = new Vector();
        args[offset++] = null;
        for (int i = 0; i < this.numParams_; ++i) {
            this.values_.addElement(args[offset]);
            args[offset++] = null;
        }
        this.hasValue_ = true;
        this.parseAction();
    }

    public boolean isDefined() {
        return this.hasValue_;
    }

    public String[] getValues() {
        Object[] result = new String[this.values_.size()];
        this.values_.copyInto(result);
        return result;
    }

    public String getValue() {
        return (String)this.values_.elementAt(0);
    }

    protected void parseAction() throws OptionException {
    }
}

