/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util;

import com.ooc.Util.Option;
import com.ooc.Util.OptionException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class OptionFilter {
    protected Hashtable options_ = new Hashtable();
    protected Vector vec_ = new Vector();

    public void addOption(Option option) {
        if (option.getChar() != '\u0000') {
            this.options_.put("-" + option.getChar(), option);
        }
        if (option.getName() != null) {
            this.options_.put("--" + option.getName(), option);
        }
        this.vec_.addElement(option);
    }

    public Option getOption(char ch) {
        Option result = null;
        Enumeration e = this.vec_.elements();
        while (e.hasMoreElements() && result == null) {
            Option opt = (Option)e.nextElement();
            if (ch != opt.getChar()) continue;
            result = opt;
        }
        return result;
    }

    public Option getOption(String name) {
        Option result = null;
        Enumeration e = this.vec_.elements();
        while (e.hasMoreElements() && result == null) {
            Option opt = (Option)e.nextElement();
            if (!name.equals(opt.getName())) continue;
            result = opt;
        }
        return result;
    }

    public String[] parse(String[] args) throws OptionException {
        return this.parse(args, null);
    }

    public String[] parse(String[] args, Properties props) throws OptionException {
        if (props == null) {
            props = System.getProperties();
        }
        Enumeration e = this.vec_.elements();
        while (e.hasMoreElements()) {
            String value;
            Option option = (Option)e.nextElement();
            String propName = option.getProperty();
            if (propName == null || (value = props.getProperty(propName)) == null) continue;
            option.parseProperty(value);
        }
        Vector<String> rest = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (this.options_.containsKey(args[i])) {
                Option option = (Option)this.options_.get(args[i]);
                option.parse(args, i);
                continue;
            }
            rest.addElement(args[i]);
        }
        Object[] result = new String[rest.size()];
        rest.copyInto(result);
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Enumeration e = this.vec_.elements();
        while (e.hasMoreElements()) {
            Option option = (Option)e.nextElement();
            buff.append(((Object)option).toString() + "\n");
        }
        return buff.toString();
    }
}

