/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.GUI;

import com.ooc.Util.GUI.AppStandards;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Help
extends JDialog
implements HyperlinkListener {
    protected static JFrame parent_;
    private static JButton okBtn_;
    private static JButton backBtn_;
    private static JButton nextBtn_;
    private static JButton homeBtn_;
    protected static Help window_;
    private static JEditorPane htmlPane_;
    private static Stack backStack_;
    private static Stack nextStack_;
    private static Hashtable cache_;
    private static URL url_;
    private static URL mainURL_;

    protected Help(JFrame parent, String tittle) {
        super(parent, tittle, true);
        this.setLocationRelativeTo(parent);
        parent_ = parent;
        backStack_ = new Stack();
        nextStack_ = new Stack();
        cache_ = new Hashtable();
        url_ = mainURL_ = Help.getHelpURL(AppStandards.getString("HelpDialogMainScreen"));
        try {
            htmlPane_ = new JEditorPane(url_);
            htmlPane_.setEditable(false);
            htmlPane_.setBackground(new Color(255, 255, 231));
            htmlPane_.addHyperlinkListener(this);
        }
        catch (IOException ex) {
            // empty catch block
        }
        JScrollPane sp = new JScrollPane(htmlPane_);
        sp.setVerticalScrollBarPolicy(22);
        sp.setPreferredSize(new Dimension(590, 450));
        okBtn_ = new JButton("Ok");
        backBtn_ = new JButton("< Back");
        backBtn_.setEnabled(false);
        nextBtn_ = new JButton("Next >");
        nextBtn_.setEnabled(false);
        homeBtn_ = new JButton("Home");
        okBtn_.addActionListener(new OkAction());
        backBtn_.addActionListener(new BackAction());
        nextBtn_.addActionListener(new NextAction());
        homeBtn_.addActionListener(new HomeAction());
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(homeBtn_);
        p1.add(backBtn_);
        p1.add(nextBtn_);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p2.add((Component)sp, "Center");
        JPanel p3 = new JPanel(new FlowLayout(2));
        p3.add(okBtn_);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)p1, "North");
        contentPane.add((Component)p2, "Center");
        contentPane.add((Component)p3, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public static void initialize(JFrame parent, String tittle) {
        parent_ = parent;
        window_ = new Help(parent_, tittle);
    }

    protected void setURL(URL url) {
        try {
            htmlPane_.setPage(url);
        }
        catch (IOException ex) {
            System.err.println("Read bad URL: " + ex.getMessage());
        }
    }

    public static void showWindow(String helpFile) {
        if (window_ == null) {
            System.err.println("Help is uninitialized...");
        }
        nextStack_ = new Stack();
        backStack_ = new Stack();
        nextBtn_.setEnabled(false);
        backBtn_.setEnabled(false);
        url_ = Help.getHelpURL(helpFile);
        window_.setURL(url_);
        window_.setVisible(true);
    }

    public static URL getHelpURL(String helpFile) {
        URL url = parent_.getClass().getResource("help/" + helpFile);
        if (url != null) {
            return url;
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                backStack_.push(url_);
                url_ = e.getURL();
                window_.setURL(url_);
                backBtn_.setEnabled(true);
                nextBtn_.setEnabled(false);
                nextStack_ = new Stack();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class NextAction
    extends AbstractAction {
        NextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            backStack_.push(url_);
            backBtn_.setEnabled(true);
            url_ = (URL)nextStack_.pop();
            window_.setURL(url_);
            if (nextStack_.empty()) {
                nextBtn_.setEnabled(false);
            }
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
        }

        public void actionPerformed(ActionEvent e) {
            nextStack_.push(url_);
            nextBtn_.setEnabled(true);
            url_ = (URL)backStack_.pop();
            window_.setURL(url_);
            if (backStack_.empty()) {
                backBtn_.setEnabled(false);
            }
        }
    }

    class HomeAction
    extends AbstractAction {
        HomeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                URL tmpURL = (URL)backStack_.peek();
                if (url_.sameFile(tmpURL)) {
                    return;
                }
                backStack_.push(url_);
                window_.setURL(mainURL_);
                backBtn_.setEnabled(true);
                nextBtn_.setEnabled(false);
                nextStack_ = new Stack();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            window_.setVisible(false);
        }
    }
}

