/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.GUI;

import com.ooc.Util.BooleanOption;
import com.ooc.Util.OptionException;
import com.ooc.Util.OptionFilter;
import com.ooc.Util.StringOption;
import java.util.Properties;
import javax.swing.UIManager;

public class GUIOptionFilter
extends OptionFilter {
    private BooleanOption windows_ = new BooleanOption("windows");
    private BooleanOption motif_ = new BooleanOption("motif");
    private BooleanOption mac_ = new BooleanOption("mac");
    private StringOption lookClass_ = new StringOption("look");

    public GUIOptionFilter() {
        this.addOption(this.windows_);
        this.addOption(this.motif_);
        this.addOption(this.mac_);
        this.addOption(this.lookClass_);
    }

    public String[] parse(String[] args, Properties props) throws OptionException {
        String[] result = super.parse(args, props);
        String lookClassName = null;
        if (this.lookClass_.isDefined()) {
            lookClassName = this.lookClass_.getValue();
        } else if (this.windows_.isDefined()) {
            lookClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (this.motif_.isDefined()) {
            lookClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else if (this.mac_.isDefined()) {
            lookClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
        }
        if (lookClassName != null) {
            try {
                UIManager.setLookAndFeel(lookClassName);
            }
            catch (Exception ex) {
                System.err.println("Unsupported Look & Feel: " + lookClassName);
                System.err.println("Reverting to default Look & Feel");
            }
        }
        return result;
    }
}

