/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.CORBA.GUI.IntRep;

import com.ooc.Util.CORBA.GUI.IntRep.IRFilter;
import com.ooc.Util.CORBA.IntRep.IRComponent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class IRTreeNode
implements TreeNode {
    private IRTreeNode parent_;
    private IRComponent component_;
    private IRTreeNode[] children_ = null;
    private IRFilter filter_;

    public IRTreeNode(IRTreeNode parent, IRComponent component, IRFilter filter) {
        this.parent_ = parent;
        this.component_ = component;
        this.filter_ = filter;
    }

    public IRComponent getComponent() {
        return this.component_;
    }

    public TreeNode getChildAt(int childIndex) {
        this.createChildren();
        return this.children_[childIndex];
    }

    public int getChildCount() {
        this.createChildren();
        return this.children_.length;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public int getIndex(TreeNode node) {
        int result = -1;
        for (int i = 0; i < this.children_.length && result == -1; ++i) {
            if (this.children_[i] != node) continue;
            result = i;
        }
        return result;
    }

    public boolean getAllowsChildren() {
        return this.component_.isContainer();
    }

    public boolean isLeaf() {
        if (this.filter_ != null) {
            return this.filter_.isLeaf(this.component_);
        }
        return !this.component_.isContainer();
    }

    public synchronized Enumeration children() {
        return null;
    }

    public IRTreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public String toString() {
        return this.component_.getName();
    }

    private IRTreeNode[] getPathToRoot(IRTreeNode node, int depth) {
        IRTreeNode[] result;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            result = new IRTreeNode[depth];
        } else {
            result = this.getPathToRoot((IRTreeNode)node.getParent(), ++depth);
            result[result.length - depth] = node;
        }
        return result;
    }

    private void createChildren() {
        if (this.children_ == null && this.component_.isContainer()) {
            IRComponent[] contents = this.component_.getContents();
            Vector<IRTreeNode> vec = new Vector<IRTreeNode>();
            for (int i = 0; i < contents.length; ++i) {
                if (this.filter_ != null) {
                    if (!this.filter_.accept(contents[i])) continue;
                    vec.addElement(new IRTreeNode(this, contents[i], this.filter_));
                    continue;
                }
                vec.addElement(new IRTreeNode(this, contents[i], this.filter_));
            }
            this.children_ = new IRTreeNode[vec.size()];
            vec.copyInto(this.children_);
        }
    }
}

