/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.CORBA.GUI;

import com.ooc.Util.CORBA.GUI.FileChooserFilter;
import com.ooc.Util.CORBA.IORUtil;
import com.ooc.Util.GUI.AppStandards;
import com.ooc.Util.GUI.Constrain;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.omg.CORBA.Object;

public class IORInputPanel
extends JPanel
implements ActionListener,
ItemListener {
    private Frame parent_;
    private JRadioButton ior_;
    private JRadioButton file_;
    private JButton browse_;
    private JTextField text_;
    private JFileChooser chooser_;

    public IORInputPanel(Frame parent, String iorLabelKey) {
        this.parent_ = parent;
        this.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        this.ior_ = AppStandards.createRadioButton(iorLabelKey);
        this.ior_.addItemListener(this);
        group.add(this.ior_);
        Constrain.constrain(this, this.ior_, 0, 0, 1, 1, 0, 17);
        this.file_ = AppStandards.createRadioButton("IORFileKey");
        this.file_.addItemListener(this);
        group.add(this.file_);
        Constrain.constrain(this, this.file_, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        this.browse_ = AppStandards.createButton("BrowseButtonKey");
        this.browse_.addActionListener(this);
        this.browse_.setActionCommand("browse");
        Constrain.constrain(this, this.browse_, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        this.text_ = AppStandards.createTextField(30);
        Constrain.constrain(this, this.text_, 0, 1, 3, 1, 2, 17, 1.0, 0.0, 5, 0, 0, 0);
        this.reset();
    }

    public void reset() {
        this.text_.setText("");
        this.ior_.setSelected(true);
    }

    public void setIOR(String ref) {
        this.ior_.setSelected(true);
        this.text_.setText(ref);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("browse")) {
            IORInputPanel iORInputPanel = this;
            synchronized (iORInputPanel) {
                if (this.chooser_ == null) {
                    this.chooser_ = new JFileChooser();
                    this.chooser_.setDialogTitle(AppStandards.getString("IORFileTitleKey"));
                    this.chooser_.addChoosableFileFilter(new FileChooserFilter("IORs (*.ior)", "ior"));
                }
            }
            int result = this.chooser_.showDialog(this.parent_, "OK");
            if (result == 0) {
                File file = this.chooser_.getSelectedFile();
                this.text_.setText(file.getAbsolutePath());
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.text_.setText("");
            if (e.getItem() == this.ior_) {
                this.browse_.setEnabled(false);
            } else {
                this.browse_.setEnabled(true);
            }
        }
    }

    public Object getObject(StringBuffer message) {
        Object result = null;
        String s = this.text_.getText().trim();
        result = this.ior_.isSelected() ? IORUtil.getObject(s, message) : IORUtil.getObject(new File(s), message);
        return result;
    }

    public boolean isNil() {
        String ref;
        boolean result = false;
        if (this.ior_.isSelected() && (ref = this.text_.getText().trim()).length() == 0) {
            result = true;
        }
        return result;
    }

    public JTextField getTextField() {
        return this.text_;
    }
}

