/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CORBA.ORB;
import com.ooc.CosEvent.EventService;
import com.ooc.CosEvent.TypedEventService;
import com.ooc.OB.Assert;
import com.ooc.OB.BootManager;
import com.ooc.OB.BootManagerHelper;
import com.ooc.OB.BootManagerPackage.AlreadyExists;
import com.ooc.OBEventChannelFactory.ChannelAlreadyExists;
import com.ooc.OBEventChannelFactory.EventChannelFactory;
import com.ooc.OBTypedEventChannelFactory.TypedEventChannelFactory;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CosEventChannelAdmin.EventChannel;
import org.omg.CosTypedEventChannelAdmin.TypedEventChannel;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public final class Server {
    static void usage(String progName) {
        System.err.println("Usage:");
        System.err.println(progName + " [options]\n" + "\n" + "Options:\n" + "-h, --help             " + "Show this message.\n" + "-v, --version          " + "Show Event Service version.\n" + "-i, --ior              " + "Print IOR on standard output.\n" + "-t, --typed-service    " + "Run typed event service.\n" + "-u, --untyped-service  " + "Run untyped event service [default].\n");
    }

    static int run(org.omg.CORBA.ORB orb, String[] args, boolean typedService) {
        String s;
        String progName = "com.ooc.CosEvent.Server";
        Object poaObj = null;
        try {
            poaObj = orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        POA rootPOA = POAHelper.narrow((Object)poaObj);
        POAManager manager = rootPOA.the_POAManager();
        boolean ior = false;
        for (int i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                Server.usage(progName);
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.err.println("ORBacus Event Service 4.1.3");
                return 0;
            }
            if (args[i].equals("--ior") || args[i].equals("-i")) {
                ior = true;
                continue;
            }
            if (args[i].equals("--typed-service") || args[i].equals("-t")) {
                typedService = true;
                continue;
            }
            if (args[i].equals("--untyped-service") || args[i].equals("-u")) {
                typedService = false;
                continue;
            }
            System.out.println(progName + ": unknown option `" + args[i] + "'\n");
            Server.usage(progName);
            return 1;
        }
        POA poa = null;
        try {
            Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            poa = rootPOA.create_POA("EventServicePOA", manager, policies);
        }
        catch (InvalidPolicy ex) {
            throw new RuntimeException();
        }
        catch (AdapterAlreadyExists ex) {
            throw new RuntimeException();
        }
        BootManager bootManager = null;
        try {
            bootManager = BootManagerHelper.narrow((Object)orb.resolve_initial_references("BootManager"));
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        EventService untyped = null;
        TypedEventService typed = null;
        if (!typedService) {
            untyped = new EventService(orb, poa);
            try {
                untyped.initialize();
            }
            catch (WrongPolicy ex) {
                throw new RuntimeException();
            }
            EventChannelFactory untypedFactory = untyped.eventChannelFactory();
            try {
                manager.activate();
            }
            catch (AdapterInactive ex) {
                throw new RuntimeException();
            }
            EventChannel untypedChannel = null;
            try {
                untypedChannel = untypedFactory.create_channel("DefaultEventChannel");
            }
            catch (ChannelAlreadyExists ex) {
                throw new RuntimeException();
            }
            byte[] oid = "DefaultEventChannelFactory".getBytes();
            try {
                bootManager.add_binding(oid, (Object)untypedFactory);
            }
            catch (AlreadyExists ex) {
                throw new RuntimeException();
            }
            oid = "DefaultEventChannel".getBytes();
            try {
                bootManager.add_binding(oid, (Object)untypedChannel);
            }
            catch (AlreadyExists ex) {
                throw new RuntimeException();
            }
            s = orb.object_to_string((Object)untypedChannel);
        } else {
            try {
                Object ir = orb.resolve_initial_references("InterfaceRepository");
            }
            catch (InvalidName ex) {
                System.err.println(progName + ": no `InterfaceRepository' initial reference.");
                return 1;
            }
            typed = new TypedEventService(orb, poa);
            try {
                typed.initialize();
            }
            catch (WrongPolicy ex) {
                throw new RuntimeException();
            }
            TypedEventChannelFactory typedFactory = typed.typedEventChannelFactory();
            try {
                manager.activate();
            }
            catch (AdapterInactive ex) {
                throw new RuntimeException();
            }
            TypedEventChannel typedChannel = null;
            try {
                typedChannel = typedFactory.create_channel("DefaultTypedEventChannel");
            }
            catch (ChannelAlreadyExists ex) {
                throw new RuntimeException();
            }
            byte[] oid = "DefaultTypedEventChannelFactory".getBytes();
            try {
                bootManager.add_binding(oid, (Object)typedFactory);
            }
            catch (AlreadyExists ex) {
                throw new RuntimeException();
            }
            oid = "DefaultTypedEventChannel".getBytes();
            try {
                bootManager.add_binding(oid, (Object)typedChannel);
            }
            catch (AlreadyExists ex) {
                throw new RuntimeException();
            }
            s = orb.object_to_string((Object)typedChannel);
        }
        if (ior) {
            System.out.println(s);
        }
        orb.run();
        return 0;
    }

    public static void main(String[] args) {
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        try {
            args = ORB.ParseArgs((String[])args, (Properties)props, null);
            boolean typedService = false;
            String propRoot = "ooc.event.";
            Enumeration<java.lang.Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(propRoot)) continue;
                String value = props.getProperty(key);
                Assert._OB_assert((value != null ? 1 : 0) != 0);
                if (key.equals("ooc.event.endpoint")) {
                    String oaPort = props.getProperty("ooc.orb.oa.endpoint");
                    if (oaPort != null) continue;
                    props.put("ooc.orb.oa.endpoint", value);
                    continue;
                }
                if (!key.equals("ooc.event.typed_service") || !value.equals("true")) continue;
                typedService = true;
            }
            props.put("ooc.orb.conc_model", "threaded");
            String oaModel = props.getProperty("ooc.orb.oa.conc_model");
            if (!(oaModel.equals("thread_per_client") || oaModel.equals("thread_per_request") || oaModel.equals("thread_pool"))) {
                props.put("ooc.orb.oa.conc_model", "thread_pool");
            }
            StringSeqHolder argsH = new StringSeqHolder(args);
            orb = ORB.init((StringSeqHolder)argsH, (Properties)props, null);
            status = Server.run(orb, argsH.value, typedService);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

