/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CosEvent.EventLogger;
import com.ooc.CosEvent.Event_impl;
import com.ooc.CosEvent.PropagatorBaseThread;
import com.ooc.CosEvent.PushResult;
import java.util.Vector;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventComm.PushConsumer;

public abstract class PusherBaseThread
extends PropagatorBaseThread {
    private Vector events_ = new Vector();
    private long maxEvents_;
    public PushConsumer consumer_;
    public ProxyPushSupplier proxy_;

    public PusherBaseThread(String name, PushConsumer consumer, ProxyPushSupplier proxy, EventLogger logger, long id, long maxEvents, long maxRetries, long retryTimeout, double retryMultiplier) {
        super(logger, name, id, maxRetries, retryTimeout, retryMultiplier);
        this.maxEvents_ = maxEvents;
        this.consumer_ = consumer;
        this.proxy_ = proxy;
    }

    public synchronized void newEvent(Event_impl event) {
        this.events_.insertElementAt(event, 0);
        if ((long)this.events_.size() > this.maxEvents_) {
            Event_impl e = (Event_impl)this.events_.elementAt(this.events_.size() - 1);
            if (this.logger_.traceEvents() >= 1) {
                this.logger_.trace("event", "PusherBaseThread(" + this.id_ + ") discarding event (" + e.eventId() + ")");
            }
            this.events_.removeElementAt(this.events_.size() - 1);
        }
        this.notify();
    }

    public void run() {
        Event_impl event;
        while ((event = this.waitEvent()) != null) {
            PushResult rc = this.pushEvent(event);
            if (rc == PushResult.Success) {
                this.resetRetry();
                this.removeEvent(event);
                continue;
            }
            if (rc == PushResult.Retry) {
                if (this.retry()) continue;
                if (this.logger_.traceEvents() >= 1) {
                    this.logger_.trace("event", "retries exceeded: disconnecting " + this.id_);
                }
            }
            try {
                this.proxy_.disconnect_push_supplier();
            }
            catch (Exception exception) {}
        }
    }

    private synchronized Event_impl waitEvent() {
        while (!this.done_ && this.events_.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Event_impl event = !this.done_ ? (Event_impl)this.events_.elementAt(this.events_.size() - 1) : null;
        return event;
    }

    private synchronized void removeEvent(Event_impl event) {
        if (this.events_.elementAt(this.events_.size() - 1) == event) {
            this.events_.removeElementAt(this.events_.size() - 1);
        }
    }

    public abstract PushResult pushEvent(Event_impl var1);
}

