/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OCI.IIOP;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.IORUtil;
import com.ooc.OB.ProtocolPolicy;
import com.ooc.OB.ProtocolPolicyHelper;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ConFactory;
import com.ooc.OCI.ConFactoryInfo;
import com.ooc.OCI.ConnectCB;
import com.ooc.OCI.Connector;
import com.ooc.OCI.IIOP.ConFactoryInfo_impl;
import com.ooc.OCI.IIOP.Connector_impl;
import com.ooc.OCI.IIOP.Util;
import java.util.Vector;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

final class ConFactory_impl
extends LocalObject
implements ConFactory {
    private boolean keepAlive_;
    private ConFactoryInfo_impl info_;

    public String id() {
        return "iiop";
    }

    public int tag() {
        return 0;
    }

    public String describe_profile(TaggedProfile profile) {
        Assert._OB_assert(profile.tag == 0);
        byte[] data = profile.profile_data;
        Buffer buf = new Buffer(data, data.length);
        InputStream in = new InputStream(buf);
        in._OB_readEndian();
        ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
        StringBuffer result = new StringBuffer();
        result.append("iiop_version: " + body.iiop_version.major + '.' + body.iiop_version.minor + '\n');
        result.append("host: " + body.host + '\n');
        int port = body.port < 0 ? 65535 + body.port + 1 : body.port;
        result.append("port: " + port + '\n');
        result.append("object_key: (" + body.object_key.length + ")\n");
        String tmp = IORUtil.dump_octets(body.object_key, 0, body.object_key.length);
        result.append(tmp);
        if (body.iiop_version.major > 1 || body.iiop_version.minor >= 1) {
            int l = in.read_ulong();
            for (int i = 0; i < l; ++i) {
                TaggedComponent component = TaggedComponentHelper.read(in);
                String desc = IORUtil.describe_component(component);
                result.append(desc);
            }
        }
        return result.toString();
    }

    public Connector[] create_connectors(IOR ior, Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            ProtocolPolicy protocolPolicy;
            if (policies[i].policy_type() != 1330577410 || (protocolPolicy = ProtocolPolicyHelper.narrow(policies[i])).contains("iiop")) continue;
            return new Connector[0];
        }
        Vector<Connector_impl> seq = new Vector<Connector_impl>();
        for (int i = 0; i < ior.profiles.length; ++i) {
            int c;
            if (ior.profiles[i].tag != this.tag()) continue;
            byte[] data = ior.profiles[i].profile_data;
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf, 0, false);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
            int port = body.port < 0 ? 65535 + body.port + 1 : body.port;
            ConnectCB[] cbs = this.info_._OB_getConnectCBSeq();
            seq.addElement(new Connector_impl(body.host, port, this.keepAlive_, cbs));
            if (body.iiop_version.major <= 1 && body.iiop_version.minor <= 0) continue;
            int len = in.read_ulong();
            TaggedComponent[] components = new TaggedComponent[len];
            for (c = 0; c < len; ++c) {
                components[c] = TaggedComponentHelper.read(in);
            }
            for (c = 0; c < components.length; ++c) {
                if (components[c].tag != 3) continue;
                byte[] cdata = components[c].component_data;
                int clen = components[c].component_data.length;
                Buffer cbuf = new Buffer(cdata, clen);
                InputStream cin = new InputStream(cbuf, 0, false);
                cin._OB_readEndian();
                String host = cin.read_string();
                int s = cin.read_ushort();
                int cport = s < 0 ? 65535 + s + 1 : s;
                ConnectCB[] ccbs = this.info_._OB_getConnectCBSeq();
                seq.addElement(new Connector_impl(host, cport, this.keepAlive_, ccbs));
            }
        }
        Object[] result = new Connector[seq.size()];
        seq.copyInto(result);
        return result;
    }

    public boolean equivalent(IOR ior1, IOR ior2) {
        return Util.equivalent(ior1, ior2);
    }

    public int hash(IOR ior, int max) {
        return Util.hash(ior, max);
    }

    public ConFactoryInfo get_info() {
        return this.info_;
    }

    public ConFactory_impl(boolean keepAlive) {
        this.keepAlive_ = keepAlive;
        this.info_ = new ConFactoryInfo_impl();
    }

    public void finalize() throws Throwable {
        super.finalize();
    }
}

