/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.Any;
import com.ooc.CORBA.DataInputStream;
import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.TypeCode;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Util;
import com.ooc.OB.ValueFactoryManager;
import com.ooc.OCI.Buffer;
import java.io.Serializable;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;

public final class ValueReader {
    private ORBInstance orbInstance_;
    private InputStream in_;
    private Buffer buf_;
    private Hashtable instanceTable_;
    private Hashtable headerTable_;
    private Hashtable positionTable_ = null;
    private ChunkState chunkState_ = new ChunkState();
    private Header currentHeader_ = null;

    private void addInstance(int pos, Serializable instance) {
        this.instanceTable_.put(new Integer(pos), instance);
    }

    private void removeInstance(int pos) {
        this.instanceTable_.remove(new Integer(pos));
    }

    private void readHeader(Header h) {
        int offs;
        int indTag;
        int save;
        Assert._OB_assert(h.tag != 0 && h.tag != -1);
        if ((h.tag & 8) == 8) {
            h.state.chunked = true;
        }
        if ((h.tag & 1) == 1) {
            String codebase = null;
            save = this.buf_.pos_;
            indTag = this.in_.read_long();
            if (indTag == -1) {
                offs = this.in_.read_long();
                if (offs >= -4) {
                    throw new MARSHAL();
                }
                int tmp = this.buf_.pos_;
                this.buf_.pos_ = this.buf_.pos_ - 4 + offs;
                if (this.buf_.pos_ < 0) {
                    throw new MARSHAL();
                }
                codebase = this.in_.read_string();
                this.buf_.pos_ = tmp;
            } else {
                this.buf_.pos_ = save;
                codebase = this.in_.read_string();
            }
        }
        if ((h.tag & 6) != 0) {
            if ((h.tag & 6) == 6) {
                boolean indList;
                int saveList = this.buf_.pos_;
                int indTag2 = this.in_.read_long();
                boolean bl = indList = indTag2 == -1;
                if (indList) {
                    offs = this.in_.read_long();
                    if (offs > -4) {
                        throw new MARSHAL();
                    }
                    saveList = this.buf_.pos_;
                    this.buf_.pos_ = this.buf_.pos_ - 4 + offs;
                    if (this.buf_.pos_ < 0) {
                        throw new MARSHAL();
                    }
                } else {
                    this.buf_.pos_ = saveList;
                }
                int count = this.in_.read_long();
                h.ids = new String[count];
                for (int i = 0; i < count; ++i) {
                    int saveRep = this.buf_.pos_;
                    indTag2 = this.in_.read_long();
                    if (indTag2 == -1) {
                        int offs2 = this.in_.read_long();
                        if (offs2 > -4) {
                            throw new MARSHAL();
                        }
                        saveRep = this.buf_.pos_;
                        this.buf_.pos_ = this.buf_.pos_ - 4 + offs2;
                        if (this.buf_.pos_ < 0) {
                            throw new MARSHAL();
                        }
                        h.ids[i] = this.in_.read_string();
                        this.buf_.pos_ = saveRep;
                        continue;
                    }
                    this.buf_.pos_ = saveRep;
                    h.ids[i] = this.in_.read_string();
                }
                if (indList) {
                    this.buf_.pos_ = saveList;
                }
            } else if ((h.tag & 6) == 2) {
                String id;
                save = this.buf_.pos_;
                indTag = this.in_.read_long();
                if (indTag == -1) {
                    offs = this.in_.read_long();
                    if (offs > -4) {
                        throw new MARSHAL();
                    }
                    save = this.buf_.pos_;
                    this.buf_.pos_ = this.buf_.pos_ - 4 + offs;
                    if (this.buf_.pos_ < 0) {
                        throw new MARSHAL();
                    }
                    id = this.in_.read_string();
                    this.buf_.pos_ = save;
                } else {
                    this.buf_.pos_ = save;
                    id = this.in_.read_string();
                }
                h.ids = new String[1];
                h.ids[0] = id;
            }
        }
        h.dataPos = this.buf_.pos_;
        this.headerTable_.put(new Integer(h.headerPos), h);
    }

    private void readChunk(ChunkState state) {
        int size = this.in_._OB_readLongUnchecked();
        if (size >= 0 && size < 0x7FFFFF00) {
            state.chunkStart = this.buf_.pos_;
            state.chunkSize = size;
        } else if (size < 0) {
            this.buf_.pos_ -= 4;
            state.chunkStart = this.buf_.pos_;
            state.chunkSize = 0;
        } else {
            this.buf_.pos_ -= 4;
            state.chunkStart = 0;
            state.chunkSize = 0;
        }
    }

    private void initHeader(Header h) {
        Assert._OB_assert(h.tag != 0 && h.tag != -1);
        h.headerPos = this.buf_.pos_ - 4;
        h.state.copyFrom(this.chunkState_);
        this.readHeader(h);
        this.chunkState_.copyFrom(h.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
            ++this.chunkState_.nestingLevel;
        }
    }

    private void skipChunk() {
        if (this.chunkState_.chunked) {
            if (this.chunkState_.chunkStart > 0) {
                this.buf_.pos_ = this.chunkState_.chunkStart;
                this.in_._OB_skip(this.chunkState_.chunkSize);
            }
            this.chunkState_.chunkStart = 0;
            this.chunkState_.chunkSize = 0;
            int level = this.chunkState_.nestingLevel;
            int tag = this.in_._OB_readLongUnchecked();
            while (tag >= 0 || tag < 0 && tag < -this.chunkState_.nestingLevel) {
                if (tag >= 0x7FFFFF00) {
                    Header nest = new Header();
                    nest.tag = tag;
                    nest.headerPos = this.buf_.pos_ - 4;
                    nest.state.nestingLevel = ++level;
                    this.readHeader(nest);
                } else if (tag >= 0) {
                    this.in_._OB_skip(tag);
                } else {
                    --level;
                }
                tag = this.in_._OB_readLongUnchecked();
            }
            if (tag > -this.chunkState_.nestingLevel) {
                this.buf_.pos_ -= 4;
            }
            --this.chunkState_.nestingLevel;
            if (this.chunkState_.nestingLevel == 0) {
                this.chunkState_.chunked = false;
            } else {
                this.readChunk(this.chunkState_);
            }
        }
    }

    private void unmarshalValueState(Serializable v) {
        if (v instanceof StreamableValue) {
            ((StreamableValue)v)._read(this.in_);
        } else if (v instanceof CustomMarshal) {
            DataInputStream dis = new DataInputStream(this.in_);
            ((CustomMarshal)((Object)v)).unmarshal(dis);
        } else {
            throw new MARSHAL("Valuetype does not implement StreamableValue or CustomMarshal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable readIndirection(CreationStrategy strategy) {
        Integer posObj;
        Serializable v;
        int offs = this.in_.read_long();
        int pos = this.buf_.pos_ - 4 + offs;
        pos += 3;
        if ((v = (Serializable)this.instanceTable_.get(posObj = new Integer(pos -= pos & 3))) != null) {
            return v;
        }
        int save = this.buf_.pos_;
        this.buf_.pos_ = pos;
        if (this.in_._OB_readLongUnchecked() == 0) {
            this.buf_.pos_ = save;
            return null;
        }
        Header nest = (Header)this.headerTable_.get(posObj);
        if (nest == null) {
            throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": cannot instantiate value for indirection", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.buf_.pos_ = nest.dataPos;
        ChunkState saveState = new ChunkState(this.chunkState_);
        this.chunkState_.copyFrom(nest.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
        }
        try {
            v = strategy.create(nest);
        }
        finally {
            this.buf_.pos_ = save;
            this.chunkState_.copyFrom(saveState);
        }
        return v;
    }

    private Serializable read(CreationStrategy strategy) {
        Header h = new Header();
        h.tag = this.in_.read_long();
        if (h.tag == 0) {
            return null;
        }
        if (h.tag == -1) {
            return this.readIndirection(strategy);
        }
        if (h.tag < 0x7FFFFF00) {
            throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(h.tag));
        }
        this.initHeader(h);
        Serializable vb = strategy.create(h);
        this.skipChunk();
        return vb;
    }

    private void copyValueState(org.omg.CORBA.TypeCode tc, OutputStream out) {
        try {
            if (tc.kind() == TCKind.tk_value) {
                org.omg.CORBA.TypeCode base = tc.concrete_base_type();
                if (base != null) {
                    this.copyValueState(base, out);
                }
                for (int i = 0; i < tc.member_count(); ++i) {
                    out.write_InputStream(this.in_, tc.member_type(i));
                }
            } else if (tc.kind() == TCKind.tk_value_box) {
                out.write_InputStream(this.in_, tc.content_type());
            } else {
                Assert._OB_assert(false);
            }
        }
        catch (BadKind ex) {
            Assert._OB_assert(false);
        }
        catch (Bounds ex) {
            Assert._OB_assert(false);
        }
    }

    private void pushHeader(Header h) {
        h.next = this.currentHeader_;
        this.currentHeader_ = h;
    }

    private void popHeader() {
        Assert._OB_assert(this.currentHeader_ != null);
        this.currentHeader_ = this.currentHeader_.next;
    }

    private org.omg.CORBA.TypeCode findTypeCode(String id, org.omg.CORBA.TypeCode tc) {
        org.omg.CORBA.TypeCode result = null;
        org.omg.CORBA.TypeCode t = tc;
        while (result == null) {
            try {
                org.omg.CORBA.TypeCode t2 = TypeCode._OB_getOrigType(t);
                if (id.equals(t2.id())) {
                    result = t;
                    continue;
                }
                if (t2.kind() != TCKind.tk_value || t2.type_modifier() != 3) break;
                t = t2.concrete_base_type();
            }
            catch (BadKind ex) {
                Assert._OB_assert(false);
            }
        }
        return result;
    }

    public ValueReader(InputStream in) {
        this.in_ = in;
        this.buf_ = in._OB_buffer();
        this.orbInstance_ = in._OB_ORBInstance();
        this.instanceTable_ = new Hashtable(131);
        this.headerTable_ = new Hashtable(131);
    }

    public Serializable readValue() {
        FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, null);
        return this.read(strategy);
    }

    public Serializable readValue(String id) {
        FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, id);
        return this.read(strategy);
    }

    public Serializable readValue(Class clz) {
        ClassCreationStrategy strategy = new ClassCreationStrategy(this, this.in_, clz);
        return this.read(strategy);
    }

    public Serializable readValueBox(BoxedValueHelper helper) {
        BoxCreationStrategy strategy = new BoxCreationStrategy(this, this.in_, helper);
        return this.read(strategy);
    }

    public void initializeValue(Serializable value) {
        Assert._OB_assert(this.currentHeader_ != null);
        this.addInstance(this.currentHeader_.headerPos, value);
        try {
            this.unmarshalValueState(value);
        }
        catch (SystemException ex) {
            this.removeInstance(this.currentHeader_.headerPos);
            throw ex;
        }
    }

    public Object readAbstractInterface() {
        if (this.in_.read_boolean()) {
            return this.in_.read_Object();
        }
        return this.readValue();
    }

    public Object readAbstractInterface(Class clz) {
        if (this.in_.read_boolean()) {
            return this.in_.read_Object(clz);
        }
        return this.readValue(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public org.omg.CORBA.TypeCode remarshalValue(org.omg.CORBA.TypeCode tc, OutputStream out) {
        if (this.positionTable_ == null) {
            this.positionTable_ = new Hashtable(131);
        }
        org.omg.CORBA.TypeCode origTC = TypeCode._OB_getOrigType(tc);
        org.omg.CORBA.TypeCode result = null;
        Header h = new Header();
        h.tag = this.in_.read_long();
        h.headerPos = this.buf_.pos_ - 4;
        h.state.copyFrom(this.chunkState_);
        int pos = h.headerPos;
        if (h.tag == 0) {
            out.write_long(0);
            result = tc;
        } else if (h.tag == -1) {
            Integer newPos;
            int offs = this.in_.read_long();
            int oldPos = this.buf_.pos_ - 4 + offs;
            oldPos += 3;
            if ((newPos = (Integer)this.positionTable_.get(new Integer(oldPos -= oldPos & 3))) == null) throw new MARSHAL("Cannot find value for indirection");
            out.write_long(h.tag);
            offs = newPos - out._OB_pos();
            out.write_long(offs);
            result = tc;
        } else {
            int idPos;
            int outPos = out._OB_pos();
            outPos += 3;
            outPos -= outPos & 3;
            this.positionTable_.put(new Integer(pos), new Integer(outPos));
            this.readHeader(h);
            this.chunkState_.copyFrom(h.state);
            if (this.chunkState_.chunked) {
                this.readChunk(this.chunkState_);
                ++this.chunkState_.nestingLevel;
            }
            String tcId = null;
            short mod = 0;
            try {
                tcId = origTC.id();
                if (origTC.kind() == TCKind.tk_value) {
                    mod = origTC.type_modifier();
                }
            }
            catch (BadKind ex) {
                Assert._OB_assert(false);
            }
            String id = null;
            for (idPos = 0; idPos < h.ids.length; ++idPos) {
                if (!tcId.equals(h.ids[idPos])) continue;
                id = h.ids[idPos];
                break;
            }
            String factoryId = null;
            int factoryPos = 0;
            ValueFactory factory = null;
            if (this.orbInstance_ != null) {
                ValueFactoryManager manager = this.orbInstance_.getValueFactoryManager();
                for (factoryPos = 0; factoryPos < h.ids.length; ++factoryPos) {
                    factory = manager.lookupValueFactoryWithClass(h.ids[factoryPos]);
                    if (factory == null) continue;
                    factoryId = h.ids[factoryPos];
                    break;
                }
            }
            if (h.ids.length > 0 && id == null && factoryId == null) {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": insufficient information to copy valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (mod == 1 && factoryId == null) {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": unable to copy custom valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (idPos < factoryPos || h.ids.length == 0 || origTC.kind() == TCKind.tk_value_box) {
                int numIds = h.ids.length - idPos;
                String[] ids = new String[numIds];
                for (int i = idPos; i < h.ids.length; ++i) {
                    ids[i - idPos] = h.ids[i];
                }
                out._OB_beginValue(h.tag, ids, h.state.chunked);
                this.copyValueState(origTC, out);
                out._OB_endValue();
                result = tc;
            } else {
                try {
                    this.pushHeader(h);
                    Serializable vb = factory.read_value(this.in_);
                    try {
                        out.write_value(vb);
                    }
                    finally {
                        this.removeInstance(h.headerPos);
                    }
                }
                finally {
                    this.popHeader();
                }
                result = this.findTypeCode(h.ids[factoryPos], tc);
                if (result == null) {
                    result = tc;
                }
            }
            this.skipChunk();
        }
        Assert._OB_assert(result != null);
        return result;
    }

    public void readValueAny(org.omg.CORBA.Any any, org.omg.CORBA.TypeCode tc) {
        Any obAny = null;
        try {
            obAny = (Any)any;
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        org.omg.CORBA.TypeCode origTC = TypeCode._OB_getOrigType(tc);
        if (origTC.kind() == TCKind.tk_abstract_interface) {
            boolean b = this.in_.read_boolean();
            if (b) {
                any.insert_Object(this.in_.read_Object(), tc);
                return;
            }
            any.insert_Value(this.readValue(), tc);
            return;
        }
        try {
            String id = origTC.id();
            if (id.equals("IDL:omg.org/CORBA/ValueBase:1.0")) {
                any.insert_Value(this.readValue(), tc);
                return;
            }
        }
        catch (BadKind ex) {
            Assert._OB_assert(false);
        }
        int startPos = this.buf_.pos_;
        ChunkState startState = new ChunkState(this.chunkState_);
        if (origTC.kind() == TCKind.tk_value_box) {
            try {
                any.insert_Value(this.readValue(tc.id()), tc);
                return;
            }
            catch (MARSHAL ex) {
                this.buf_.pos_ = startPos;
                this.chunkState_.copyFrom(startState);
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_ORBInstance(this.orbInstance_);
                this.remarshalValue(origTC, out);
                InputStream in = (InputStream)out.create_input_stream();
                Assert._OB_assert(obAny != null);
                obAny.replace(tc, in);
            }
            catch (BadKind ex) {
                Assert._OB_assert(false);
            }
        } else {
            Header h = new Header();
            h.tag = this.in_.read_long();
            if (h.tag == 0) {
                any.insert_Value(null, tc);
                return;
            }
            if (h.tag != -1 && h.tag < 0x7FFFFF00) {
                throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(h.tag));
            }
            FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, null);
            try {
                if (h.tag == -1) {
                    any.insert_Value(this.readIndirection(strategy), tc);
                    return;
                }
                this.initHeader(h);
                StringHolder idH = new StringHolder();
                Serializable vb = strategy.create(h, idH);
                this.skipChunk();
                org.omg.CORBA.TypeCode t = this.findTypeCode(idH.value, tc);
                if (t != null) {
                    any.insert_Value(vb, t);
                } else {
                    any.insert_Value(vb, tc);
                }
                return;
            }
            catch (MARSHAL ex) {
                this.buf_.pos_ = startPos;
                this.chunkState_.copyFrom(startState);
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_ORBInstance(this.orbInstance_);
                org.omg.CORBA.TypeCode t = this.remarshalValue(origTC, out);
                InputStream in = (InputStream)out.create_input_stream();
                Assert._OB_assert(obAny != null);
                obAny.replace(t, in);
                return;
            }
        }
        Assert._OB_assert(false);
    }

    public void beginValue() {
        Header h = new Header();
        h.tag = this.in_.read_long();
        Assert._OB_assert(h.tag != 0 && h.tag != -1);
        this.initHeader(h);
    }

    public void endValue() {
        this.skipChunk();
    }

    public void checkChunk() {
        if (!this.chunkState_.chunked) {
            return;
        }
        if (this.chunkState_.chunkStart > 0 && this.chunkState_.chunkStart + this.chunkState_.chunkSize == this.buf_.pos_) {
            this.readChunk(this.chunkState_);
        }
    }

    private static class FactoryCreationStrategy
    extends CreationStrategy {
        private String id_;
        private ORBInstance orbInstance_;

        FactoryCreationStrategy(ValueReader reader, InputStream is, String id) {
            super(reader, is);
            this.id_ = id;
            this.orbInstance_ = is._OB_ORBInstance();
        }

        private ValueFactory findFactory(Header h, StringHolder id) {
            ValueFactory f = null;
            if (this.orbInstance_ != null) {
                ValueFactoryManager manager = this.orbInstance_.getValueFactoryManager();
                if (h.ids.length > 0) {
                    for (int i = 0; i < h.ids.length; ++i) {
                        f = manager.lookupValueFactoryWithClass(h.ids[i]);
                        if (f != null) {
                            id.value = h.ids[i];
                        } else if (this.id_ == null || !h.ids[i].equals(this.id_)) {
                            continue;
                        }
                        break;
                    }
                } else if (this.id_ != null) {
                    f = manager.lookupValueFactoryWithClass(this.id_);
                    id.value = this.id_;
                }
            }
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Serializable createWithFactory(Header h, ValueFactory factory) {
            try {
                this.reader_.pushHeader(h);
                Serializable serializable = factory.read_value(this.is_);
                return serializable;
            }
            finally {
                this.reader_.popHeader();
            }
        }

        private BoxedValueHelper getBoxedHelper(String id) {
            Object result = null;
            Class helperClass = Util.idToClass(id, "Helper");
            if (helperClass != null) {
                try {
                    return (BoxedValueHelper)helperClass.newInstance();
                }
                catch (ClassCastException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (InstantiationException ex) {
                    // empty catch block
                }
                throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": invalid BoxedValueHelper for " + id, 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return null;
        }

        Serializable create(Header h) {
            StringHolder idH = new StringHolder();
            return this.create(h, idH);
        }

        Serializable create(Header h, StringHolder id) {
            Assert._OB_assert(h.tag >= 0x7FFFFF00 && h.tag != -1);
            ValueFactory factory = this.findFactory(h, id);
            if (factory != null) {
                return this.createWithFactory(h, factory);
            }
            BoxedValueHelper helper = null;
            if (h.ids.length > 0 && (helper = this.getBoxedHelper(h.ids[0])) != null) {
                id.value = h.ids[0];
            }
            if (helper == null && this.id_ != null && (helper = this.getBoxedHelper(this.id_)) != null) {
                id.value = this.id_;
            }
            if (helper != null) {
                Serializable result = helper.read_value(this.is_);
                this.reader_.addInstance(h.headerPos, result);
                return result;
            }
            String type = "<unknown>";
            if (h.ids.length > 0) {
                type = h.ids[0];
            } else if (this.id_ != null) {
                type = this.id_;
            }
            throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": " + type, 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static class ClassCreationStrategy
    extends CreationStrategy {
        private Class clz_;

        ClassCreationStrategy(ValueReader reader, InputStream is, Class clz) {
            super(reader, is);
            this.clz_ = clz;
        }

        Serializable create(Header h) {
            Assert._OB_assert(h.tag >= 0x7FFFFF00 && h.tag != -1);
            Serializable result = null;
            try {
                result = (Serializable)this.clz_.newInstance();
                this.reader_.addInstance(h.headerPos, result);
                try {
                    this.reader_.unmarshalValueState(result);
                }
                catch (SystemException ex) {
                    this.reader_.removeInstance(h.headerPos);
                    throw ex;
                }
                return result;
            }
            catch (ClassCastException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": " + this.clz_.getName(), 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static class BoxCreationStrategy
    extends CreationStrategy {
        private BoxedValueHelper helper_;

        BoxCreationStrategy(ValueReader reader, InputStream is, BoxedValueHelper helper) {
            super(reader, is);
            this.helper_ = helper;
        }

        Serializable create(Header h) {
            Assert._OB_assert(h.tag >= 0x7FFFFF00 && h.tag != -1);
            Serializable result = this.helper_.read_value(this.is_);
            if (result != null) {
                this.reader_.addInstance(h.headerPos, result);
                return result;
            }
            throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": " + this.helper_.get_id(), 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static abstract class CreationStrategy {
        protected ValueReader reader_;
        protected InputStream is_;

        CreationStrategy(ValueReader reader, InputStream is) {
            this.reader_ = reader;
            this.is_ = is;
        }

        abstract Serializable create(Header var1);
    }

    private static class Header {
        int tag;
        int headerPos;
        int dataPos;
        String[] ids = new String[0];
        ChunkState state = new ChunkState();
        Header next;

        Header() {
        }
    }

    private static class ChunkState {
        boolean chunked;
        int nestingLevel;
        int chunkStart;
        int chunkSize;

        ChunkState() {
        }

        ChunkState(ChunkState s) {
            this.copyFrom(s);
        }

        void copyFrom(ChunkState s) {
            this.chunked = s.chunked;
            this.nestingLevel = s.nestingLevel;
            this.chunkStart = s.chunkStart;
            this.chunkSize = s.chunkSize;
        }
    }
}

