/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.InterceptorPolicy_impl;
import com.ooc.OB.LocationForward;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ParameterDesc;
import com.ooc.OCI.ProfileInfo;
import com.ooc.PortableInterceptor.ClientRequestInfo_impl;
import com.ooc.PortableInterceptor.Current_impl;
import com.ooc.PortableInterceptor.ServerRequestInfo_impl;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.IORInterceptor_3_0Helper;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class PIManager {
    private ORB orb_;
    private ORBInstance orbInstance_;
    private int id_;
    private java.lang.Object idMut_ = new java.lang.Object();
    private Current_impl current_;
    private Vector clientReqInterceptors_ = new Vector();
    private Vector serverReqInterceptors_ = new Vector();
    private Vector iorInterceptors_ = new Vector();
    private int maxSlots_;
    private boolean complete_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextID() {
        java.lang.Object object = this.idMut_;
        synchronized (object) {
            return this.id_++;
        }
    }

    public PIManager(ORB orb) {
        this.orb_ = orb;
        this.id_ = 0;
        this.current_ = null;
        this.maxSlots_ = 0;
        this.complete_ = false;
    }

    void destroy() {
        Interceptor interceptor;
        Enumeration e = this.clientReqInterceptors_.elements();
        while (e.hasMoreElements()) {
            interceptor = (Interceptor)e.nextElement();
            try {
                interceptor.destroy();
            }
            catch (RuntimeException ex) {}
        }
        e = this.serverReqInterceptors_.elements();
        while (e.hasMoreElements()) {
            interceptor = (Interceptor)e.nextElement();
            try {
                interceptor.destroy();
            }
            catch (RuntimeException ex) {}
        }
        e = this.iorInterceptors_.elements();
        while (e.hasMoreElements()) {
            interceptor = (Interceptor)e.nextElement();
            try {
                interceptor.destroy();
            }
            catch (RuntimeException runtimeException) {}
        }
        this.orbInstance_ = null;
    }

    public void addIORInterceptor(IORInterceptor interceptor, boolean insertAtHead) throws DuplicateName {
        String name = interceptor.name();
        if (name.length() != 0) {
            Enumeration e = this.iorInterceptors_.elements();
            while (e.hasMoreElements()) {
                String curr = ((IORInterceptor)e.nextElement()).name();
                if (curr.length() == 0 || !curr.equals(name)) continue;
                throw new DuplicateName(name);
            }
        }
        if (insertAtHead) {
            this.iorInterceptors_.insertElementAt(interceptor, 0);
        } else {
            this.iorInterceptors_.addElement(interceptor);
        }
    }

    public void addClientRequestInterceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        String name = interceptor.name();
        if (name.length() != 0) {
            Enumeration e = this.clientReqInterceptors_.elements();
            while (e.hasMoreElements()) {
                String curr = ((ClientRequestInterceptor)e.nextElement()).name();
                if (curr.length() == 0 || !curr.equals(name)) continue;
                throw new DuplicateName(name);
            }
        }
        this.clientReqInterceptors_.addElement(interceptor);
    }

    public void addServerRequestInterceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        String name = interceptor.name();
        if (name.length() != 0) {
            Enumeration e = this.serverReqInterceptors_.elements();
            while (e.hasMoreElements()) {
                String curr = ((ServerRequestInterceptor)e.nextElement()).name();
                if (curr.length() == 0 || !curr.equals(name)) continue;
                throw new DuplicateName(name);
            }
        }
        this.serverReqInterceptors_.addElement(interceptor);
    }

    public int allocateSlotId() {
        return this.maxSlots_++;
    }

    public void registerPolicyFactory(int type, PolicyFactory factory) {
        Assert._OB_assert(this.orbInstance_ != null);
        this.orbInstance_.getPolicyFactoryManager().registerPolicyFactory(type, factory, false);
    }

    public void setORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        Assert._OB_assert(this.current_ == null);
        this.current_ = new Current_impl(this.orb_);
        InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
        try {
            ism.addInitialReference("PICurrent", this.current_);
        }
        catch (InvalidName ex) {
            Assert._OB_assert(false);
        }
    }

    public void setupComplete() {
        this.current_._OB_setMaxSlots(this.maxSlots_);
        if (this.clientReqInterceptors_.isEmpty()) {
            InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
            try {
                PolicyManager pm = PolicyManagerHelper.narrow(ism.resolveInitialReferences("ORBPolicyManager"));
                Policy[] pl = new Policy[]{new InterceptorPolicy_impl(false)};
                pm.set_policy_overrides(pl, SetOverrideType.ADD_OVERRIDE);
            }
            catch (InvalidName ex) {
                Assert._OB_assert(false);
            }
            catch (InvalidPolicies ex) {
                Assert._OB_assert(false);
            }
        }
        this.complete_ = true;
    }

    ClientRequestInfo clientSendRequest(String op, boolean responseExpected, IOR IOR2, IOR origIOR, ProfileInfo profileInfo, Policy[] policies, Vector requestSCL, Vector replySCL) throws LocationForward {
        Assert._OB_assert(this.current_ != null);
        ClientRequestInfo_impl info = new ClientRequestInfo_impl(this.orb_, this.nextID(), op, responseExpected, IOR2, origIOR, profileInfo, policies, requestSCL, replySCL, this.orbInstance_, this.current_);
        info._OB_request(this.clientReqInterceptors_);
        return info;
    }

    ClientRequestInfo clientSendRequest(String op, boolean responseExpected, IOR IOR2, IOR origIOR, ProfileInfo profileInfo, Policy[] policies, Vector requestSCL, Vector replySCL, NVList args, NamedValue result, ExceptionList exceptions) throws LocationForward {
        Assert._OB_assert(this.current_ != null);
        ClientRequestInfo_impl info = new ClientRequestInfo_impl(this.orb_, this.nextID(), op, responseExpected, IOR2, origIOR, profileInfo, policies, requestSCL, replySCL, this.orbInstance_, this.current_, args, result, exceptions);
        info._OB_request(this.clientReqInterceptors_);
        return info;
    }

    ClientRequestInfo clientSendRequest(String op, boolean responseExpected, IOR IOR2, IOR origIOR, ProfileInfo profileInfo, Policy[] policies, Vector requestSCL, Vector replySCL, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) throws LocationForward {
        Assert._OB_assert(this.current_ != null);
        ClientRequestInfo_impl info = new ClientRequestInfo_impl(this.orb_, this.nextID(), op, responseExpected, IOR2, origIOR, profileInfo, policies, requestSCL, replySCL, this.orbInstance_, this.current_, argDesc, retDesc, exceptionTC);
        info._OB_request(this.clientReqInterceptors_);
        return info;
    }

    void clientReceiveReply(ClientRequestInfo info) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)0);
        impl._OB_reply();
    }

    void clientReceiveException(ClientRequestInfo info, boolean wasSystem, Exception ex, String exId) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus(wasSystem ? (short)1 : 2);
        impl._OB_setReceivedException(ex, exId);
        impl._OB_reply();
    }

    void clientReceiveLocationForward(ClientRequestInfo info, IOR ior) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)3);
        impl._OB_setForwardReference(ior);
        impl._OB_reply();
    }

    ServerRequestInfo serverCreateRequestInfo(String op, boolean responseExpected, Policy[] policies, byte[] adapterId, byte[] objectId, ObjectReferenceTemplate adapterTemplate, Vector in, Vector out) throws LocationForward {
        Assert._OB_assert(this.current_ != null);
        return new ServerRequestInfo_impl(this.orb_, this.nextID(), op, responseExpected, policies, adapterId, objectId, adapterTemplate, in, out, this.orbInstance_, this.current_);
    }

    void serverSetupServant(ServerRequestInfo info, Servant servant, POA poa) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_servant(servant, poa);
    }

    void serverContextSwitch(ServerRequestInfo info) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_contextSwitch();
    }

    void serverParameterDesc(ServerRequestInfo info, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_parameterDesc(argDesc, retDesc, exceptionTC);
    }

    void serverArguments(ServerRequestInfo info, NVList args) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_arguments(args);
    }

    void serverResult(ServerRequestInfo info, Any result) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_result(result);
    }

    void serverReceiveRequestServiceContexts(ServerRequestInfo info) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_requestServiceContext(this.serverReqInterceptors_);
    }

    void serverReceiveRequest(ServerRequestInfo info) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_request();
    }

    void serverSendReply(ServerRequestInfo info) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)0);
        impl._OB_sendReply();
    }

    void serverSendLocationForward(ServerRequestInfo info, IOR ior) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)3);
        impl._OB_setForwardReference(ior);
        impl._OB_sendOther();
    }

    void serverSendException(ServerRequestInfo info, boolean wasSystem, Exception ex) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus(wasSystem ? (short)1 : 2);
        impl._OB_setReceivedException(ex, null);
        impl._OB_sendException();
    }

    public void establishComponents(IORInfo info) {
        Enumeration e = this.iorInterceptors_.elements();
        while (e.hasMoreElements()) {
            try {
                ((IORInterceptor)e.nextElement()).establish_components(info);
            }
            catch (SystemException systemException) {}
        }
    }

    public void componentsEstablished(IORInfo info) {
        Enumeration e = this.iorInterceptors_.elements();
        while (e.hasMoreElements()) {
            try {
                IORInterceptor_3_0 ir = IORInterceptor_3_0Helper.narrow((Object)e.nextElement());
                if (ir == null) continue;
                ir.components_established(info);
            }
            catch (BAD_PARAM bAD_PARAM) {}
        }
    }

    public void adapterStateChange(ObjectReferenceTemplate[] templates, short state) {
        Enumeration e = this.iorInterceptors_.elements();
        while (e.hasMoreElements()) {
            try {
                IORInterceptor_3_0 ir = IORInterceptor_3_0Helper.narrow((Object)e.nextElement());
                if (ir == null) continue;
                ir.adapter_state_change(templates, state);
            }
            catch (SystemException ex) {}
        }
    }

    public void adapterManagerStateChange(int id, short state) {
        Enumeration e = this.iorInterceptors_.elements();
        while (e.hasMoreElements()) {
            try {
                IORInterceptor_3_0 ir = IORInterceptor_3_0Helper.narrow((Object)e.nextElement());
                if (ir == null) continue;
                ir.adapter_manager_state_change(id, state);
            }
            catch (SystemException ex) {}
        }
    }

    public boolean haveClientInterceptors() {
        return this.complete_ && !this.clientReqInterceptors_.isEmpty();
    }

    public boolean haveServerInterceptors() {
        return this.complete_ && !this.serverReqInterceptors_.isEmpty();
    }
}

