/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.OutputStreamHolder;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.FailureException;
import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OCI.ProfileInfo;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

public class Downcall {
    protected ORBInstance orbInstance_;
    protected Client client_;
    protected DowncallEmitter emitter_;
    protected ProfileInfo profileInfo_;
    protected RefCountPolicyList policies_;
    protected int reqId_;
    protected String op_;
    protected boolean responseExpected_;
    protected OutputStream out_;
    protected InputStream in_;
    protected static final int DowncallStateUnsent = 0;
    protected static final int DowncallStatePending = 1;
    protected static final int DowncallStateNoException = 2;
    protected static final int DowncallStateUserException = 3;
    protected static final int DowncallStateSystemException = 4;
    protected static final int DowncallStateFailureException = 5;
    protected static final int DowncallStateForward = 6;
    protected static final int DowncallStateForwardPerm = 7;
    protected int state_;
    protected Object stateMonitor_;
    protected Exception ex_;
    protected String exId_;
    protected IOR forwardIOR_;
    protected Vector requestSCL_ = new Vector();
    protected Vector replySCL_ = new Vector();

    void checkForException() throws LocationForward, FailureException {
        switch (this.state_) {
            case 3: {
                break;
            }
            case 4: {
                Assert._OB_assert(this.ex_ != null);
                throw (SystemException)this.ex_;
            }
            case 5: {
                Assert._OB_assert(this.ex_ != null);
                throw new FailureException((SystemException)this.ex_);
            }
            case 6: {
                Assert._OB_assert(this.forwardIOR_ != null);
                throw new LocationForward(this.forwardIOR_, false);
            }
            case 7: {
                Assert._OB_assert(this.forwardIOR_ != null);
                throw new LocationForward(this.forwardIOR_, true);
            }
        }
    }

    protected final OutputStream preMarshalBase() throws LocationForward, FailureException {
        OutputStreamHolder out = new OutputStreamHolder();
        this.emitter_ = this.client_.startDowncall(this, out);
        this.out_ = out.value;
        this.checkForException();
        return this.out_;
    }

    public Downcall(ORBInstance orbInstance, Client client, ProfileInfo profileInfo, RefCountPolicyList policies, String op, boolean resp) {
        this.orbInstance_ = orbInstance;
        this.client_ = client;
        this.profileInfo_ = profileInfo;
        this.policies_ = policies;
        this.op_ = op;
        this.responseExpected_ = resp;
        this.state_ = 0;
        this.stateMonitor_ = null;
        this.ex_ = null;
        this.reqId_ = this.client_.requestId();
    }

    public ORBInstance orbInstance() {
        return this.orbInstance_;
    }

    public Client client() {
        return this.client_;
    }

    public ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    public RefCountPolicyList policies() {
        return this.policies_;
    }

    public int requestId() {
        return this.reqId_;
    }

    public String operation() {
        return this.op_;
    }

    public boolean responseExpected() {
        return this.responseExpected_;
    }

    public OutputStream output() {
        return this.out_;
    }

    public InputStream input() {
        return this.in_;
    }

    public ServiceContext[] getRequestSCL() {
        Object[] scl = new ServiceContext[this.requestSCL_.size()];
        this.requestSCL_.copyInto(scl);
        return scl;
    }

    public void addToRequestSCL(ServiceContext sc) {
        this.requestSCL_.addElement(sc);
    }

    public void setReplySCL(ServiceContext[] scl) {
        Assert._OB_assert(this.replySCL_.size() == 0);
        this.replySCL_.setSize(scl.length);
        for (int i = 0; i < scl.length; ++i) {
            this.replySCL_.setElementAt(scl[i], i);
        }
    }

    public OutputStream preMarshal() throws LocationForward, FailureException {
        return this.preMarshalBase();
    }

    public void marshalEx(SystemException ex) throws LocationForward, FailureException {
        this.setFailureException(ex);
        this.checkForException();
        Assert._OB_assert(false);
    }

    public void postMarshal() throws LocationForward, FailureException {
    }

    public void locate() throws LocationForward, FailureException {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.op_.equals("_locate"));
        boolean finished = this.emitter_.sendReceive(this);
        Assert._OB_assert(finished);
        this.checkForException();
    }

    public void request() throws LocationForward, FailureException {
        Assert._OB_assert(this.responseExpected_);
        boolean finished = this.emitter_.sendReceive(this);
        Assert._OB_assert(finished);
        this.checkForException();
    }

    public void oneway() throws LocationForward, FailureException {
        Assert._OB_assert(!this.responseExpected_);
        if (this.policies_.syncScope == 1) {
            boolean finished = this.emitter_.send(this, true);
            Assert._OB_assert(finished);
            this.checkForException();
        } else {
            boolean finished = this.emitter_.send(this, false);
            if (finished) {
                this.checkForException();
            }
        }
    }

    public void deferred() throws LocationForward, FailureException {
        Assert._OB_assert(this.responseExpected_);
        boolean finished = this.emitter_.send(this, true);
        if (finished) {
            this.checkForException();
        }
    }

    public void response() throws LocationForward, FailureException {
        Assert._OB_assert(this.responseExpected_);
        boolean finished = this.emitter_.receive(this, true);
        Assert._OB_assert(finished);
        this.checkForException();
    }

    public boolean poll() throws LocationForward, FailureException {
        Assert._OB_assert(this.responseExpected_);
        boolean finished = this.emitter_.receive(this, false);
        if (finished) {
            this.checkForException();
            return this.state_ != 1;
        }
        return false;
    }

    public InputStream preUnmarshal() throws LocationForward, FailureException {
        return this.in_;
    }

    public void unmarshalEx(SystemException ex) throws LocationForward, FailureException {
        this.setFailureException(ex);
        this.checkForException();
        Assert._OB_assert(false);
    }

    public void postUnmarshal() throws LocationForward, FailureException {
        if (this.state_ == 3 && this.ex_ == null && this.exId_ == null) {
            this.setSystemException(new UNKNOWN(MinorCodes.describeUnknown(1330446337), 1330446337, CompletionStatus.COMPLETED_YES));
        }
        this.checkForException();
    }

    public String unmarshalExceptionId() {
        Assert._OB_assert(this.state_ == 3);
        int pos = this.in_._OB_pos();
        String id = this.in_.read_string();
        this.in_._OB_pos(pos);
        return id;
    }

    public boolean unsent() {
        return this.state_ == 0;
    }

    public boolean pending() {
        return this.state_ == 1;
    }

    public boolean noException() {
        return this.state_ == 2;
    }

    public boolean userException() {
        return this.state_ == 3;
    }

    public boolean failureException() {
        return this.state_ == 5;
    }

    private void setPendingImpl() {
        Assert._OB_assert(this.responseExpected_);
        this.state_ = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPending() {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setPendingImpl();
                this.stateMonitor_.notify();
            }
        } else {
            this.setPendingImpl();
        }
    }

    private void setNoExceptionImpl(InputStream in) {
        this.state_ = 2;
        if (in == null) {
            Assert._OB_assert(!this.responseExpected_);
        } else {
            Assert._OB_assert(this.responseExpected_);
            this.in_ = in;
            this.in_._OB_ORBInstance(this.orbInstance_);
            CodeConverters codeConverters = this.client_.codeConverters();
            this.in_._OB_codeConverters(codeConverters, this.profileInfo_.major << 8 | this.profileInfo_.minor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoException(InputStream in) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setNoExceptionImpl(in);
                this.stateMonitor_.notify();
            }
        } else {
            this.setNoExceptionImpl(in);
        }
    }

    private void setUserExceptionImpl(InputStream in) {
        Assert._OB_assert(in != null);
        Assert._OB_assert(this.responseExpected_);
        this.state_ = 3;
        this.in_ = in;
        this.in_._OB_ORBInstance(this.orbInstance_);
        CodeConverters codeConverters = this.client_.codeConverters();
        this.in_._OB_codeConverters(codeConverters, this.profileInfo_.major << 8 | this.profileInfo_.minor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserException(InputStream in) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(in);
                this.stateMonitor_.notify();
            }
        } else {
            this.setUserExceptionImpl(in);
        }
    }

    private void setUserExceptionImpl(UserException ex, String exId) {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.ex_ == null);
        this.state_ = 3;
        this.ex_ = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserException(UserException ex, String exId) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(ex, exId);
                this.stateMonitor_.notify();
            }
        } else {
            this.setUserExceptionImpl(ex, exId);
        }
    }

    private void setUserExceptionImpl(UserException ex) {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.ex_ == null);
        this.state_ = 3;
        this.ex_ = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserException(UserException ex) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(ex);
                this.stateMonitor_.notify();
            }
        } else {
            this.setUserExceptionImpl(ex);
        }
    }

    private void setUserExceptionImpl(String exId) {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.ex_ == null);
        this.state_ = 3;
        this.exId_ = exId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserException(String exId) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(exId);
                this.stateMonitor_.notify();
            }
        } else {
            this.setUserExceptionImpl(exId);
        }
    }

    private void setSystemExceptionImpl(SystemException ex) {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.ex_ == null);
        this.state_ = 4;
        this.ex_ = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemException(SystemException ex) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setSystemExceptionImpl(ex);
                this.stateMonitor_.notify();
            }
        } else {
            this.setSystemExceptionImpl(ex);
        }
    }

    private void setFailureExceptionImpl(SystemException ex) {
        Assert._OB_assert(this.ex_ == null);
        this.state_ = 5;
        this.ex_ = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailureException(SystemException ex) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setFailureExceptionImpl(ex);
                this.stateMonitor_.notify();
            }
        } else {
            this.setFailureExceptionImpl(ex);
        }
    }

    private void setLocationForwardImpl(IOR ior, boolean perm) {
        Assert._OB_assert(this.responseExpected_);
        Assert._OB_assert(this.forwardIOR_ == null);
        this.state_ = perm ? 7 : 6;
        this.forwardIOR_ = ior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationForward(IOR ior, boolean perm) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setLocationForwardImpl(ior, perm);
                this.stateMonitor_.notify();
            }
        } else {
            this.setLocationForwardImpl(ior, perm);
        }
    }

    public void initStateMonitor() {
        Assert._OB_assert(this.stateMonitor_ == null);
        this.stateMonitor_ = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitUntilCompleted(boolean block) {
        int t = this.policies_.requestTimeout;
        if (!block || block && t == 0) {
            Thread.yield();
        }
        Assert._OB_assert(this.stateMonitor_ != null);
        Object object = this.stateMonitor_;
        synchronized (object) {
            while (this.state_ == 0 || this.state_ == 1) {
                if (!block) {
                    return false;
                }
                try {
                    if (t < 0) {
                        this.stateMonitor_.wait();
                        continue;
                    }
                    int oldState = this.state_;
                    this.stateMonitor_.wait(t);
                    if (this.state_ != oldState) continue;
                    throw new NO_RESPONSE("Timeout during receive", 0, CompletionStatus.COMPLETED_MAYBE);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
            return true;
        }
    }
}

