/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.Downcall;
import com.ooc.OB.LocationForward;
import com.ooc.OB.OAInterface;
import com.ooc.OB.Server;
import com.ooc.OB.Upcall;
import com.ooc.OB.UpcallReturn;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;

public final class CollocatedServer
extends Server
implements UpcallReturn {
    private int nextRequestId_ = 0;
    private Object nextRequestIdMutex_ = new Object();
    private Hashtable callMap_ = new Hashtable(13);
    private boolean destroy_ = false;
    private boolean hold_ = true;
    private OAInterface oaInterface_;

    public CollocatedServer(OAInterface oaInterface, int concModel) {
        super(concModel);
        this.oaInterface_ = oaInterface;
    }

    public synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration e = this.callMap_.keys();
        while (e.hasMoreElements()) {
            Downcall down = (Downcall)this.callMap_.get(e.nextElement());
            Assert._OB_assert(down != null);
            Assert._OB_assert(down.pending());
            down.setFailureException(new INITIALIZE("ORB has been destroyed", 1330577409, CompletionStatus.COMPLETED_NO));
        }
        this.callMap_.clear();
        this.notifyAll();
    }

    public synchronized void hold() {
        Assert._OB_assert(!this.destroy_);
        this.hold_ = true;
        this.notifyAll();
    }

    public synchronized void activate() {
        Assert._OB_assert(!this.destroy_);
        this.hold_ = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Downcall down, boolean b) {
        Upcall up;
        down.initStateMonitor();
        CollocatedServer collocatedServer = this;
        synchronized (collocatedServer) {
            while (this.hold_ && !this.destroy_) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.destroy_) {
                down.setFailureException(new TRANSIENT("Collocated server has already been destroyed", 0, CompletionStatus.COMPLETED_NO));
                return true;
            }
            ProfileInfo profileInfo = down.profileInfo();
            int reqId = down.requestId();
            String op = down.operation();
            OutputStream out = down.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            ServiceContext[] requestSCL = down.getRequestSCL();
            if (op.charAt(0) == '_' && op.equals("_locate")) {
                IORHolder ior = new IORHolder();
                switch (this.oaInterface_.findByKey(profileInfo.key, ior)) {
                    case 0: {
                        down.setSystemException(new OBJECT_NOT_EXIST());
                        break;
                    }
                    case 1: {
                        InputStream in = new InputStream(buf, 0, false);
                        down.setNoException(in);
                        break;
                    }
                    case 2: {
                        down.setLocationForward(ior.value, false);
                        break;
                    }
                    case 3: {
                        down.setLocationForward(ior.value, true);
                        break;
                    }
                    default: {
                        Assert._OB_assert(false);
                    }
                }
                return true;
            }
            if (down.responseExpected()) {
                this.callMap_.put(new Integer(reqId), down);
                down.setPending();
                up = this.oaInterface_.createUpcall(this, profileInfo, null, reqId, op, new InputStream(buf, 0, false), requestSCL);
            } else {
                down.setNoException(null);
                up = this.oaInterface_.createUpcall(null, profileInfo, null, reqId, op, new InputStream(buf, 0, false), requestSCL);
            }
        }
        up.invoke();
        return !down.responseExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(Downcall down, boolean block) {
        try {
            return down.waitUntilCompleted(block);
        }
        catch (SystemException ex) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                this.callMap_.remove(new Integer(down.requestId()));
                down.setFailureException(ex);
                return true;
            }
        }
    }

    public boolean sendReceive(Downcall down) {
        this.send(down, true);
        return this.receive(down, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            return this.nextRequestId_++;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        return this.oaInterface_.getUsableProfiles(ior, policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upcallBeginReply(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(0);
        if (replySCL.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (down != null) {
                    down.setReplySCL(replySCL);
                }
            }
        }
    }

    public synchronized void upcallEndReply(Upcall upcall) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            OutputStream out = upcall.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            InputStream in = new InputStream(buf, 0, false);
            down.setNoException(in);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upcallBeginUserException(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(0);
        if (replySCL.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (down != null) {
                    down.setReplySCL(replySCL);
                }
            }
        }
    }

    public synchronized void upcallEndUserException(Upcall upcall) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            OutputStream out = upcall.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            InputStream in = new InputStream(buf, 0, false);
            down.setUserException(in);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    public void upcallUserException(Upcall upcall, UserException ex, ServiceContext[] replySCL) {
        this.upcallBeginUserException(upcall, replySCL);
        OutputStream out = upcall.output();
        try {
            Assert._OB_assert(false);
        }
        catch (SystemException e) {
            try {
                upcall.marshalEx(e);
            }
            catch (LocationForward f) {
                Assert._OB_assert(false);
            }
        }
        this.upcallEndUserException(upcall);
    }

    public synchronized void upcallSystemException(Upcall upcall, SystemException ex, ServiceContext[] replySCL) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            if (replySCL.length > 0) {
                down.setReplySCL(replySCL);
            }
            down.setSystemException(ex);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    public synchronized void upcallForward(Upcall upcall, IOR ior, boolean perm, ServiceContext[] replySCL) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            if (replySCL.length > 0) {
                down.setReplySCL(replySCL);
            }
            down.setLocationForward(ior, perm);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }
}

