/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CORBA;

import com.ooc.CORBA.Context;
import com.ooc.CORBA.Delegate;
import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.TypeCode;
import com.ooc.OB.Assert;
import com.ooc.OB.CodeConverterBase;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.TypeCodeFactory;
import com.ooc.OB.ValueWriter;
import com.ooc.OCI.Buffer;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.ValueBaseHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public final class OutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    private ORBInstance orbInstance_;
    public Buffer buf_;
    private CodeConverters codeConverters_;
    private int GIOPVersion_ = 256;
    private boolean charConversionRequired_;
    private boolean wCharConversionRequired_;
    private boolean charWriterRequired_;
    private boolean charWriterOrConversionRequired_;
    private ValueWriter valueWriter_;
    private int alignNext_;
    private java.lang.Object invocationContext_;
    private java.lang.Object delegateContext_;

    private int writeGap() {
        this.addCapacity(4, 4);
        int result = this.buf_.pos_;
        this.buf_.pos_ += 4;
        return result;
    }

    private void writeLength(int start) {
        int length = this.buf_.pos_ - (start + 4);
        this.buf_.data_[start++] = (byte)(length >>> 24);
        this.buf_.data_[start++] = (byte)(length >>> 16);
        this.buf_.data_[start++] = (byte)(length >>> 8);
        this.buf_.data_[start] = (byte)length;
    }

    public void writeTypeCodeImpl(org.omg.CORBA.TypeCode tc, Hashtable history) {
        TypeCode obTC = null;
        try {
            obTC = (TypeCode)tc;
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        if (obTC != null && obTC.recId_ != null) {
            if (obTC.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode(1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            this.writeTypeCodeImpl(obTC.recType_, history);
            return;
        }
        switch (tc.kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.write_ulong(tc.kind().value());
                return;
            }
        }
        Integer indirectionPos = (Integer)history.get(tc);
        if (indirectionPos != null) {
            this.write_long(-1);
            int offs = indirectionPos - this.buf_.pos_;
            this.write_long(offs);
        } else {
            this.write_ulong(tc.kind().value());
            Integer oldPos = new Integer(this.buf_.pos_ - 4);
            try {
                switch (tc.kind().value()) {
                    case 28: {
                        history.put(tc, oldPos);
                        this.write_ushort(tc.fixed_digits());
                        this.write_short(tc.fixed_scale());
                        break;
                    }
                    case 14: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeLength(start);
                        break;
                    }
                    case 15: 
                    case 22: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.write_ulong(tc.member_count());
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_string(tc.member_name(i));
                            this.writeTypeCodeImpl(tc.member_type(i), history);
                        }
                        this.writeLength(start);
                        break;
                    }
                    case 16: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        org.omg.CORBA.TypeCode discType = tc.discriminator_type();
                        this.writeTypeCodeImpl(discType, history);
                        int defaultIndex = tc.default_index();
                        this.write_long(defaultIndex);
                        this.write_ulong(tc.member_count());
                        for (int i = 0; i < tc.member_count(); ++i) {
                            if (i == defaultIndex) {
                                org.omg.CORBA.TypeCode origDiscType = TypeCode._OB_getOrigType(discType);
                                switch (origDiscType.kind().value()) {
                                    case 2: {
                                        this.write_short((short)0);
                                        break;
                                    }
                                    case 4: {
                                        this.write_ushort((short)0);
                                        break;
                                    }
                                    case 3: {
                                        this.write_long(0);
                                        break;
                                    }
                                    case 5: {
                                        this.write_ulong(0);
                                        break;
                                    }
                                    case 23: {
                                        this.write_longlong(0L);
                                        break;
                                    }
                                    case 24: {
                                        this.write_ulonglong(0L);
                                        break;
                                    }
                                    case 8: {
                                        this.write_boolean(false);
                                        break;
                                    }
                                    case 9: {
                                        this.write_char('\u0000');
                                        break;
                                    }
                                    case 17: {
                                        this.write_ulong(0);
                                        break;
                                    }
                                    default: {
                                        Assert._OB_assert(false);
                                        break;
                                    }
                                }
                            } else {
                                tc.member_label(i).write_value(this);
                            }
                            this.write_string(tc.member_name(i));
                            this.writeTypeCodeImpl(tc.member_type(i), history);
                        }
                        this.writeLength(start);
                        break;
                    }
                    case 17: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.write_ulong(tc.member_count());
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_string(tc.member_name(i));
                        }
                        this.writeLength(start);
                        break;
                    }
                    case 18: 
                    case 27: {
                        this.write_ulong(tc.length());
                        break;
                    }
                    case 19: 
                    case 20: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.writeTypeCodeImpl(tc.content_type(), history);
                        this.write_ulong(tc.length());
                        this.writeLength(start);
                        break;
                    }
                    case 21: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeTypeCodeImpl(tc.content_type(), history);
                        this.writeLength(start);
                        break;
                    }
                    case 29: {
                        history.put(tc, oldPos);
                        org.omg.CORBA.TypeCode concreteBase = tc.concrete_base_type();
                        if (concreteBase == null) {
                            concreteBase = TypeCodeFactory.createPrimitiveTC(TCKind.tk_null);
                        }
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.write_short(tc.type_modifier());
                        this.writeTypeCodeImpl(concreteBase, history);
                        this.write_ulong(tc.member_count());
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_string(tc.member_name(i));
                            this.writeTypeCodeImpl(tc.member_type(i), history);
                            this.write_short(tc.member_visibility(i));
                        }
                        this.writeLength(start);
                        break;
                    }
                    case 30: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeTypeCodeImpl(tc.content_type(), history);
                        this.writeLength(start);
                        break;
                    }
                    case 32: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeLength(start);
                        break;
                    }
                    case 31: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeLength(start);
                        break;
                    }
                    case 33: {
                        history.put(tc, oldPos);
                        int start = this.writeGap();
                        this._OB_writeEndian();
                        this.write_string(tc.id());
                        this.write_string(tc.name());
                        this.writeLength(start);
                        break;
                    }
                    default: {
                        Assert._OB_assert(false);
                        break;
                    }
                }
            }
            catch (BadKind ex) {
                Assert._OB_assert(false);
            }
            catch (Bounds ex) {
                Assert._OB_assert(false);
            }
        }
    }

    private void checkBeginChunk() {
        Assert._OB_assert(this.valueWriter_ != null);
        this.valueWriter_.checkBeginChunk();
    }

    private ValueWriter valueWriter() {
        if (this.valueWriter_ == null) {
            this.valueWriter_ = new ValueWriter(this);
        }
        return this.valueWriter_;
    }

    private void addCapacity(int size) {
        if (this.alignNext_ > 0) {
            int align = this.alignNext_;
            this.alignNext_ = 0;
            this.addCapacity(size, align);
        } else {
            int len;
            if (this.buf_.pos_ == this.buf_.len_ && this.valueWriter_ != null) {
                this.checkBeginChunk();
            }
            if ((len = this.buf_.pos_ + size) > this.buf_.len_) {
                this.buf_.realloc(len);
            }
        }
    }

    private void addCapacity(int size, int align) {
        Assert._OB_assert(align > 0);
        if (this.buf_.pos_ == this.buf_.len_ && this.valueWriter_ != null) {
            this.checkBeginChunk();
        }
        if (this.alignNext_ > 0) {
            align = this.alignNext_ > align ? this.alignNext_ : align;
            this.alignNext_ = 0;
        }
        int newPos = this.buf_.pos_ + align - 1;
        newPos -= newPos % align;
        this.buf_.pos_ = newPos;
        int len = newPos + size;
        if (len > this.buf_.len_) {
            this.buf_.realloc(len);
        }
    }

    public void write(int b) throws IOException {
        this.write_long(b);
    }

    public ORB orb() {
        if (this.orbInstance_ != null) {
            return this.orbInstance_.getORB();
        }
        return null;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        Buffer buf = new Buffer(this.buf_.len_);
        if (this.buf_.len_ > 0) {
            System.arraycopy(this.buf_.data_, 0, buf.data_, 0, this.buf_.len_);
        }
        InputStream in = new InputStream(buf, 0, false, this.codeConverters_, this.GIOPVersion_);
        in._OB_ORBInstance(this.orbInstance_);
        return in;
    }

    public void write_boolean(boolean value) {
        this.addCapacity(1);
        this.buf_.data_[this.buf_.pos_++] = value ? (byte)1 : 0;
    }

    public void write_char(char value) {
        if (value > '\u00ff') {
            throw new DATA_CONVERSION("char value exceeds 255: " + value);
        }
        this.addCapacity(1);
        if (this.charWriterOrConversionRequired_) {
            CodeConverterBase converter = this.codeConverters_.outputCharConverter;
            if (this.charWriterRequired_ && this.charConversionRequired_) {
                converter.write_char(this, converter.convert(value));
            } else if (this.charWriterRequired_) {
                converter.write_char(this, value);
            } else {
                this.buf_.data_[this.buf_.pos_++] = (byte)converter.convert(value);
            }
        } else {
            this.buf_.data_[this.buf_.pos_++] = (byte)value;
        }
    }

    public void write_wchar(char value) {
        if (this.wCharConversionRequired_) {
            CodeConverterBase converter = this.codeConverters_.outputWcharConverter;
            value = converter.convert(value);
            switch (this.GIOPVersion_) {
                case 257: {
                    if (converter.getTo().max_bytes <= 2) {
                        this.write_ushort((short)value);
                        break;
                    }
                    this.write_ulong(value);
                    break;
                }
                default: {
                    int length = converter.count_wchar(value);
                    this.write_octet((byte)length);
                    this.addCapacity(length);
                    converter.write_wchar(this, value);
                    break;
                }
            }
        } else {
            switch (this.GIOPVersion_) {
                case 256: 
                case 257: {
                    this.write_ushort((short)value);
                    break;
                }
                default: {
                    this.addCapacity(3);
                    this.buf_.data_[this.buf_.pos_++] = 2;
                    this.buf_.data_[this.buf_.pos_++] = (byte)(value >> 8);
                    this.buf_.data_[this.buf_.pos_++] = (byte)value;
                }
            }
        }
    }

    public void write_octet(byte value) {
        this.addCapacity(1);
        this.buf_.data_[this.buf_.pos_++] = value;
    }

    public void write_short(short value) {
        this.addCapacity(2, 2);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)value;
    }

    public void write_ushort(short value) {
        this.write_short(value);
    }

    public void write_long(int value) {
        this.addCapacity(4, 4);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 24);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 16);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)value;
    }

    public void write_ulong(int value) {
        this.write_long(value);
    }

    public void write_longlong(long value) {
        this.addCapacity(8, 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 56);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 48);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 40);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 32);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 24);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 16);
        this.buf_.data_[this.buf_.pos_++] = (byte)(value >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)value;
    }

    public void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public void write_string(String value) {
        char[] arr = value.toCharArray();
        int len = arr.length;
        int capacity = len + 1;
        this.write_ulong(capacity);
        this.addCapacity(capacity);
        if (!this.charWriterOrConversionRequired_) {
            for (int i = 0; i < len; ++i) {
                char c = arr[i];
                if (c == '\u0000' || c > '\u00ff') {
                    throw new DATA_CONVERSION("illegal char value for string: " + c);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)c;
            }
        } else {
            CodeConverterBase converter = this.codeConverters_.outputCharConverter;
            boolean bothRequired = this.charWriterRequired_ && this.charConversionRequired_;
            for (int i = 0; i < len; ++i) {
                char c = arr[i];
                if (c == '\u0000' || c > '\u00ff') {
                    throw new DATA_CONVERSION("illegal char value for string: " + c);
                }
                if (bothRequired) {
                    converter.write_char(this, converter.convert(c));
                }
                if (this.charWriterRequired_) {
                    converter.write_char(this, c);
                    continue;
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)converter.convert(c);
            }
        }
        this.buf_.data_[this.buf_.pos_++] = 0;
    }

    public void write_wstring(String value) {
        char[] arr = value.toCharArray();
        int len = arr.length;
        switch (this.GIOPVersion_) {
            case 256: 
            case 257: {
                this.write_ulong(len + 1);
                this.write_wchar_array(arr, 0, len);
                this.write_wchar('\u0000');
                break;
            }
            default: {
                int start = this.writeGap();
                if (this.wCharConversionRequired_) {
                    CodeConverterBase converter = this.codeConverters_.outputWcharConverter;
                    for (int i = 0; i < len; ++i) {
                        char v = converter.convert(arr[i]);
                        if (v == '\u0000') {
                            throw new DATA_CONVERSION("illegal wchar value for wstring: " + v);
                        }
                        this.addCapacity(converter.count_wchar(v));
                        converter.write_wchar(this, v);
                    }
                } else {
                    this.addCapacity(2 * len);
                    for (int i = 0; i < len; ++i) {
                        char v = arr[i];
                        if (v == '\u0000') {
                            throw new DATA_CONVERSION("illegal wchar value for wstring: " + v);
                        }
                        this.buf_.data_[this.buf_.pos_++] = (byte)(v >> 8);
                        this.buf_.data_[this.buf_.pos_++] = (byte)v;
                    }
                }
                this.writeLength(start);
                break;
            }
        }
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length);
            for (int i = offset; i < offset + length; ++i) {
                this.buf_.data_[this.buf_.pos_++] = value[i] ? (byte)1 : 0;
            }
        }
    }

    public void write_char_array(char[] value, int offset, int length) {
        block8: {
            if (length <= 0) break block8;
            this.addCapacity(length);
            if (!this.charWriterOrConversionRequired_) {
                for (int i = offset; i < offset + length; ++i) {
                    if (value[i] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + value[i]);
                    }
                    this.buf_.data_[this.buf_.pos_++] = (byte)value[i];
                }
            } else {
                CodeConverterBase converter = this.codeConverters_.outputCharConverter;
                boolean bothRequired = this.charWriterRequired_ && this.charConversionRequired_;
                for (int i = offset; i < offset + length; ++i) {
                    if (value[i] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + value[i]);
                    }
                    if (bothRequired) {
                        converter.write_char(this, converter.convert(value[i]));
                        continue;
                    }
                    if (this.charWriterRequired_) {
                        converter.write_char(this, value[i]);
                        continue;
                    }
                    this.buf_.data_[this.buf_.pos_++] = (byte)converter.convert(value[i]);
                }
            }
        }
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.write_wchar(value[i]);
        }
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length);
            System.arraycopy(value, offset, this.buf_.data_, this.buf_.pos_, length);
            this.buf_.pos_ += length;
        }
    }

    public void write_short_array(short[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 2, 2);
            for (int i = offset; i < offset + length; ++i) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)value[i];
            }
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public void write_long_array(int[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 4, 4);
            for (int i = offset; i < offset + length; ++i) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)value[i];
            }
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 8, 8);
            for (int i = offset; i < offset + length; ++i) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 56);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 48);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 40);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 32);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(value[i] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)value[i];
            }
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public void write_float_array(float[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 4, 4);
            for (int i = offset; i < offset + length; ++i) {
                int v = Float.floatToIntBits(value[i]);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)v;
            }
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 8, 8);
            for (int i = offset; i < offset + length; ++i) {
                long v = Double.doubleToLongBits(value[i]);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 56);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 48);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 40);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 32);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(v >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)v;
            }
        }
    }

    public void write_Object(Object value) {
        if (value == null) {
            IOR ior = new IOR();
            ior.type_id = "";
            ior.profiles = new TaggedProfile[0];
            IORHelper.write(this, ior);
        } else {
            if (value instanceof LocalObject) {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            Delegate p = (Delegate)((ObjectImpl)value)._get_delegate();
            p._OB_marshalOrigIOR(this);
        }
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode t) {
        if (t == null) {
            throw new BAD_TYPECODE("TypeCode is nil");
        }
        Hashtable history = new Hashtable(11);
        this.writeTypeCodeImpl(t, history);
    }

    public void write_any(Any value) {
        this.write_TypeCode(value.type());
        value.write_value(this);
    }

    public void write_Context(org.omg.CORBA.Context ctx, ContextList contexts) {
        int count = contexts.count();
        Vector v = new Vector();
        Context ctxImpl = (Context)ctx;
        for (int i = 0; i < count; ++i) {
            try {
                String pattern = contexts.item(i);
                ctxImpl._OB_getValues("", 0, pattern, v);
                continue;
            }
            catch (org.omg.CORBA.Bounds ex) {
                Assert._OB_assert(false);
            }
        }
        this.write_ulong(v.size());
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.write_string((String)e.nextElement());
        }
    }

    public void write_Principal(Principal value) {
        throw new NO_IMPLEMENT();
    }

    public void write_fixed(BigDecimal value) {
        String v = value.abs().toString();
        v = value.signum() == -1 ? v + '=' : v + '<';
        String s = "";
        if (v.length() % 2 != 0) {
            s = "0";
        }
        s = s + v;
        int len = s.length();
        for (int i = 0; i < len - 1; i += 2) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            this.write_octet((byte)(c1 - 48 << 4 | c2 - 48));
        }
    }

    public void write_value(Serializable value) {
        this.valueWriter().writeValue(value, null);
    }

    public void write_value(Serializable value, String rep_id) {
        this.valueWriter().writeValue(value, rep_id);
    }

    public void write_value(Serializable value, Class clz) {
        this.valueWriter().writeValue(value, null);
    }

    public void write_value(Serializable value, BoxedValueHelper helper) {
        this.valueWriter().writeValueBox(value, null, helper);
    }

    public void write_abstract_interface(java.lang.Object obj) {
        this.valueWriter().writeAbstractInterface(obj);
    }

    public void write_value(Serializable value, org.omg.CORBA.TypeCode tc, BoxedValueHelper helper) {
        this.valueWriter().writeValueBox(value, tc, helper);
    }

    public void write_InputStream(org.omg.CORBA.portable.InputStream in, org.omg.CORBA.TypeCode tc) {
        block83: {
            InputStream obin = null;
            try {
                obin = (InputStream)in;
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            try {
                block2 : switch (tc.kind().value()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.write_short(in.read_short());
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 17: {
                        this.write_long(in.read_long());
                        break;
                    }
                    case 7: 
                    case 23: 
                    case 24: {
                        this.write_longlong(in.read_longlong());
                        break;
                    }
                    case 8: 
                    case 10: {
                        this.write_octet(in.read_octet());
                        break;
                    }
                    case 9: {
                        this.write_char(in.read_char());
                        break;
                    }
                    case 26: {
                        this.write_wchar(in.read_wchar());
                        break;
                    }
                    case 28: {
                        this.write_fixed(in.read_fixed());
                        break;
                    }
                    case 11: {
                        org.omg.CORBA.TypeCode p = in.read_TypeCode();
                        this.write_TypeCode(p);
                        this.write_InputStream(in, p);
                        break;
                    }
                    case 12: {
                        int kind = in.read_ulong();
                        if (kind == -1) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1330577446), 1330577446, CompletionStatus.COMPLETED_NO);
                        }
                        this.write_ulong(kind);
                        switch (kind) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: {
                                break block2;
                            }
                            case 28: {
                                this.write_ushort(in.read_ushort());
                                this.write_short(in.read_short());
                                break block2;
                            }
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: {
                                int len = in.read_ulong();
                                this.write_ulong(len);
                                this.addCapacity(len);
                                in.read_octet_array(this.buf_.data_, this.buf_.pos_, len);
                                this.buf_.pos_ += len;
                                break block2;
                            }
                            case 18: 
                            case 27: {
                                int bound = in.read_ulong();
                                this.write_ulong(bound);
                                break block2;
                            }
                        }
                        throw new InternalError();
                    }
                    case 13: {
                        this.write_Principal(in.read_Principal());
                        break;
                    }
                    case 14: {
                        IOR ior = IORHelper.read(in);
                        IORHelper.write(this, ior);
                        break;
                    }
                    case 15: {
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_InputStream(in, tc.member_type(i));
                        }
                        break;
                    }
                    case 22: {
                        this.write_string(in.read_string());
                        for (int i = 0; i < tc.member_count(); ++i) {
                            this.write_InputStream(in, tc.member_type(i));
                        }
                        break;
                    }
                    case 16: {
                        int defaultIndex = tc.default_index();
                        int memberIndex = -1;
                        org.omg.CORBA.TypeCode origDiscType = TypeCode._OB_getOrigType(tc.discriminator_type());
                        block31 : switch (origDiscType.kind().value()) {
                            case 2: {
                                short val = in.read_short();
                                this.write_short(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_short()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 4: {
                                short val = in.read_ushort();
                                this.write_ushort(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_ushort()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 3: {
                                int val = in.read_long();
                                this.write_long(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_long()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 5: {
                                int val = in.read_ulong();
                                this.write_ulong(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_ulong()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 23: {
                                long val = in.read_longlong();
                                this.write_longlong(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_longlong()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 24: {
                                long val = in.read_ulonglong();
                                this.write_ulonglong(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_ulonglong()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 9: {
                                char val = in.read_char();
                                this.write_char(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_char()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 8: {
                                boolean val = in.read_boolean();
                                this.write_boolean(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).extract_boolean()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            case 17: {
                                int val = in.read_long();
                                this.write_long(val);
                                for (int i = 0; i < tc.member_count(); ++i) {
                                    if (i == defaultIndex || val != tc.member_label(i).create_input_stream().read_long()) continue;
                                    memberIndex = i;
                                    break block31;
                                }
                                break;
                            }
                            default: {
                                Assert._OB_assert(false);
                            }
                        }
                        if (memberIndex >= 0) {
                            this.write_InputStream(in, tc.member_type(memberIndex));
                            break;
                        }
                        if (defaultIndex >= 0) {
                            this.write_InputStream(in, tc.member_type(defaultIndex));
                        }
                        break;
                    }
                    case 18: {
                        this.write_string(in.read_string());
                        break;
                    }
                    case 27: {
                        this.write_wstring(in.read_wstring());
                        break;
                    }
                    case 19: 
                    case 20: {
                        int len;
                        if (tc.kind().value() == 19) {
                            len = in.read_ulong();
                            this.write_ulong(len);
                        } else {
                            len = tc.length();
                        }
                        if (len <= 0) break;
                        org.omg.CORBA.TypeCode origContentType = TypeCode._OB_getOrigType(tc.content_type());
                        switch (origContentType.kind().value()) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 4: {
                                if (obin == null || obin.swap_) {
                                    short[] s = new short[len];
                                    in.read_short_array(s, 0, len);
                                    this.write_short_array(s, 0, len);
                                    break;
                                }
                                this.write_short(obin.read_short());
                                int n = 2 * (len - 1);
                                if (n > 0) {
                                    this.addCapacity(n);
                                    Buffer buf = obin._OB_buffer();
                                    System.arraycopy(buf.data_, buf.pos_, this.buf_.data_, this.buf_.pos_, n);
                                    buf.pos_ += n;
                                    this.buf_.pos_ += n;
                                    break;
                                }
                                break block83;
                            }
                            case 3: 
                            case 5: 
                            case 6: {
                                if (obin == null || obin.swap_) {
                                    int[] i = new int[len];
                                    in.read_long_array(i, 0, len);
                                    this.write_long_array(i, 0, len);
                                    break;
                                }
                                this.write_long(obin.read_long());
                                int n = 4 * (len - 1);
                                if (n > 0) {
                                    this.addCapacity(n);
                                    Buffer buf = obin._OB_buffer();
                                    System.arraycopy(buf.data_, buf.pos_, this.buf_.data_, this.buf_.pos_, n);
                                    buf.pos_ += n;
                                    this.buf_.pos_ += n;
                                    break;
                                }
                                break block83;
                            }
                            case 7: 
                            case 23: 
                            case 24: {
                                if (obin == null || obin.swap_) {
                                    long[] l = new long[len];
                                    in.read_longlong_array(l, 0, len);
                                    this.write_longlong_array(l, 0, len);
                                    break;
                                }
                                this.write_longlong(obin.read_longlong());
                                int n = 8 * (len - 1);
                                if (n > 0) {
                                    this.addCapacity(n);
                                    Buffer buf = obin._OB_buffer();
                                    System.arraycopy(buf.data_, buf.pos_, this.buf_.data_, this.buf_.pos_, n);
                                    buf.pos_ += n;
                                    this.buf_.pos_ += n;
                                    break;
                                }
                                break block83;
                            }
                            case 8: 
                            case 10: {
                                if (obin == null) {
                                    this.addCapacity(len);
                                    in.read_octet_array(this.buf_.data_, this.buf_.pos_, len);
                                    this.buf_.pos_ += len;
                                    break;
                                }
                                this.addCapacity(len);
                                Buffer buf = obin._OB_buffer();
                                System.arraycopy(buf.data_, buf.pos_, this.buf_.data_, this.buf_.pos_, len);
                                buf.pos_ += len;
                                this.buf_.pos_ += len;
                                break;
                            }
                            case 9: {
                                if (this.charWriterOrConversionRequired_) {
                                    char[] ch = new char[len];
                                    in.read_char_array(ch, 0, len);
                                    this.write_char_array(ch, 0, len);
                                    break;
                                }
                                this.addCapacity(len);
                                in.read_octet_array(this.buf_.data_, this.buf_.pos_, len);
                                this.buf_.pos_ += len;
                                break;
                            }
                            case 26: {
                                char[] wch = new char[len];
                                in.read_wchar_array(wch, 0, len);
                                this.write_wchar_array(wch, 0, len);
                                break;
                            }
                            case 21: {
                                Assert._OB_assert(false);
                            }
                            default: {
                                for (int i = 0; i < len; ++i) {
                                    this.write_InputStream(in, tc.content_type());
                                }
                                break block83;
                            }
                        }
                        break;
                    }
                    case 21: {
                        this.write_InputStream(in, tc.content_type());
                        break;
                    }
                    case 29: 
                    case 30: {
                        if (obin == null) {
                            org.omg.CORBA_2_3.portable.InputStream i = (org.omg.CORBA_2_3.portable.InputStream)in;
                            this.write_value(i.read_value());
                            break;
                        }
                        obin._OB_remarshalValue(tc, this);
                        break;
                    }
                    case 32: {
                        boolean b = in.read_boolean();
                        this.write_boolean(b);
                        if (b) {
                            this.write_Object(in.read_Object());
                            break;
                        }
                        if (obin == null) {
                            org.omg.CORBA_2_3.portable.InputStream i = (org.omg.CORBA_2_3.portable.InputStream)in;
                            this.write_value(i.read_value());
                            break;
                        }
                        obin._OB_remarshalValue(ValueBaseHelper.type(), this);
                        break;
                    }
                    default: {
                        Assert._OB_assert(false);
                    }
                }
            }
            catch (BadKind ex) {
                Assert._OB_assert(false);
            }
            catch (Bounds ex) {
                Assert._OB_assert(false);
            }
        }
    }

    public OutputStream(Buffer buf) {
        this(buf, null, 0);
    }

    public OutputStream(Buffer buf, CodeConverters converters, int GIOPVersion) {
        this.buf_ = buf;
        if (GIOPVersion != 0) {
            this.GIOPVersion_ = GIOPVersion;
        }
        this.charWriterRequired_ = false;
        this.charConversionRequired_ = false;
        this.charWriterOrConversionRequired_ = false;
        this.wCharConversionRequired_ = false;
        if (converters != null) {
            this.codeConverters_ = new CodeConverters(converters);
            if (this.codeConverters_.outputCharConverter != null) {
                this.charWriterRequired_ = this.codeConverters_.outputCharConverter.writerRequired();
                this.charConversionRequired_ = this.codeConverters_.outputCharConverter.conversionRequired();
                if (this.charWriterRequired_ || this.charConversionRequired_) {
                    this.charWriterOrConversionRequired_ = true;
                }
            }
            if (this.codeConverters_.outputWcharConverter != null) {
                this.wCharConversionRequired_ = this.codeConverters_.outputWcharConverter.conversionRequired();
            }
        }
    }

    public Buffer _OB_buffer() {
        return this.buf_;
    }

    public int _OB_pos() {
        return this.buf_.pos_;
    }

    public void _OB_pos(int pos) {
        this.buf_.pos_ = pos;
    }

    public void _OB_align(int n) {
        if (this.buf_.pos_ % n != 0) {
            this.addCapacity(0, n);
        }
    }

    public void _OB_alignNext(int n) {
        this.alignNext_ = n;
    }

    public void _OB_writeEndian() {
        this.write_boolean(false);
    }

    public void _OB_beginValue(int tag, String[] ids, boolean chunked) {
        this.valueWriter().beginValue(tag, ids, chunked);
    }

    public void _OB_endValue() {
        this.valueWriter().endValue();
    }

    public void _OB_ORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }

    public void _OB_invocationContext(java.lang.Object invocationContext) {
        this.invocationContext_ = invocationContext;
    }

    public java.lang.Object _OB_invocationContext() {
        return this.invocationContext_;
    }

    public void _OB_delegateContext(java.lang.Object delegateContext) {
        this.delegateContext_ = delegateContext;
    }

    public java.lang.Object _OB_delegateContext() {
        return this.delegateContext_;
    }
}

