/*
 * Decompiled with CFR 0.152.
 */
package test.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJECT_NOT_EXISTHelper;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynArrayHelper;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynEnumHelper;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynFixedHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynUnionHelper;
import org.omg.DynamicAny.DynValue;
import org.omg.DynamicAny.DynValueBox;
import org.omg.DynamicAny.DynValueBoxHelper;
import org.omg.DynamicAny.DynValueHelper;
import org.omg.DynamicAny.NameDynAnyPair;
import org.omg.DynamicAny.NameValuePair;
import test.common.TestBase;
import test.types.DynAnyTypes.TestAnySeqHelper;
import test.types.DynAnyTypes.TestBoundedString10SeqHelper;
import test.types.DynAnyTypes.TestBoundedStringHelper;
import test.types.DynAnyTypes.TestEmptyException;
import test.types.DynAnyTypes.TestEmptyExceptionHelper;
import test.types.DynAnyTypes.TestEnum;
import test.types.DynAnyTypes.TestShortSeqHelper;
import test.types.DynAnyTypes.TestStringArrayHelper;
import test.types.DynAnyTypes.TestStringBoxHelper;
import test.types.DynAnyTypes.TestStruct;
import test.types.DynAnyTypes.TestStructBoxHelper;
import test.types.DynAnyTypes.TestStructHelper;
import test.types.DynAnyTypes.TestUnion1;
import test.types.DynAnyTypes.TestUnion1Helper;
import test.types.DynAnyTypes.TestUnion2;
import test.types.DynAnyTypes.TestUnion2Helper;
import test.types.DynAnyTypes.TestUnion3;
import test.types.DynAnyTypes.TestUnion3Helper;
import test.types.DynAnyTypes.TestUnion4;
import test.types.DynAnyTypes.TestUnion4Helper;
import test.types.DynAnyTypes.TestValue1;
import test.types.DynAnyTypes.TestValue1Helper;
import test.types.DynAnyTypes.TestValue2;
import test.types.DynAnyTypes.TestValue2Helper;
import test.types.DynAnyTypes.TestValue3;
import test.types.DynAnyTypes.TestValue3Helper;
import test.types.DynAnyTypes.TestValue4;
import test.types.DynAnyTypes.TestValue4Helper;
import test.types.DynAnyTypes.TestValueStructHelper;
import test.types.TestEnumHelper;

public class TestDynAny
extends TestBase {
    static final short SHORT_VALUE = -10000;
    static final short USHORT_VALUE = -25536;
    static final int LONG_VALUE = -300000;
    static final int ULONG_VALUE = 500000;
    static final float FLOAT_VALUE = 1.9183f;
    static final double DOUBLE_VALUE = 7.31E29;
    static final boolean BOOLEAN_VALUE = true;
    static final char CHAR_VALUE = 'Y';
    static final byte OCTET_VALUE = -101;
    static final String ANY_VALUE = "This is a string in an any";
    static TypeCode TYPECODE_VALUE;
    static final String STRING_VALUE = "This is a string";
    static final long LONGLONG_VALUE = -1234567890L;
    static final long ULONGLONG_VALUE = 9876543210L;
    static final char WCHAR_VALUE = 'Z';
    static final String WSTRING_VALUE = "This is a wstring";

    static void testOps(org.omg.CORBA.ORB orb, DynAnyFactory factory, TypeCode tc, boolean hasComponents) {
        block19: {
            try {
                Any badAny = orb.create_any();
                DynAny d1 = null;
                DynAny d2 = null;
                DynAny d3 = null;
                java.lang.Object copy = null;
                TypeCode origTC = TestDynAny.getOrigType(tc);
                if (tc.kind() != TCKind.tk_short) {
                    badAny.insert_short((short)0);
                } else {
                    badAny.insert_ushort((short)0);
                }
                d1 = factory.create_dyn_any_from_type_code(tc);
                TypeCode tcv = d1.type();
                TestDynAny.TEST(tc.equal(tcv));
                d1.destroy();
                try {
                    d1 = factory.create_dyn_any_from_type_code(tc);
                    d2 = factory.create_dyn_any(badAny);
                    d1.assign(d2);
                    TestDynAny.TEST("assign() should not have succeeded" == null);
                }
                catch (TypeMismatch ex) {
                    d1.destroy();
                    d2.destroy();
                }
                try {
                    d1 = factory.create_dyn_any_from_type_code(tc);
                    d1.from_any(badAny);
                    TestDynAny.TEST("from_any() should not have succeeded" == null);
                }
                catch (TypeMismatch ex) {
                    d1.destroy();
                }
                switch (origTC.kind().value()) {
                    case 0: 
                    case 1: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 29: 
                    case 30: {
                        break;
                    }
                    default: {
                        try {
                            Any a = orb.create_any();
                            a.type(tc);
                            d1 = factory.create_dyn_any_from_type_code(tc);
                            d1.from_any(a);
                            TestDynAny.TEST("from_any() should not have succeeded" == null);
                            break;
                        }
                        catch (InvalidValue ex) {
                            d1.destroy();
                        }
                    }
                }
                if (hasComponents) {
                    d1 = factory.create_dyn_any_from_type_code(tc);
                    int count = origTC.kind() == TCKind.tk_union ? d1.component_count() : origTC.member_count();
                    TestDynAny.TEST(count > 0);
                    TestDynAny.TEST(d1.seek(0));
                    TestDynAny.TEST(!d1.seek(-1));
                    TestDynAny.TEST(!d1.seek(count));
                    TestDynAny.TEST(d1.seek(count - 1));
                    d1.seek(-1);
                    TestDynAny.TEST(d1.next());
                    d1.seek(count - 1);
                    TestDynAny.TEST(!d1.next());
                    TestDynAny.TEST(d1.component_count() == count);
                    d1.rewind();
                    d2 = d1.current_component();
                    TestDynAny.TEST(d2 != null);
                    d2.destroy();
                    d2.destroy();
                    d1.seek(-9);
                    d3 = d1.current_component();
                    TestDynAny.TEST(d3 == null);
                    d1.destroy();
                    break block19;
                }
                d1 = factory.create_dyn_any_from_type_code(tc);
                TestDynAny.TEST(!d1.seek(0));
                TestDynAny.TEST(!d1.seek(-1));
                TestDynAny.TEST(!d1.next());
                TestDynAny.TEST(d1.component_count() == 0);
                try {
                    d1.current_component();
                    TestDynAny.TEST("current_component() should not have succeeded" == null);
                }
                catch (TypeMismatch ex) {
                    // empty catch block
                }
                d1.destroy();
            }
            catch (InconsistentTypeCode ex) {
                TestDynAny.TEST(false);
            }
            catch (TypeMismatch ex) {
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                TestDynAny.TEST(false);
            }
            catch (BadKind ex) {
                TestDynAny.TEST(false);
            }
        }
    }

    static void testBasic(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            DynAny d1 = null;
            DynAny d2 = null;
            DynAny copy = null;
            TypeCode type = orb.get_primitive_tc(TCKind.tk_short);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_short() == 0);
            d1.insert_short((short)-53);
            TestDynAny.TEST(d1.get_short() == -53);
            d1.insert_short((short)32000);
            TestDynAny.TEST(d1.get_short() == 32000);
            Any av = d1.to_any();
            short shortVal = av.extract_short();
            TestDynAny.TEST(shortVal == 32000);
            any.insert_short((short)32000);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_short() == 32000);
            any.insert_short((short)-99);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_ushort);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_ushort() == 0);
            d1.insert_ushort((short)199);
            TestDynAny.TEST(d1.get_ushort() == 199);
            d1.insert_ushort((short)-535);
            TestDynAny.TEST(d1.get_ushort() == -535);
            av = d1.to_any();
            short ushortVal = av.extract_ushort();
            TestDynAny.TEST(ushortVal == -535);
            any.insert_ushort((short)-535);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_ushort() == -535);
            any.insert_ushort((short)501);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_long);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_long() == 0);
            d1.insert_long(-530000);
            TestDynAny.TEST(d1.get_long() == -530000);
            d1.insert_long(3200000);
            TestDynAny.TEST(d1.get_long() == 3200000);
            av = d1.to_any();
            int longVal = av.extract_long();
            TestDynAny.TEST(longVal == 3200000);
            any.insert_long(3200000);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_long() == 3200000);
            any.insert_long(-99000);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_ulong);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_ulong() == 0);
            d1.insert_ulong(199000);
            TestDynAny.TEST(d1.get_ulong() == 199000);
            d1.insert_ulong(65001000);
            TestDynAny.TEST(d1.get_ulong() == 65001000);
            av = d1.to_any();
            int ulongVal = av.extract_ulong();
            TestDynAny.TEST(ulongVal == 65001000);
            any.insert_ulong(65001000);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_ulong() == 65001000);
            any.insert_ulong(501000);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_float);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_float() == 0.0f);
            d1.insert_float(199.001f);
            TestDynAny.TEST(d1.get_float() > 199.0f && d1.get_float() < 199.1f);
            d1.insert_float(6500.1f);
            TestDynAny.TEST(d1.get_float() > 6500.0f && d1.get_float() < 6501.0f);
            av = d1.to_any();
            float floatVal = av.extract_float();
            TestDynAny.TEST((double)floatVal > 6500.1 && (double)floatVal < 6500.2);
            any.insert_float(6500.1f);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST((double)copy.get_float() > 6500.1 && (double)copy.get_float() < 6500.2);
            any.insert_float(501.001f);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_double);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_double() == 0.0);
            d1.insert_double(199000.001);
            TestDynAny.TEST(d1.get_double() > 199000.0 && d1.get_double() < 199000.1);
            d1.insert_double(6500000.10001);
            TestDynAny.TEST(d1.get_double() > 6500000.1 && d1.get_double() < 6500000.2);
            av = d1.to_any();
            double doubleVal = av.extract_double();
            TestDynAny.TEST(doubleVal > 6500000.1 && doubleVal < 6500000.2);
            any.insert_double(6500000.10001);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_double() > 6500000.1 && copy.get_double() < 6500000.2);
            any.insert_double(501000.001);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_boolean);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(!d1.get_boolean());
            d1.insert_boolean(false);
            TestDynAny.TEST(!d1.get_boolean());
            d1.insert_boolean(true);
            TestDynAny.TEST(d1.get_boolean());
            av = d1.to_any();
            boolean boolVal = av.extract_boolean();
            TestDynAny.TEST(boolVal);
            any.insert_boolean(true);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_boolean());
            any.insert_boolean(false);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_char);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_char() == '\u0000');
            d1.insert_char('A');
            TestDynAny.TEST(d1.get_char() == 'A');
            d1.insert_char('z');
            TestDynAny.TEST(d1.get_char() == 'z');
            av = d1.to_any();
            char charVal = av.extract_char();
            TestDynAny.TEST(charVal == 'z');
            any.insert_char('z');
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_char() == 'z');
            any.insert_char('@');
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_octet);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_octet() == 0);
            d1.insert_octet((byte)-1);
            TestDynAny.TEST(d1.get_octet() == -1);
            d1.insert_octet((byte)1);
            TestDynAny.TEST(d1.get_octet() == 1);
            av = d1.to_any();
            byte octetVal = av.extract_octet();
            TestDynAny.TEST(octetVal == 1);
            any.insert_octet((byte)1);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_octet() == 1);
            any.insert_octet((byte)127);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_any);
            d1 = factory.create_dyn_any_from_type_code(type);
            any.insert_long(345678);
            d1.insert_any(any);
            av = d1.get_any();
            longVal = av.extract_long();
            TestDynAny.TEST(longVal == 345678);
            Any anyVal = orb.create_any();
            anyVal.insert_long(345678);
            any.insert_any(anyVal);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            av = d1.to_any();
            Any cap = av.extract_any();
            longVal = cap.extract_long();
            TestDynAny.TEST(longVal == 345678);
            anyVal.insert_string("anyValue");
            any.insert_any(anyVal);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_TypeCode);
            d1 = factory.create_dyn_any_from_type_code(type);
            TypeCode tcVal = d1.get_typecode();
            TypeCode tcNull = orb.get_primitive_tc(TCKind.tk_null);
            TestDynAny.TEST(tcVal.equal(tcNull));
            TypeCode tcFloat = orb.get_primitive_tc(TCKind.tk_float);
            d1.insert_typecode(tcFloat);
            tcVal = d1.get_typecode();
            TestDynAny.TEST(tcVal.equal(tcFloat));
            av = d1.to_any();
            tcVal = av.extract_TypeCode();
            TestDynAny.TEST(tcVal.equal(tcFloat));
            any.insert_TypeCode(tcFloat);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            tcVal = copy.get_typecode();
            TestDynAny.TEST(tcVal.equal(tcFloat));
            TypeCode tcDouble = orb.get_primitive_tc(TCKind.tk_double);
            any.insert_TypeCode(tcDouble);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_objref);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_reference() == null);
            Object objVal1 = orb.string_to_object("corbaloc::localhost:9999/SomeKey");
            d1.insert_reference(objVal1);
            Object objVal2 = d1.get_reference();
            TestDynAny.TEST(objVal1._is_equivalent(objVal2));
            av = d1.to_any();
            objVal2 = av.extract_Object();
            TestDynAny.TEST(objVal1._is_equivalent(objVal2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            d2 = factory.create_dyn_any_from_type_code(type);
            any.insert_Object(objVal2);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.insert_reference(null);
            objVal1 = d1.get_reference();
            TestDynAny.TEST(objVal1 == null);
            d2.assign(d1);
            TestDynAny.TEST(d1.equal(d2));
            copy.destroy();
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.create_string_tc(0);
            d1 = factory.create_dyn_any_from_type_code(type);
            String stringVal = d1.get_string();
            TestDynAny.TEST(stringVal.length() == 0);
            d1.insert_string("polymorph");
            stringVal = d1.get_string();
            TestDynAny.TEST(stringVal.equals("polymorph"));
            av = d1.to_any();
            String ccp = av.extract_string();
            TestDynAny.TEST(ccp.equals("polymorph"));
            any.insert_string("polymorph");
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            stringVal = copy.get_string();
            TestDynAny.TEST(stringVal.equals("polymorph"));
            any.insert_string("cloister");
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            long ll1 = -530000999L;
            long ll2 = 3200000999L;
            long ll3 = -99000999L;
            type = orb.get_primitive_tc(TCKind.tk_longlong);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_longlong() == 0L);
            d1.insert_longlong(ll1);
            TestDynAny.TEST(d1.get_longlong() == ll1);
            d1.insert_longlong(ll2);
            TestDynAny.TEST(d1.get_longlong() == ll2);
            av = d1.to_any();
            long longlongVal = av.extract_longlong();
            TestDynAny.TEST(longlongVal == ll2);
            any.insert_longlong(ll2);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_longlong() == ll2);
            any.insert_longlong(ll3);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            long ul1 = 199000999L;
            long ul2 = 65001000999L;
            long ul3 = 501000999L;
            type = orb.get_primitive_tc(TCKind.tk_ulonglong);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_ulonglong() == 0L);
            d1.insert_ulonglong(ul1);
            TestDynAny.TEST(d1.get_ulonglong() == ul1);
            d1.insert_ulonglong(ul2);
            TestDynAny.TEST(d1.get_ulonglong() == ul2);
            av = d1.to_any();
            long ulonglongVal = av.extract_ulonglong();
            TestDynAny.TEST(ulonglongVal == ul2);
            any.insert_ulonglong(ul2);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_ulonglong() == ul2);
            any.insert_ulonglong(ul3);
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_wchar);
            d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.get_wchar() == '\u0000');
            d1.insert_wchar('A');
            TestDynAny.TEST(d1.get_wchar() == 'A');
            d1.insert_wchar('z');
            TestDynAny.TEST(d1.get_wchar() == 'z');
            av = d1.to_any();
            char wcharVal = av.extract_wchar();
            TestDynAny.TEST(wcharVal == 'z');
            any.insert_wchar('z');
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            TestDynAny.TEST(copy.get_wchar() == 'z');
            any.insert_wchar('@');
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.create_wstring_tc(0);
            d1 = factory.create_dyn_any_from_type_code(type);
            String wstringVal = d1.get_wstring();
            TestDynAny.TEST(wstringVal.length() == 0);
            d1.insert_wstring("polymorph");
            wstringVal = d1.get_wstring();
            String wstr = "polymorph";
            TestDynAny.TEST(wstringVal.equals(wstr));
            av = d1.to_any();
            String cwp = av.extract_wstring();
            TestDynAny.TEST(cwp.equals(wstr));
            any.insert_wstring(wstr);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            wstringVal = copy.get_wstring();
            TestDynAny.TEST(wstringVal.equals(wstr));
            any.insert_wstring("cloister");
            d2.from_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d1.destroy();
            d2.destroy();
            copy.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_null);
            d1 = factory.create_dyn_any_from_type_code(type);
            av = d1.to_any();
            TypeCode tc = av.type();
            TestDynAny.TEST(tc.equal(type));
            d2 = d1.copy();
            d1.assign(d2);
            d1.destroy();
            d2.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_void);
            d1 = factory.create_dyn_any_from_type_code(type);
            av = d1.to_any();
            tc = av.type();
            TestDynAny.TEST(tc.equal(type));
            d2 = d1.copy();
            d1.assign(d2);
            d1.destroy();
            d2.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = orb.get_primitive_tc(TCKind.tk_any);
            d1 = factory.create_dyn_any_from_type_code(type);
            anyVal.insert_boolean(true);
            any.insert_any(anyVal);
            d2 = factory.create_dyn_any(any);
            d1.insert_dyn_any(d2);
            copy = d1.get_dyn_any();
            TestDynAny.TEST(copy.get_boolean());
            anyVal.insert_short((short)53);
            d1.insert_any(anyVal);
            copy = d1.get_dyn_any();
            TestDynAny.TEST(copy.get_short() == 53);
            d1.destroy();
            d2.destroy();
            type = orb.create_string_tc(3);
            d1 = factory.create_dyn_any_from_type_code(type);
            d1.insert_string("123");
            stringVal = d1.get_string();
            TestDynAny.TEST(stringVal.equals("123"));
            try {
                d1.insert_string("four");
                TestDynAny.TEST("insert_string() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            d1.destroy();
            wstr = "123";
            type = orb.create_wstring_tc(3);
            d1 = factory.create_dyn_any_from_type_code(type);
            d1.insert_wstring(wstr);
            wstringVal = d1.get_wstring();
            TestDynAny.TEST(wstringVal.equals(wstr));
            try {
                d1.insert_wstring("four");
                TestDynAny.TEST("insert_wstring() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testFixed(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            DynAny d1 = null;
            DynAny d2 = null;
            DynAny copy = null;
            TypeCode tc = orb.create_fixed_tc((short)5, (short)2);
            d1 = factory.create_dyn_any_from_type_code(tc);
            DynFixed f1 = DynFixedHelper.narrow((Object)d1);
            String str = f1.get_value();
            BigDecimal f = new BigDecimal(str);
            TestDynAny.TEST(f.equals(new BigDecimal("0")));
            TestDynAny.TEST(f1.set_value("1.1"));
            TestDynAny.TEST(f1.set_value("123.1"));
            TestDynAny.TEST(f1.set_value("123.12"));
            TestDynAny.TEST(!f1.set_value("123.123"));
            f = new BigDecimal("98");
            any.insert_fixed(f, tc);
            f1.from_any(any);
            Any av = f1.to_any();
            f = av.extract_fixed();
            TestDynAny.TEST(f.equals(new BigDecimal("98")));
            copy = f1.copy();
            TestDynAny.TEST(f1.equal(copy));
            f1.destroy();
            copy.destroy();
            try {
                d1 = factory.create_dyn_any_from_type_code(tc);
                f1 = DynFixedHelper.narrow((Object)d1);
                f1.set_value("");
                TestDynAny.TEST("set_value() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                d1.destroy();
            }
            try {
                d1 = factory.create_dyn_any_from_type_code(tc);
                f1 = DynFixedHelper.narrow((Object)d1);
                f1.set_value("-123D?");
                TestDynAny.TEST("set_value() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                d1.destroy();
            }
            try {
                d1 = factory.create_dyn_any_from_type_code(tc);
                f1 = DynFixedHelper.narrow((Object)d1);
                f1.set_value("12345.123");
                TestDynAny.TEST("set_value() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                d1.destroy();
            }
            try {
                f = new BigDecimal("99");
                any.insert_fixed(f, orb.create_fixed_tc((short)4, (short)2));
                d1 = factory.create_dyn_any(any);
                d2 = factory.create_dyn_any_from_type_code(tc);
                d2.assign(d1);
                TestDynAny.TEST("assign() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                d1.destroy();
                d2.destroy();
            }
            try {
                f = new BigDecimal("99");
                any.insert_fixed(f, orb.create_fixed_tc((short)4, (short)2));
                d1 = factory.create_dyn_any_from_type_code(tc);
                d1.from_any(any);
                TestDynAny.TEST("from_any() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                d1.destroy();
            }
            TestDynAny.testOps(orb, factory, tc, false);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testEnum(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            DynAny d1 = null;
            java.lang.Object d2 = null;
            DynAny copy = null;
            TypeCode type = test.types.DynAnyTypes.TestEnumHelper.type();
            d1 = factory.create_dyn_any_from_type_code(type);
            DynEnum e1 = DynEnumHelper.narrow((Object)d1);
            TestDynAny.TEST(e1.get_as_ulong() == 0);
            String str = e1.get_as_string();
            TestDynAny.TEST(str.equals("red"));
            e1.set_as_string("green");
            TestDynAny.TEST(e1.get_as_ulong() == 1);
            str = e1.get_as_string();
            TestDynAny.TEST(str.equals("green"));
            e1.set_as_string("blue");
            TestDynAny.TEST(e1.get_as_ulong() == 2);
            str = e1.get_as_string();
            TestDynAny.TEST(str.equals("blue"));
            e1.set_as_ulong(1);
            TestDynAny.TEST(e1.get_as_ulong() == 1);
            str = e1.get_as_string();
            TestDynAny.TEST(str.equals("green"));
            e1.set_as_ulong(2);
            TestDynAny.TEST(e1.get_as_ulong() == 2);
            str = e1.get_as_string();
            TestDynAny.TEST(str.equals("blue"));
            test.types.DynAnyTypes.TestEnumHelper.insert(any, TestEnum.green);
            e1.from_any(any);
            Any av = e1.to_any();
            TestEnum e = test.types.DynAnyTypes.TestEnumHelper.extract(av);
            TestDynAny.TEST(e == TestEnum.green);
            copy = e1.copy();
            TestDynAny.TEST(e1.equal(copy));
            e1.destroy();
            copy.destroy();
            try {
                d1 = factory.create_dyn_any_from_type_code(type);
                e1 = DynEnumHelper.narrow((Object)d1);
                e1.set_as_ulong(3);
                TestDynAny.TEST("set_as_ulong() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                d1.destroy();
            }
            try {
                d1 = factory.create_dyn_any_from_type_code(type);
                e1 = DynEnumHelper.narrow((Object)d1);
                e1.set_as_ulong(-1);
                TestDynAny.TEST("set_as_ulong() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                d1.destroy();
            }
            try {
                d1 = factory.create_dyn_any_from_type_code(type);
                e1 = DynEnumHelper.narrow((Object)d1);
                e1.set_as_string("alizarin");
                TestDynAny.TEST("set_as_string() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                d1.destroy();
            }
            TestDynAny.testOps(orb, factory, TestEnumHelper.type(), false);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void loadStruct(org.omg.CORBA.ORB orb, TestStruct ts) {
        ts.shortVal = (short)-10000;
        ts.ushortVal = (short)-25536;
        ts.longVal = -300000;
        ts.ulongVal = 500000;
        ts.floatVal = 1.9183f;
        ts.doubleVal = 7.31E29;
        ts.boolVal = true;
        ts.charVal = (char)89;
        ts.octetVal = (byte)-101;
        ts.anyVal = orb.create_any();
        ts.anyVal.insert_string(ANY_VALUE);
        ts.tcVal = TYPECODE_VALUE;
        ts.objectVal = null;
        ts.stringVal = STRING_VALUE;
        ts.longlongVal = -1234567890L;
        ts.ulonglongVal = 9876543210L;
        ts.wcharVal = (char)90;
        ts.wstringVal = WSTRING_VALUE;
    }

    static void checkStruct(TestStruct ts) {
        TestDynAny.TEST(ts.shortVal == -10000);
        TestDynAny.TEST(ts.ushortVal == -25536);
        TestDynAny.TEST(ts.longVal == -300000);
        TestDynAny.TEST(ts.ulongVal == 500000);
        TestDynAny.TEST(ts.floatVal == 1.9183f);
        TestDynAny.TEST(ts.doubleVal == 7.31E29);
        TestDynAny.TEST(ts.boolVal);
        TestDynAny.TEST(ts.charVal == 'Y');
        TestDynAny.TEST(ts.octetVal == -101);
        TestDynAny.TEST(ts.anyVal.extract_string().equals(ANY_VALUE));
        TestDynAny.TEST(ts.tcVal.equal(TYPECODE_VALUE));
        TestDynAny.TEST(ts.objectVal == null);
        TestDynAny.TEST(ts.stringVal.equals(STRING_VALUE));
        TestDynAny.TEST(ts.longlongVal == -1234567890L);
        TestDynAny.TEST(ts.ulonglongVal == 9876543210L);
        TestDynAny.TEST(ts.wcharVal == 'Z');
        TestDynAny.TEST(ts.wstringVal.equals(WSTRING_VALUE));
    }

    static void testStruct(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            int i;
            Any any = orb.create_any();
            TestStruct ts = new TestStruct();
            TypeCode type = TestStructHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynStruct s1 = DynStructHelper.narrow((Object)d1);
            String str = s1.current_member_name();
            TestDynAny.TEST(str.equals("shortVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_short);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("ushortVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_ushort);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("longVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_long);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("ulongVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_ulong);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("floatVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_float);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("doubleVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_double);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("boolVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_boolean);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("charVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_char);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("octetVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_octet);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("anyVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_any);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("tcVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_TypeCode);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("objectVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_objref);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("stringVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_string);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("longlongVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_longlong);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("ulonglongVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_ulonglong);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("wcharVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_wchar);
            s1.next();
            str = s1.current_member_name();
            TestDynAny.TEST(str.equals("wstringVal"));
            TestDynAny.TEST(s1.current_member_kind() == TCKind.tk_wstring);
            s1.rewind();
            s1.insert_short((short)-10000);
            s1.next();
            s1.insert_ushort((short)-25536);
            s1.next();
            s1.insert_long(-300000);
            s1.next();
            s1.insert_ulong(500000);
            s1.next();
            s1.insert_float(1.9183f);
            s1.next();
            s1.insert_double(7.31E29);
            s1.next();
            s1.insert_boolean(true);
            s1.next();
            s1.insert_char('Y');
            s1.next();
            s1.insert_octet((byte)-101);
            s1.next();
            any.insert_string(ANY_VALUE);
            s1.insert_any(any);
            s1.next();
            s1.insert_typecode(TYPECODE_VALUE);
            s1.next();
            s1.insert_reference(null);
            s1.next();
            s1.insert_string(STRING_VALUE);
            s1.next();
            s1.insert_longlong(-1234567890L);
            s1.next();
            s1.insert_ulonglong(9876543210L);
            s1.next();
            s1.insert_wchar('Z');
            s1.next();
            s1.insert_wstring(WSTRING_VALUE);
            s1.next();
            s1.rewind();
            TestDynAny.TEST(s1.get_short() == -10000);
            s1.next();
            TestDynAny.TEST(s1.get_ushort() == -25536);
            s1.next();
            TestDynAny.TEST(s1.get_long() == -300000);
            s1.next();
            TestDynAny.TEST(s1.get_ulong() == 500000);
            s1.next();
            TestDynAny.TEST(s1.get_float() == 1.9183f);
            s1.next();
            TestDynAny.TEST(s1.get_double() == 7.31E29);
            s1.next();
            TestDynAny.TEST(s1.get_boolean());
            s1.next();
            TestDynAny.TEST(s1.get_char() == 'Y');
            s1.next();
            TestDynAny.TEST(s1.get_octet() == -101);
            s1.next();
            Any av = s1.get_any();
            s1.next();
            TestDynAny.TEST(av.extract_string().equals(ANY_VALUE));
            TypeCode tc = s1.get_typecode();
            s1.next();
            TestDynAny.TEST(tc.equal(TYPECODE_VALUE));
            TestDynAny.TEST(s1.get_reference() == null);
            s1.next();
            str = s1.get_string();
            s1.next();
            TestDynAny.TEST(str.equals(STRING_VALUE));
            TestDynAny.TEST(s1.get_longlong() == -1234567890L);
            s1.next();
            TestDynAny.TEST(s1.get_ulonglong() == 9876543210L);
            s1.next();
            TestDynAny.TEST(s1.get_wchar() == 'Z');
            s1.next();
            String wstr = s1.get_wstring();
            s1.next();
            TestDynAny.TEST(wstr.equals(WSTRING_VALUE));
            TestDynAny.loadStruct(orb, ts);
            TestStructHelper.insert(any, ts);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            d1.from_any(any);
            av = d1.to_any();
            TestStruct pts = TestStructHelper.extract(av);
            TestDynAny.checkStruct(pts);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            NameValuePair[] nvpseq = s1.get_members();
            s1.rewind();
            for (i = 0; i < nvpseq.length; ++i) {
                str = s1.current_member_name();
                TestDynAny.TEST(str.equals(nvpseq[i].id));
                DynAny dv = factory.create_dyn_any(nvpseq[i].value);
                DynAny comp = s1.current_component();
                TestDynAny.TEST(dv.equal(comp));
                dv.destroy();
                s1.next();
            }
            s1.set_members(nvpseq);
            d2 = s1.current_component();
            tc = d2.type();
            TestDynAny.TEST(tc.kind() == TCKind.tk_short);
            TestStructHelper.insert(any, ts);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            try {
                str = nvpseq[2].id;
                nvpseq[2].id = "totally_wrong";
                s1.set_members(nvpseq);
                TestDynAny.TEST("set_members should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                nvpseq[2].id = str;
            }
            try {
                any = nvpseq[2].value;
                nvpseq[2].value.insert_string("this is not a long");
                s1.set_members(nvpseq);
                TestDynAny.TEST("set_members should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                nvpseq[2].value = any;
            }
            try {
                nvpseq = new NameValuePair[]{};
                s1.set_members(nvpseq);
                TestDynAny.TEST("set_members should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            NameDynAnyPair[] ndpseq = s1.get_members_as_dyn_any();
            s1.rewind();
            for (i = 0; i < ndpseq.length; ++i) {
                str = s1.current_member_name();
                TestDynAny.TEST(str.equals(ndpseq[i].id));
                s1.next();
            }
            s1.set_members_as_dyn_any(ndpseq);
            d2 = s1.current_component();
            tc = d2.type();
            TestDynAny.TEST(tc.kind() == TCKind.tk_short);
            TestStructHelper.insert(any, ts);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            try {
                str = ndpseq[2].id;
                ndpseq[2].id = "totally_wrong";
                s1.set_members_as_dyn_any(ndpseq);
                TestDynAny.TEST("set_members_as_dyn_any should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                ndpseq[2].id = str;
            }
            try {
                d2 = ndpseq[2].value;
                any.insert_boolean(false);
                ndpseq[2].value = factory.create_dyn_any(any);
                s1.set_members_as_dyn_any(ndpseq);
                TestDynAny.TEST("set_members_as_dyn_any should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                ndpseq[2].value.destroy();
                ndpseq[2].value = d2;
            }
            try {
                ndpseq = new NameDynAnyPair[]{};
                s1.set_members_as_dyn_any(ndpseq);
                TestDynAny.TEST("set_members_as_dyn_any should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            d1.destroy();
            TestDynAny.testOps(orb, factory, type, true);
            type = TestEmptyExceptionHelper.type();
            d1 = factory.create_dyn_any_from_type_code(type);
            s1 = DynStructHelper.narrow((Object)d1);
            TestEmptyException ex = new TestEmptyException();
            TestEmptyExceptionHelper.insert(any, ex);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d1.assign(d2);
            d1.from_any(any);
            nvpseq = s1.get_members();
            TestDynAny.TEST(nvpseq.length == 0);
            s1.set_members(nvpseq);
            d1.destroy();
            d2.destroy();
            TestDynAny.testOps(orb, factory, type, false);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testException(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestEmptyExceptionHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynStruct s1 = DynStructHelper.narrow((Object)d1);
            TestEmptyException ex = new TestEmptyException();
            TestEmptyExceptionHelper.insert(any, ex);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d1.assign(d2);
            d1.from_any(any);
            NameValuePair[] nvpseq = s1.get_members();
            TestDynAny.TEST(nvpseq.length == 0);
            s1.set_members(nvpseq);
            d1.destroy();
            d2.destroy();
            TestDynAny.testOps(orb, factory, type, false);
            type = OBJECT_NOT_EXISTHelper.type();
            d1 = factory.create_dyn_any_from_type_code(type);
            s1 = DynStructHelper.narrow((Object)d1);
            d1.insert_ulong(1);
            d1.next();
            d2 = d1.current_component();
            DynEnum de = DynEnumHelper.narrow((Object)d2);
            de.set_as_string("COMPLETED_MAYBE");
            OBJECT_NOT_EXIST one = new OBJECT_NOT_EXIST(1, CompletionStatus.COMPLETED_MAYBE);
            OBJECT_NOT_EXISTHelper.insert((Any)any, (OBJECT_NOT_EXIST)one);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d1.assign(d2);
            d1.from_any(any);
            nvpseq = s1.get_members();
            TestDynAny.TEST(nvpseq.length == 2);
            Any av = d1.to_any();
            one = OBJECT_NOT_EXISTHelper.extract((Any)av);
            TestDynAny.TEST(one.minor == 1);
            TestDynAny.TEST(one.completed == CompletionStatus.COMPLETED_MAYBE);
            d1.destroy();
            d2.destroy();
            TestDynAny.testOps(orb, factory, type, true);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testUnion1(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestUnion1 tu1 = new TestUnion1();
            TypeCode type = TestUnion1Helper.type();
            TypeCode discType = orb.get_primitive_tc(TCKind.tk_short);
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynUnion u1 = DynUnionHelper.narrow((Object)d1);
            TestDynAny.TEST(u1.discriminator_kind() == TCKind.tk_short);
            String str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            DynAny disc = u1.get_discriminator();
            TestDynAny.TEST(disc.get_short() == 0);
            TestDynAny.TEST(u1.component_count() == 2);
            u1.seek(1);
            u1.insert_long(55);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)1);
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            TestDynAny.TEST(u1.get_long() == 55);
            disc.destroy();
            disc = u1.get_discriminator();
            TestDynAny.TEST(disc.get_short() == 1);
            u1.rewind();
            TestDynAny.TEST(u1.get_short() == 1);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)3);
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("b"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_float);
            TestDynAny.TEST(u1.get_float() == 0.0f);
            u1.insert_float(99.99f);
            disc.destroy();
            disc = u1.get_discriminator();
            TestDynAny.TEST(disc.get_short() == 3);
            u1.rewind();
            TestDynAny.TEST(u1.get_short() == 3);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)9);
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_string);
            str = u1.get_string();
            TestDynAny.TEST(str.length() == 0);
            u1.insert_string("hi there");
            disc.insert_short((short)23);
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            str = u1.get_string();
            TestDynAny.TEST(str.equals("hi there"));
            disc.destroy();
            disc = factory.create_dyn_any_from_type_code(orb.get_primitive_tc(TCKind.tk_ushort));
            disc.insert_ushort((short)55);
            try {
                u1.set_discriminator(disc);
                TestDynAny.TEST("set_discriminator() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc.destroy();
            u1.set_to_default_member();
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            u1.next();
            str = u1.get_string();
            TestDynAny.TEST(str.equals("hi there"));
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)1);
            u1.set_discriminator(disc);
            disc.destroy();
            u1.set_to_default_member();
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            TestDynAny.TEST(u1.component_count() == 2);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)0);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)1);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)3);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)2);
            u1.set_discriminator(disc);
            TestDynAny.TEST(u1.is_set_to_default_member());
            disc.destroy();
            disc = u1.get_discriminator();
            disc.insert_short((short)0);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)1);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)3);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)2);
            TestDynAny.TEST(u1.is_set_to_default_member());
            TestDynAny.TEST(!u1.has_no_active_member());
            try {
                u1.set_to_no_active_member();
                TestDynAny.TEST("set_to_no_active_member() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            u1.set_to_default_member();
            u1.seek(0);
            disc = u1.current_component();
            disc.insert_short((short)0);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            u1.insert_long(55);
            disc.insert_short((short)1);
            TestDynAny.TEST(u1.get_long() == 55);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)1);
            u1.set_discriminator(disc);
            disc.destroy();
            u1.insert_long(49);
            Any av = u1.to_any();
            TestUnion1 ptu1 = TestUnion1Helper.extract(av);
            TestDynAny.TEST(ptu1.discriminator() == 1);
            TestDynAny.TEST(ptu1.a() == 49);
            tu1.c("hi there");
            TestUnion1Helper.insert(any, tu1);
            DynAny d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            u1.seek(1);
            str = u1.get_string();
            TestDynAny.TEST(str.equals("hi there"));
            d2.destroy();
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            d1.destroy();
            TestDynAny.testOps(orb, factory, type, true);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testUnion2(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestUnion2 tu2 = new TestUnion2();
            TypeCode type = TestUnion2Helper.type();
            TypeCode discType = orb.get_primitive_tc(TCKind.tk_boolean);
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynUnion u1 = DynUnionHelper.narrow((Object)d1);
            TestDynAny.TEST(u1.discriminator_kind() == TCKind.tk_boolean);
            String str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            DynAny disc = u1.get_discriminator();
            TestDynAny.TEST(disc.get_boolean());
            TestDynAny.TEST(u1.component_count() == 2);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_boolean(false);
            u1.set_discriminator(disc);
            TestDynAny.TEST(u1.component_count() == 1);
            disc.destroy();
            TestDynAny.TEST(!u1.seek(1));
            u1.rewind();
            TestDynAny.TEST(!u1.next());
            DynAny copy = u1.copy();
            TestDynAny.TEST(u1.equal(copy));
            copy.destroy();
            TestDynAny.TEST(u1.has_no_active_member());
            disc = factory.create_dyn_any_from_type_code(orb.get_primitive_tc(TCKind.tk_ushort));
            disc.insert_ushort((short)55);
            try {
                u1.set_discriminator(disc);
                TestDynAny.TEST("set_discriminator() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc.destroy();
            try {
                u1.set_to_default_member();
                TestDynAny.TEST("set_to_default_member() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_boolean(true);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_boolean(false);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.destroy();
            disc = u1.get_discriminator();
            disc.insert_boolean(true);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_boolean(false);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            try {
                DynAny member = u1.member();
                TestDynAny.TEST("member() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                str = u1.member_name();
                TestDynAny.TEST("member_name() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                u1.member_kind();
                TestDynAny.TEST("member_kind() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_boolean(true);
            u1.set_discriminator(disc);
            disc.destroy();
            u1.insert_long(49);
            TestDynAny.TEST(!u1.has_no_active_member());
            u1.set_to_no_active_member();
            TestDynAny.TEST(u1.has_no_active_member());
            u1.set_to_no_active_member();
            disc = u1.current_component();
            TestDynAny.TEST(!disc.get_boolean());
            disc.insert_boolean(true);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            u1.insert_long(55);
            TestDynAny.TEST(u1.get_long() == 55);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_boolean(true);
            u1.set_discriminator(disc);
            disc.destroy();
            u1.insert_long(49);
            Any av = u1.to_any();
            TestUnion2 ptu2 = TestUnion2Helper.extract(av);
            TestDynAny.TEST(ptu2.discriminator());
            TestDynAny.TEST(ptu2.a() == 49);
            tu2.a(199);
            TestUnion2Helper.insert(any, tu2);
            DynAny d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            u1.seek(1);
            TestDynAny.TEST(u1.get_long() == 199);
            d2.destroy();
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            d1.destroy();
            TestDynAny.testOps(orb, factory, type, true);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testUnion3(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestUnion3 tu3 = new TestUnion3();
            TypeCode type = TestUnion3Helper.type();
            TypeCode discType = test.types.DynAnyTypes.TestEnumHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynUnion u1 = DynUnionHelper.narrow((Object)d1);
            TestDynAny.TEST(u1.discriminator_kind() == TCKind.tk_enum);
            String str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            DynAny disc = u1.get_discriminator();
            DynEnum e = DynEnumHelper.narrow((Object)disc);
            TestDynAny.TEST(e.get_as_ulong() == 0);
            TestDynAny.TEST(u1.component_count() == 2);
            disc = factory.create_dyn_any_from_type_code(discType);
            e = DynEnumHelper.narrow((Object)disc);
            e.set_as_string("green");
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("b"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_double);
            TestDynAny.TEST(u1.component_count() == 2);
            e.set_as_string("blue");
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("c"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_char);
            TestDynAny.TEST(u1.component_count() == 2);
            disc.destroy();
            DynAny copy = u1.copy();
            TestDynAny.TEST(u1.equal(copy));
            copy.destroy();
            TestDynAny.TEST(!u1.has_no_active_member());
            disc = factory.create_dyn_any_from_type_code(orb.get_primitive_tc(TCKind.tk_ushort));
            disc.insert_ushort((short)55);
            try {
                u1.set_discriminator(disc);
                TestDynAny.TEST("set_discriminator() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc.destroy();
            try {
                u1.set_to_default_member();
                TestDynAny.TEST("set_to_default_member() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc = factory.create_dyn_any_from_type_code(discType);
            e = DynEnumHelper.narrow((Object)disc);
            e.set_as_string("red");
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            e.set_as_string("green");
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            e.set_as_string("blue");
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.destroy();
            disc = u1.get_discriminator();
            e = DynEnumHelper.narrow((Object)disc);
            e.set_as_string("red");
            TestDynAny.TEST(!u1.is_set_to_default_member());
            e.set_as_string("green");
            TestDynAny.TEST(!u1.is_set_to_default_member());
            e.set_as_string("blue");
            TestDynAny.TEST(!u1.is_set_to_default_member());
            try {
                u1.set_to_no_active_member();
                TestDynAny.TEST("set_to_no_active_member() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc = u1.get_discriminator();
            e = DynEnumHelper.narrow((Object)disc);
            e.set_as_string("blue");
            u1.insert_char('Z');
            Any av = u1.to_any();
            TestUnion3 ptu3 = TestUnion3Helper.extract(av);
            TestDynAny.TEST(ptu3.discriminator() == TestEnum.blue);
            TestDynAny.TEST(ptu3.c() == 'Z');
            tu3.b(1.99);
            TestUnion3Helper.insert(any, tu3);
            DynAny d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            str = u1.member_name();
            TestDynAny.TEST(str.equals("b"));
            u1.seek(1);
            TestDynAny.TEST(u1.get_double() >= 1.99);
            d2.destroy();
            d1.destroy();
            TestDynAny.testOps(orb, factory, type, true);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testUnion4(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestUnion4 tu4 = new TestUnion4();
            TypeCode type = TestUnion4Helper.type();
            TypeCode discType = orb.get_primitive_tc(TCKind.tk_short);
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynUnion u1 = DynUnionHelper.narrow((Object)d1);
            TestDynAny.TEST(u1.discriminator_kind() == TCKind.tk_short);
            String str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            DynAny disc = u1.get_discriminator();
            TestDynAny.TEST(u1.component_count() == 2);
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)99);
            u1.set_discriminator(disc);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("b"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_float);
            TestDynAny.TEST(u1.component_count() == 2);
            disc.destroy();
            disc = u1.get_discriminator();
            disc.insert_short((short)33);
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            TestDynAny.TEST(u1.member_kind() == TCKind.tk_long);
            TestDynAny.TEST(u1.component_count() == 2);
            u1.insert_long(444);
            disc.insert_short((short)66);
            TestDynAny.TEST(u1.get_long() == 444);
            DynAny copy = u1.copy();
            TestDynAny.TEST(u1.equal(copy));
            copy.destroy();
            TestDynAny.TEST(!u1.has_no_active_member());
            disc = factory.create_dyn_any_from_type_code(orb.get_primitive_tc(TCKind.tk_ushort));
            disc.insert_ushort((short)55);
            try {
                u1.set_discriminator(disc);
                TestDynAny.TEST("set_discriminator() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            disc.destroy();
            disc = u1.get_discriminator();
            disc.insert_short((short)99);
            u1.set_to_default_member();
            str = u1.member_name();
            TestDynAny.TEST(str.equals("a"));
            disc = factory.create_dyn_any_from_type_code(discType);
            disc.insert_short((short)99);
            u1.set_discriminator(disc);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)0);
            u1.set_discriminator(disc);
            TestDynAny.TEST(u1.is_set_to_default_member());
            disc.destroy();
            disc = u1.get_discriminator();
            disc.insert_short((short)99);
            TestDynAny.TEST(!u1.is_set_to_default_member());
            disc.insert_short((short)0);
            TestDynAny.TEST(u1.is_set_to_default_member());
            try {
                u1.set_to_no_active_member();
                TestDynAny.TEST("set_to_no_active_member() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            u1.set_to_default_member();
            u1.next();
            u1.insert_long(888);
            Any av = u1.to_any();
            TestUnion4 ptu4 = TestUnion4Helper.extract(av);
            TestDynAny.TEST(ptu4.a() == 888);
            tu4.b(1.99f);
            TestUnion4Helper.insert(any, tu4);
            DynAny d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            str = u1.member_name();
            TestDynAny.TEST(str.equals("b"));
            u1.seek(1);
            TestDynAny.TEST(u1.get_float() >= 1.99f);
            d2.destroy();
            d1.destroy();
            TestDynAny.testOps(orb, factory, type, true);
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testShortSeq(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            int i;
            Any any = orb.create_any();
            TypeCode type = TestShortSeqHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynSequence s1 = DynSequenceHelper.narrow((Object)d1);
            TestDynAny.TEST(s1.get_length() == 0);
            TestDynAny.TEST(s1.component_count() == 0);
            s1.set_length(5);
            TestDynAny.TEST(s1.get_length() == 5);
            TestDynAny.TEST(s1.component_count() == 5);
            for (i = 0; i < 5; ++i) {
                s1.insert_short((short)i);
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 5; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)i);
                s1.next();
            }
            s1.seek(1);
            s1.set_length(3);
            TestDynAny.TEST(s1.get_short() == 1);
            TestDynAny.TEST(s1.get_length() == 3);
            TestDynAny.TEST(s1.component_count() == 3);
            s1.rewind();
            for (i = 0; i < 3; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)i);
                s1.next();
            }
            Any av = s1.to_any();
            short[] pseq = TestShortSeqHelper.extract(av);
            TestDynAny.TEST(pseq.length == 3);
            for (i = 0; i < 3; ++i) {
                TestDynAny.TEST(pseq[i] == (short)i);
            }
            DynAny copy = s1.copy();
            TestDynAny.TEST(s1.equal(copy));
            copy.destroy();
            copy = s1.copy();
            copy.seek(1);
            copy.insert_short((short)-33);
            TestDynAny.TEST(!s1.equal(copy));
            copy.destroy();
            short[] seq = new short[8];
            for (i = 0; i < 8; ++i) {
                seq[i] = (short)(8 - i);
            }
            TestShortSeqHelper.insert(any, seq);
            s1.from_any(any);
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)(8 - i));
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                DynAny comp = s1.current_component();
                TestDynAny.TEST(comp.get_short() == (short)(8 - i));
                comp.insert_short((short)i);
                TestDynAny.TEST(s1.get_short() == (short)i);
                s1.next();
            }
            Any[] anySeq = s1.get_elements();
            TestDynAny.TEST(anySeq.length == 8);
            for (i = 0; i < 8; ++i) {
                short n = anySeq[i].extract_short();
                TestDynAny.TEST(n == (short)i);
            }
            anySeq = new Any[3];
            for (i = 0; i < 3; ++i) {
                anySeq[i] = orb.create_any();
                anySeq[i].insert_short((short)(i + 10));
            }
            s1.set_elements(anySeq);
            s1.rewind();
            for (i = 0; i < 3; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)(i + 10));
                s1.next();
            }
            DynAny[] dynAnySeq = s1.get_elements_as_dyn_any();
            TestDynAny.TEST(dynAnySeq.length == 3);
            for (i = 0; i < 3; ++i) {
                TestDynAny.TEST(dynAnySeq[i].get_short() == (short)(i + 10));
            }
            dynAnySeq = new DynAny[4];
            for (i = 0; i < 4; ++i) {
                any.insert_short((short)(i + 100));
                dynAnySeq[i] = factory.create_dyn_any(any);
            }
            s1.set_elements_as_dyn_any(dynAnySeq);
            s1.rewind();
            for (i = 0; i < 4; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)(i + 100));
                s1.next();
            }
            for (i = 0; i < 4; ++i) {
                dynAnySeq[i].destroy();
            }
            seq = new short[10];
            for (i = 0; i < 10; ++i) {
                seq[i] = (short)(i * 10);
            }
            TestShortSeqHelper.insert(any, seq);
            DynAny d2 = factory.create_dyn_any(any);
            DynSequence s2 = DynSequenceHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(s1.get_length() == 10);
            TestDynAny.TEST(s1.component_count() == 10);
            s1.rewind();
            for (i = 0; i < 10; ++i) {
                TestDynAny.TEST(s1.get_short() == (short)(i * 10));
                s1.next();
            }
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testBoundedString10Seq(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            String s2;
            String s3;
            String s4;
            String str;
            int i;
            Any any = orb.create_any();
            TypeCode type = TestBoundedString10SeqHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynSequence s1 = DynSequenceHelper.narrow((Object)d1);
            TestDynAny.TEST(s1.get_length() == 0);
            TestDynAny.TEST(s1.component_count() == 0);
            s1.set_length(5);
            TestDynAny.TEST(s1.get_length() == 5);
            TestDynAny.TEST(s1.component_count() == 5);
            for (i = 0; i < 5; ++i) {
                str = s1.get_string();
                TestDynAny.TEST(str.length() == 0);
                str = str + "str ";
                str = str + i;
                s1.insert_string(str);
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 5; ++i) {
                str = s1.get_string();
                s4 = "str " + i;
                TestDynAny.TEST(str.equals(s4));
                s1.next();
            }
            s1.seek(1);
            s1.set_length(3);
            str = s1.get_string();
            TestDynAny.TEST(str.equals("str 1"));
            TestDynAny.TEST(s1.get_length() == 3);
            TestDynAny.TEST(s1.component_count() == 3);
            Any av = s1.to_any();
            String[] pseq = TestBoundedString10SeqHelper.extract(av);
            TestDynAny.TEST(pseq.length == 3);
            for (i = 0; i < 3; ++i) {
                s4 = "str " + i;
                TestDynAny.TEST(pseq[i].equals(s4));
            }
            DynAny copy = s1.copy();
            TestDynAny.TEST(s1.equal(copy));
            copy.destroy();
            copy = s1.copy();
            copy.seek(1);
            copy.insert_string("hi there");
            TestDynAny.TEST(!s1.equal(copy));
            copy.destroy();
            String[] seq = new String[8];
            for (i = 0; i < 8; ++i) {
                seq[i] = "STR " + i;
            }
            TestBoundedString10SeqHelper.insert(any, seq);
            s1.from_any(any);
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                str = s1.get_string();
                s4 = "STR " + i;
                TestDynAny.TEST(str.equals(s4));
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                DynAny comp = s1.current_component();
                str = comp.get_string();
                s4 = "STR " + i;
                TestDynAny.TEST(str.equals(s4));
                s4 = "string " + i;
                comp.insert_string(s4);
                str = s1.get_string();
                TestDynAny.TEST(str.equals(s4));
                s1.next();
            }
            Any[] anySeq = s1.get_elements();
            TestDynAny.TEST(anySeq.length == 8);
            for (i = 0; i < 8; ++i) {
                String cp = anySeq[i].extract_string();
                s3 = "string " + i;
                TestDynAny.TEST(cp.equals(s3));
            }
            anySeq = new Any[3];
            for (i = 0; i < 3; ++i) {
                s2 = "String " + i;
                anySeq[i] = orb.create_any();
                TestBoundedStringHelper.insert(anySeq[i], s2);
            }
            s1.set_elements(anySeq);
            s1.rewind();
            for (i = 0; i < 3; ++i) {
                str = s1.get_string();
                s2 = "String " + i;
                TestDynAny.TEST(str.equals(s2));
                s1.next();
            }
            DynAny[] dynAnySeq = s1.get_elements_as_dyn_any();
            TestDynAny.TEST(dynAnySeq.length == 3);
            for (i = 0; i < 3; ++i) {
                str = dynAnySeq[i].get_string();
                s3 = "String " + i;
                TestDynAny.TEST(str.equals(s3));
            }
            dynAnySeq = new DynAny[4];
            for (i = 0; i < 4; ++i) {
                s3 = "STRING " + i;
                TestBoundedStringHelper.insert(any, s3);
                dynAnySeq[i] = factory.create_dyn_any(any);
            }
            s1.set_elements_as_dyn_any(dynAnySeq);
            s1.rewind();
            for (i = 0; i < 4; ++i) {
                str = s1.get_string();
                s3 = "STRING " + i;
                TestDynAny.TEST(str.equals(s3));
                s1.next();
            }
            for (i = 0; i < 4; ++i) {
                dynAnySeq[i].destroy();
            }
            seq = new String[10];
            for (i = 0; i < 10; ++i) {
                seq[i] = "Str " + i;
            }
            TestBoundedString10SeqHelper.insert(any, seq);
            DynAny d2 = factory.create_dyn_any(any);
            DynSequence s22 = DynSequenceHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(s1.get_length() == 10);
            TestDynAny.TEST(s1.component_count() == 10);
            s1.rewind();
            for (i = 0; i < 10; ++i) {
                str = s1.get_string();
                s3 = "Str " + i;
                TestDynAny.TEST(str.equals(s3));
                s1.next();
            }
            i = s1.component_count();
            try {
                s1.set_length(11);
                TestDynAny.TEST("set_length() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            TestDynAny.TEST(s1.component_count() == i);
            anySeq = new Any[5];
            for (i = 0; i < 5; ++i) {
                s3 = "String " + i;
                anySeq[i] = orb.create_any();
                anySeq[i].insert_string(s3);
            }
            try {
                s1.set_elements(anySeq);
                TestDynAny.TEST("set_elements() should not have succeeded" == null);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testAnySeq(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            short s2;
            Any av;
            int i;
            Any any = orb.create_any();
            TypeCode type = TestAnySeqHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynSequence s1 = DynSequenceHelper.narrow((Object)d1);
            TestDynAny.TEST(s1.get_length() == 0);
            TestDynAny.TEST(s1.component_count() == 0);
            s1.set_length(5);
            TestDynAny.TEST(s1.get_length() == 5);
            TestDynAny.TEST(s1.component_count() == 5);
            for (i = 0; i < 5; ++i) {
                any.insert_short((short)i);
                s1.insert_any(any);
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 5; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)i);
                s1.next();
            }
            s1.seek(1);
            s1.set_length(3);
            av = s1.get_any();
            s2 = av.extract_short();
            TestDynAny.TEST(s2 == 1);
            TestDynAny.TEST(s1.get_length() == 3);
            TestDynAny.TEST(s1.component_count() == 3);
            s1.rewind();
            for (i = 0; i < 3; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)i);
                s1.next();
            }
            av = s1.to_any();
            Any[] pseq = TestAnySeqHelper.extract(av);
            TestDynAny.TEST(pseq.length == 3);
            for (i = 0; i < 3; ++i) {
                s2 = pseq[i].extract_short();
                TestDynAny.TEST(s2 == (short)i);
            }
            DynAny copy = s1.copy();
            TestDynAny.TEST(s1.equal(copy));
            copy.destroy();
            copy = s1.copy();
            copy.seek(1);
            any.insert_short((short)-33);
            copy.insert_any(any);
            TestDynAny.TEST(!s1.equal(copy));
            copy.destroy();
            Any[] seq = new Any[8];
            for (i = 0; i < 8; ++i) {
                seq[i] = orb.create_any();
                seq[i].insert_short((short)(8 - i));
            }
            TestAnySeqHelper.insert(any, seq);
            s1.from_any(any);
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(8 - i));
                s1.next();
            }
            s1.rewind();
            for (i = 0; i < 8; ++i) {
                DynAny comp = s1.current_component();
                av = comp.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(8 - i));
                any.insert_short((short)i);
                comp.insert_any(any);
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)i);
                s1.next();
            }
            Any[] anySeq = s1.get_elements();
            TestDynAny.TEST(anySeq.length == 8);
            for (i = 0; i < 8; ++i) {
                Any p = anySeq[i].extract_any();
                s2 = p.extract_short();
                TestDynAny.TEST(s2 == (short)i);
            }
            anySeq = new Any[3];
            for (i = 0; i < 3; ++i) {
                Any anyVal = orb.create_any();
                anyVal.insert_short((short)(i + 10));
                anySeq[i] = orb.create_any();
                anySeq[i].insert_any(anyVal);
            }
            s1.set_elements(anySeq);
            s1.rewind();
            for (i = 0; i < 3; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(i + 10));
                s1.next();
            }
            DynAny[] dynAnySeq = s1.get_elements_as_dyn_any();
            TestDynAny.TEST(dynAnySeq.length == 3);
            for (i = 0; i < 3; ++i) {
                av = dynAnySeq[i].get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(i + 10));
            }
            dynAnySeq = new DynAny[4];
            for (i = 0; i < 4; ++i) {
                Any anyVal = orb.create_any();
                anyVal.insert_short((short)(i + 100));
                any.insert_any(anyVal);
                dynAnySeq[i] = factory.create_dyn_any(any);
            }
            s1.set_elements_as_dyn_any(dynAnySeq);
            s1.rewind();
            for (i = 0; i < 4; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(i + 100));
                s1.next();
            }
            for (i = 0; i < 4; ++i) {
                dynAnySeq[i].destroy();
            }
            seq = new Any[10];
            for (i = 0; i < 10; ++i) {
                seq[i] = orb.create_any();
                seq[i].insert_short((short)(i * 10));
            }
            TestAnySeqHelper.insert(any, seq);
            DynAny d2 = factory.create_dyn_any(any);
            DynSequence s22 = DynSequenceHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(s1.get_length() == 10);
            TestDynAny.TEST(s1.component_count() == 10);
            s1.rewind();
            for (i = 0; i < 10; ++i) {
                av = s1.get_any();
                s2 = av.extract_short();
                TestDynAny.TEST(s2 == (short)(i * 10));
                s1.next();
            }
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testStringArray(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            String s2;
            String s3;
            String s4;
            String str;
            int i;
            Any any = orb.create_any();
            TypeCode type = TestStringArrayHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynArray a1 = DynArrayHelper.narrow((Object)d1);
            TestDynAny.TEST(a1.component_count() == 10);
            for (i = 0; i < 10; ++i) {
                str = a1.get_string();
                TestDynAny.TEST(str.length() == 0);
                s4 = "str " + i;
                a1.insert_string(s4);
                a1.next();
            }
            Any av = a1.to_any();
            String[] arr = TestStringArrayHelper.extract(av);
            for (i = 0; i < 10; ++i) {
                s4 = "str " + i;
                TestDynAny.TEST(arr[i].equals(s4));
            }
            DynAny copy = a1.copy();
            TestDynAny.TEST(a1.equal(copy));
            copy.destroy();
            copy = a1.copy();
            copy.seek(1);
            copy.insert_string("hi there");
            TestDynAny.TEST(!a1.equal(copy));
            copy.destroy();
            for (i = 0; i < 10; ++i) {
                arr[i] = "STR " + i;
            }
            TestStringArrayHelper.insert(any, arr);
            a1.from_any(any);
            a1.rewind();
            for (i = 0; i < 10; ++i) {
                str = a1.get_string();
                s4 = "STR " + i;
                TestDynAny.TEST(str.equals(s4));
                a1.next();
            }
            a1.rewind();
            for (i = 0; i < 10; ++i) {
                DynAny comp = a1.current_component();
                str = comp.get_string();
                s4 = "STR " + i;
                TestDynAny.TEST(str.equals(s4));
                s4 = "string " + i;
                comp.insert_string(s4);
                str = a1.get_string();
                TestDynAny.TEST(str.equals(s4));
                a1.next();
            }
            Any[] anySeq = a1.get_elements();
            TestDynAny.TEST(anySeq.length == 10);
            for (i = 0; i < 10; ++i) {
                String cp = anySeq[i].extract_string();
                s3 = "string " + i;
                TestDynAny.TEST(cp.equals(s3));
            }
            for (i = 0; i < 10; ++i) {
                s2 = "String " + i;
                anySeq[i].insert_string(s2);
            }
            a1.set_elements(anySeq);
            a1.rewind();
            for (i = 0; i < 10; ++i) {
                str = a1.get_string();
                s2 = "String " + i;
                TestDynAny.TEST(str.equals(s2));
                a1.next();
            }
            DynAny[] dynAnySeq = a1.get_elements_as_dyn_any();
            TestDynAny.TEST(dynAnySeq.length == 10);
            for (i = 0; i < 10; ++i) {
                str = dynAnySeq[i].get_string();
                s3 = "String " + i;
                TestDynAny.TEST(str.equals(s3));
            }
            dynAnySeq = new DynAny[10];
            for (i = 0; i < 10; ++i) {
                s3 = "STRING " + i;
                any.insert_string(s3);
                dynAnySeq[i] = factory.create_dyn_any(any);
            }
            a1.set_elements_as_dyn_any(dynAnySeq);
            a1.rewind();
            for (i = 0; i < 10; ++i) {
                str = a1.get_string();
                s3 = "STRING " + i;
                TestDynAny.TEST(str.equals(s3));
                a1.next();
            }
            for (i = 0; i < 10; ++i) {
                dynAnySeq[i].destroy();
            }
            for (i = 0; i < 10; ++i) {
                arr[i] = "Str " + i;
            }
            TestStringArrayHelper.insert(any, arr);
            DynAny d2 = factory.create_dyn_any(any);
            DynArray a2 = DynArrayHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(a1.component_count() == 10);
            a1.rewind();
            for (i = 0; i < 10; ++i) {
                str = a1.get_string();
                s3 = "Str " + i;
                TestDynAny.TEST(str.equals(s3));
                a1.next();
            }
            try {
                anySeq = new Any[4];
                for (i = 0; i < 4; ++i) {
                    s3 = "String " + i;
                    anySeq[i] = orb.create_any();
                    anySeq[i].insert_string(s3);
                }
                a1.set_elements(anySeq);
                TestDynAny.TEST("set_elements() should not have succeeded" == null);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            TestDynAny.TEST(a1.component_count() == 10);
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testStructBox(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestStruct ts = new TestStruct();
            TypeCode type = TestStructBoxHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValueBox v1 = DynValueBoxHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            TestDynAny.TEST(v1.current_component() == null);
            Any av = d1.to_any();
            TestStruct pts = TestStructBoxHelper.extract(av);
            TestDynAny.TEST(pts == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestStructBoxHelper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestStructBoxHelper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            try {
                v1.get_boxed_value();
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                v1.get_boxed_value_as_dyn_any();
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                any.insert_string("hi");
                v1.set_boxed_value(any);
                TestDynAny.TEST(false);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            try {
                any.type(TestStructHelper.type());
                v1.set_boxed_value(any);
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                any.insert_long(123);
                d2 = factory.create_dyn_any(any);
                v1.set_boxed_value_as_dyn_any(d2);
                TestDynAny.TEST(false);
            }
            catch (TypeMismatch ex) {
                d2.destroy();
            }
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 1);
            DynAny comp = v1.current_component();
            DynStruct ds = DynStructHelper.narrow((Object)comp);
            TestDynAny.loadStruct(orb, ts);
            TestStructHelper.insert(any, ts);
            ds.from_any(any);
            av = d1.to_any();
            pts = TestStructBoxHelper.extract(av);
            TestDynAny.checkStruct(pts);
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestStruct tsbv = new TestStruct();
            TestDynAny.loadStruct(orb, tsbv);
            TestStructBoxHelper.insert(any, tsbv);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            av = v1.get_boxed_value();
            pts = TestStructHelper.extract(av);
            TestDynAny.checkStruct(pts);
            ts.shortVal = (short)-99;
            TestStructHelper.insert(any, ts);
            copy = v1.copy();
            v1.set_boxed_value(any);
            TestDynAny.TEST(!v1.equal(copy));
            copy.destroy();
            d2 = v1.get_boxed_value_as_dyn_any();
            ds = DynStructHelper.narrow((Object)d2);
            TestStructHelper.insert(any, ts);
            d2 = factory.create_dyn_any(any);
            v1.set_boxed_value_as_dyn_any(d2);
            d2.destroy();
            ts.longVal = -99;
            TestStructBoxHelper.insert(any, ts);
            d2 = factory.create_dyn_any(any);
            DynValueBox v2 = DynValueBoxHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 1);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            ts.shortVal = (short)-99;
            TestStructHelper.insert(any, ts);
            v1.set_boxed_value(any);
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.current_component() != null);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            TestStructHelper.insert(any, ts);
            d2 = factory.create_dyn_any(any);
            v1.set_boxed_value_as_dyn_any(d2);
            d2.destroy();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.current_component() != null);
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(0);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testStringBox(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestStringBoxHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValueBox v1 = DynValueBoxHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            TestDynAny.TEST(v1.current_component() == null);
            Any av = d1.to_any();
            String str = TestStringBoxHelper.extract(av);
            TestDynAny.TEST(str == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestStringBoxHelper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestStringBoxHelper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            try {
                v1.get_boxed_value();
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                v1.get_boxed_value_as_dyn_any();
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                any.insert_boolean(false);
                v1.set_boxed_value(any);
                TestDynAny.TEST(false);
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            try {
                any.type(orb.get_primitive_tc(TCKind.tk_string));
                v1.set_boxed_value(any);
                TestDynAny.TEST(false);
            }
            catch (InvalidValue ex) {
                // empty catch block
            }
            try {
                any.insert_long(123);
                d2 = factory.create_dyn_any(any);
                v1.set_boxed_value_as_dyn_any(d2);
                TestDynAny.TEST(false);
            }
            catch (TypeMismatch ex) {
                d2.destroy();
            }
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 1);
            DynAny comp = v1.current_component();
            str = comp.get_string();
            TestDynAny.TEST(str.length() == 0);
            any.insert_string("hi");
            comp.from_any(any);
            av = d1.to_any();
            str = TestStringBoxHelper.extract(av);
            TestDynAny.TEST(str.equals("hi"));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestStringBoxHelper.insert(any, "hi");
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            av = v1.get_boxed_value();
            TestDynAny.TEST(av.extract_string().equals("hi"));
            any.insert_string("bye");
            copy = v1.copy();
            v1.set_boxed_value(any);
            TestDynAny.TEST(!v1.equal(copy));
            copy.destroy();
            d2 = v1.get_boxed_value_as_dyn_any();
            TestDynAny.TEST(d2.get_string().equals("bye"));
            any.insert_string("foo");
            d2 = factory.create_dyn_any(any);
            v1.set_boxed_value_as_dyn_any(d2);
            d2.destroy();
            TestStringBoxHelper.insert(any, "bar");
            d2 = factory.create_dyn_any(any);
            DynValueBox v2 = DynValueBoxHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 1);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            any.insert_string("foo");
            v1.set_boxed_value(any);
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.current_component() != null);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            any.insert_string("bar");
            d2 = factory.create_dyn_any(any);
            v1.set_boxed_value_as_dyn_any(d2);
            d2.destroy();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.current_component() != null);
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(0);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testValue1(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestValue1Helper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValue v1 = DynValueHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            Any av = d1.to_any();
            TestValue1 ptv1 = TestValue1Helper.extract(av);
            TestDynAny.TEST(ptv1 == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue1Helper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestValue1Helper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            try {
                DynAny comp = v1.current_component();
            }
            catch (TypeMismatch ex) {
                // empty catch block
            }
            av = d1.to_any();
            ptv1 = TestValue1Helper.extract(av);
            TestDynAny.TEST(ptv1 != null);
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue1_impl tv1v = new TestValue1_impl();
            TestValue1Helper.insert(any, tv1v);
            d2 = factory.create_dyn_any(any);
            DynValue v2 = DynValueHelper.narrow((Object)d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            NameValuePair[] nvpSeq = v1.get_members();
            TestDynAny.TEST(nvpSeq.length == 0);
            v1.set_members(nvpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members(nvpSeq);
            TestDynAny.TEST(!v1.is_null());
            NameDynAnyPair[] ndpSeq = v1.get_members_as_dyn_any();
            TestDynAny.TEST(ndpSeq.length == 0);
            ndpSeq = new NameDynAnyPair[]{};
            v1.set_members_as_dyn_any(ndpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members_as_dyn_any(ndpSeq);
            TestDynAny.TEST(!v1.is_null());
            tv1v = new TestValue1_impl();
            TestValue1Helper.insert(any, tv1v);
            d2 = factory.create_dyn_any(any);
            v2 = DynValueHelper.narrow((Object)d2);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 0);
            TestDynAny.TEST(!d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            d1.seek(-1);
            TestDynAny.TEST(!d1.next());
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testValue2(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestValue2Helper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValue v1 = DynValueHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            Any av = d1.to_any();
            TestValue2 ptv2 = TestValue2Helper.extract(av);
            TestDynAny.TEST(ptv2 == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue2Helper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestValue2Helper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 3);
            v1.insert_short((short)-55);
            v1.next();
            v1.insert_long(333);
            v1.next();
            v1.insert_string("hi there");
            av = d1.to_any();
            ptv2 = TestValue2Helper.extract(av);
            TestDynAny.TEST(ptv2.shortVal == -55);
            TestDynAny.TEST(ptv2.longVal == 333);
            TestDynAny.TEST(ptv2.stringVal.equals("hi there"));
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue2_impl tv2v = new TestValue2_impl();
            tv2v.shortVal = (short)-55;
            tv2v.longVal = 333;
            tv2v.stringVal = "hi there";
            TestValue2Helper.insert(any, tv2v);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            NameValuePair[] nvpSeq = v1.get_members();
            TestDynAny.TEST(nvpSeq.length == 3);
            short shortVal = nvpSeq[0].value.extract_short();
            TestDynAny.TEST(shortVal == -55);
            int longVal = nvpSeq[1].value.extract_long();
            TestDynAny.TEST(longVal == 333);
            String cp = nvpSeq[2].value.extract_string();
            TestDynAny.TEST(cp.equals("hi there"));
            nvpSeq[0].value.insert_short((short)237);
            nvpSeq[1].value.insert_long(680580);
            nvpSeq[2].value.insert_string("ho there");
            v1.set_members(nvpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members(nvpSeq);
            TestDynAny.TEST(!v1.is_null());
            NameDynAnyPair[] ndpSeq = v1.get_members_as_dyn_any();
            TestDynAny.TEST(ndpSeq.length == 3);
            TestDynAny.TEST(ndpSeq[0].value.get_short() == 237);
            TestDynAny.TEST(ndpSeq[1].value.get_long() == 680580);
            String str = ndpSeq[2].value.get_string();
            TestDynAny.TEST(str.equals("ho there"));
            ndpSeq = new NameDynAnyPair[3];
            ndpSeq[0] = new NameDynAnyPair();
            ndpSeq[0].id = "shortVal";
            any.insert_short((short)880);
            ndpSeq[0].value = factory.create_dyn_any(any);
            ndpSeq[1] = new NameDynAnyPair();
            ndpSeq[1].id = "longVal";
            any.insert_long(280101);
            ndpSeq[1].value = factory.create_dyn_any(any);
            ndpSeq[2] = new NameDynAnyPair();
            ndpSeq[2].id = "stringVal";
            any.insert_string("you there");
            ndpSeq[2].value = factory.create_dyn_any(any);
            v1.set_members_as_dyn_any(ndpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members_as_dyn_any(ndpSeq);
            TestDynAny.TEST(!v1.is_null());
            tv2v = new TestValue2_impl();
            tv2v.shortVal = (short)880;
            tv2v.longVal = 280101;
            tv2v.stringVal = "you there";
            TestValue2Helper.insert(any, tv2v);
            d2 = factory.create_dyn_any(any);
            DynValue v2 = DynValueHelper.narrow((Object)d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.insert_short((short)980);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 3);
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testValue3(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TestUnion4 tu4 = new TestUnion4();
            TypeCode type = TestValue3Helper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValue v1 = DynValueHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            Any av = d1.to_any();
            TestValue3 ptv3 = TestValue3Helper.extract(av);
            TestDynAny.TEST(ptv3 == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue3Helper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestValue3Helper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 4);
            v1.insert_short((short)-55);
            v1.next();
            v1.insert_long(333);
            v1.next();
            v1.insert_string("hi there");
            v1.next();
            DynAny comp = v1.current_component();
            DynUnion u = DynUnionHelper.narrow((Object)comp);
            u.insert_short((short)0);
            u.next();
            u.insert_long(333);
            av = d1.to_any();
            ptv3 = TestValue3Helper.extract(av);
            TestDynAny.TEST(ptv3.shortVal == -55);
            TestDynAny.TEST(ptv3.longVal == 333);
            TestDynAny.TEST(ptv3.stringVal.equals("hi there"));
            TestDynAny.TEST(ptv3.unionVal.discriminator() == 0);
            TestDynAny.TEST(ptv3.unionVal.a() == 333);
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue3_impl tv3v = new TestValue3_impl();
            tv3v.shortVal = (short)-55;
            tv3v.longVal = 333;
            tv3v.stringVal = "hi there";
            tv3v.unionVal = new TestUnion4();
            tv3v.unionVal.a((short)0, 333);
            TestValue3Helper.insert(any, tv3v);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            NameValuePair[] nvpSeq = v1.get_members();
            TestDynAny.TEST(nvpSeq.length == 4);
            short shortVal = nvpSeq[0].value.extract_short();
            TestDynAny.TEST(shortVal == -55);
            long longVal = nvpSeq[1].value.extract_long();
            TestDynAny.TEST(longVal == 333L);
            String cp = nvpSeq[2].value.extract_string();
            TestDynAny.TEST(cp.equals("hi there"));
            TestUnion4 ptu4 = TestUnion4Helper.extract(nvpSeq[3].value);
            TestDynAny.TEST(ptu4.a() == 333);
            nvpSeq[0].value.insert_short((short)237);
            nvpSeq[1].value.insert_long(680580);
            nvpSeq[2].value.insert_string("ho there");
            tu4.b(1.99f);
            TestUnion4Helper.insert(nvpSeq[3].value, tu4);
            v1.set_members(nvpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members(nvpSeq);
            TestDynAny.TEST(!v1.is_null());
            NameDynAnyPair[] ndpSeq = v1.get_members_as_dyn_any();
            TestDynAny.TEST(ndpSeq.length == 4);
            TestDynAny.TEST(ndpSeq[0].value.get_short() == 237);
            TestDynAny.TEST(ndpSeq[1].value.get_long() == 680580);
            String str = ndpSeq[2].value.get_string();
            TestDynAny.TEST(str.equals("ho there"));
            ndpSeq[3].value.seek(1);
            TestDynAny.TEST(ndpSeq[3].value.get_float() < 2.0f);
            ndpSeq = new NameDynAnyPair[4];
            ndpSeq[0] = new NameDynAnyPair();
            ndpSeq[0].id = "shortVal";
            any.insert_short((short)880);
            ndpSeq[0].value = factory.create_dyn_any(any);
            ndpSeq[1] = new NameDynAnyPair();
            ndpSeq[1].id = "longVal";
            any.insert_long(280101);
            ndpSeq[1].value = factory.create_dyn_any(any);
            ndpSeq[2] = new NameDynAnyPair();
            ndpSeq[2].id = "stringVal";
            any.insert_string("you there");
            ndpSeq[2].value = factory.create_dyn_any(any);
            ndpSeq[3] = new NameDynAnyPair();
            ndpSeq[3].id = "unionVal";
            tu4.a(123456);
            TestUnion4Helper.insert(any, tu4);
            ndpSeq[3].value = factory.create_dyn_any(any);
            v1.set_members_as_dyn_any(ndpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members_as_dyn_any(ndpSeq);
            TestDynAny.TEST(!v1.is_null());
            tv3v = new TestValue3_impl();
            tv3v.shortVal = (short)880;
            tv3v.longVal = 280101;
            tv3v.stringVal = "you there";
            tv3v.unionVal = new TestUnion4();
            tv3v.unionVal.a(123456);
            TestValue3Helper.insert(any, tv3v);
            d2 = factory.create_dyn_any(any);
            DynValue v2 = DynValueHelper.narrow((Object)d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.insert_short((short)980);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 4);
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testValue4(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestValue4Helper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            DynValue v1 = DynValueHelper.narrow((Object)d1);
            TestDynAny.TEST(v1.is_null());
            TestDynAny.TEST(v1.component_count() == 0);
            Any av = d1.to_any();
            TestValue4 ptv4 = TestValue4Helper.extract(av);
            TestDynAny.TEST(ptv4 == null);
            DynAny copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue4Helper.insert(any, null);
            DynAny d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestValue4Helper.insert(any, null);
            d2 = factory.create_dyn_any(any);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.is_null());
            v1.set_to_value();
            TestDynAny.TEST(!v1.is_null());
            TestDynAny.TEST(v1.component_count() == 5);
            v1.insert_short((short)-55);
            v1.next();
            v1.insert_long(333);
            v1.next();
            v1.insert_string("hi there");
            v1.next();
            v1.insert_char('A');
            v1.next();
            v1.insert_longlong(7890123L);
            av = d1.to_any();
            ptv4 = TestValue4Helper.extract(av);
            TestDynAny.TEST(ptv4.shortVal == -55);
            TestDynAny.TEST(ptv4.longVal == 333);
            TestDynAny.TEST(ptv4.stringVal.equals("hi there"));
            TestDynAny.TEST(ptv4.charVal == 'A');
            TestDynAny.TEST(ptv4.longlongVal == 7890123L);
            copy = d1.copy();
            TestDynAny.TEST(d1.equal(copy));
            copy.destroy();
            TestValue4_impl tv4v = new TestValue4_impl();
            tv4v.shortVal = (short)-55;
            tv4v.longVal = 333;
            tv4v.stringVal = "hi there";
            tv4v.charVal = (char)65;
            tv4v.longlongVal = 7890123L;
            TestValue4Helper.insert(any, tv4v);
            d2 = factory.create_dyn_any(any);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            NameValuePair[] nvpSeq = v1.get_members();
            TestDynAny.TEST(nvpSeq.length == 5);
            short shortVal = nvpSeq[0].value.extract_short();
            TestDynAny.TEST(shortVal == -55);
            int longVal = nvpSeq[1].value.extract_long();
            TestDynAny.TEST(longVal == 333);
            String cp = nvpSeq[2].value.extract_string();
            TestDynAny.TEST(cp.equals("hi there"));
            char charVal = nvpSeq[3].value.extract_char();
            TestDynAny.TEST(charVal == 'A');
            long longlongVal = nvpSeq[4].value.extract_longlong();
            TestDynAny.TEST(longlongVal == 7890123L);
            nvpSeq[0].value.insert_short((short)237);
            nvpSeq[1].value.insert_long(680580);
            nvpSeq[2].value.insert_string("ho there");
            nvpSeq[3].value.insert_char('Z');
            nvpSeq[4].value.insert_longlong(1237890L);
            v1.set_members(nvpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members(nvpSeq);
            TestDynAny.TEST(!v1.is_null());
            NameDynAnyPair[] ndpSeq = v1.get_members_as_dyn_any();
            TestDynAny.TEST(ndpSeq.length == 5);
            TestDynAny.TEST(ndpSeq[0].value.get_short() == 237);
            TestDynAny.TEST(ndpSeq[1].value.get_long() == 680580);
            String str = ndpSeq[2].value.get_string();
            TestDynAny.TEST(str.equals("ho there"));
            TestDynAny.TEST(ndpSeq[3].value.get_char() == 'Z');
            TestDynAny.TEST(ndpSeq[4].value.get_longlong() == 1237890L);
            ndpSeq = new NameDynAnyPair[5];
            ndpSeq[0] = new NameDynAnyPair();
            ndpSeq[0].id = "shortVal";
            any.insert_short((short)880);
            ndpSeq[0].value = factory.create_dyn_any(any);
            ndpSeq[1] = new NameDynAnyPair();
            ndpSeq[1].id = "longVal";
            any.insert_long(280101);
            ndpSeq[1].value = factory.create_dyn_any(any);
            ndpSeq[2] = new NameDynAnyPair();
            ndpSeq[2].id = "stringVal";
            any.insert_string("you there");
            ndpSeq[2].value = factory.create_dyn_any(any);
            ndpSeq[3] = new NameDynAnyPair();
            ndpSeq[3].id = "charVal";
            any.insert_char('!');
            ndpSeq[3].value = factory.create_dyn_any(any);
            ndpSeq[4] = new NameDynAnyPair();
            ndpSeq[4].id = "longlongVal";
            any.insert_longlong(44556677L);
            ndpSeq[4].value = factory.create_dyn_any(any);
            v1.set_members_as_dyn_any(ndpSeq);
            v1.set_to_null();
            TestDynAny.TEST(v1.is_null());
            v1.set_members_as_dyn_any(ndpSeq);
            TestDynAny.TEST(!v1.is_null());
            tv4v = new TestValue4_impl();
            tv4v.shortVal = (short)880;
            tv4v.longVal = 280101;
            tv4v.stringVal = "you there";
            tv4v.charVal = (char)33;
            tv4v.longlongVal = 44556677L;
            TestValue4Helper.insert(any, tv4v);
            d2 = factory.create_dyn_any(any);
            DynValue v2 = DynValueHelper.narrow((Object)d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.insert_short((short)980);
            d1.assign(d2);
            TestDynAny.TEST(d1.equal(d2));
            d2.destroy();
            TestDynAny.TEST(v1.component_count() == 5);
            int count = d1.component_count();
            TestDynAny.TEST(d1.seek(0));
            TestDynAny.TEST(!d1.seek(-1));
            TestDynAny.TEST(!d1.seek(count));
            TestDynAny.TEST(d1.seek(count - 1));
            d1.seek(-1);
            TestDynAny.TEST(d1.next());
            d1.seek(count - 1);
            TestDynAny.TEST(!d1.next());
            d1.rewind();
            d2 = d1.current_component();
            TestDynAny.TEST(d2 != null);
            d2.destroy();
            d2.destroy();
            d1.seek(-9);
            d2 = d1.current_component();
            TestDynAny.TEST(d2 == null);
            d1.destroy();
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    static void testValueStruct(org.omg.CORBA.ORB orb, DynAnyFactory factory) {
        try {
            Any any = orb.create_any();
            TypeCode type = TestValueStructHelper.type();
            DynAny d1 = factory.create_dyn_any_from_type_code(type);
            TestDynAny.TEST(d1.component_count() == 2);
            d1.insert_string("name");
            d1.next();
            DynAny comp = d1.current_component();
            DynValue dv = DynValueHelper.narrow((Object)comp);
            TestDynAny.TEST(dv.is_null());
            dv.set_to_value();
            comp.insert_short((short)-55);
            comp.next();
            comp.insert_long(333);
            comp.next();
            comp.insert_string("hi there");
            Serializable vb = d1.get_val();
            TestValue2 ptv2 = null;
            try {
                ptv2 = (TestValue2)((java.lang.Object)vb);
            }
            catch (ClassCastException ex) {
                TestDynAny.TEST(false);
            }
            TestDynAny.TEST(ptv2.shortVal == -55);
            TestDynAny.TEST(ptv2.longVal == 333);
            TestDynAny.TEST(ptv2.stringVal.equals("hi there"));
            TestValue4_impl tv4 = new TestValue4_impl();
            tv4.shortVal = (short)-77;
            tv4.longVal = 555;
            tv4.stringVal = "ho there";
            tv4.charVal = (char)90;
            tv4.longlongVal = 9876543L;
            d1.insert_val((Serializable)((java.lang.Object)tv4));
            comp = d1.current_component();
            TestDynAny.TEST(comp.component_count() == 3);
            comp.rewind();
            TestDynAny.TEST(comp.get_short() == -77);
            comp.next();
            TestDynAny.TEST(comp.get_long() == 555);
            comp.next();
            String str = comp.get_string();
            TestDynAny.TEST(str.equals("ho there"));
            vb = d1.get_val();
            try {
                ptv2 = (TestValue2)((java.lang.Object)vb);
            }
            catch (ClassCastException ex) {
                TestDynAny.TEST(false);
            }
            try {
                TestValue4 ptv4 = (TestValue4)((java.lang.Object)vb);
                TestDynAny.TEST(false);
            }
            catch (ClassCastException ex) {}
        }
        catch (InconsistentTypeCode ex) {
            TestDynAny.TEST(false);
        }
        catch (TypeMismatch ex) {
            TestDynAny.TEST(false);
        }
        catch (InvalidValue ex) {
            TestDynAny.TEST(false);
        }
    }

    public TestDynAny(org.omg.CORBA.ORB orb) {
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("DynAnyFactory");
            TestDynAny.TEST(obj != null);
        }
        catch (InvalidName ex) {
            TestDynAny.TEST(false);
        }
        ORB orb_2_3 = (ORB)orb;
        orb_2_3.register_value_factory(TestValue1Helper.id(), (ValueFactory)new TestValue1Factory_impl());
        orb_2_3.register_value_factory(TestValue2Helper.id(), (ValueFactory)new TestValue2Factory_impl());
        orb_2_3.register_value_factory(TestValue3Helper.id(), (ValueFactory)new TestValue3Factory_impl());
        orb_2_3.register_value_factory(TestValue4Helper.id(), (ValueFactory)new TestValue4Factory_impl());
        DynAnyFactory factory = DynAnyFactoryHelper.narrow((Object)obj);
        TestDynAny.testBasic(orb, factory);
        TestDynAny.testFixed(orb, factory);
        TestDynAny.testEnum(orb, factory);
        TestDynAny.testStruct(orb, factory);
        TestDynAny.testException(orb, factory);
        TestDynAny.testUnion1(orb, factory);
        TestDynAny.testUnion2(orb, factory);
        TestDynAny.testUnion3(orb, factory);
        TestDynAny.testUnion4(orb, factory);
        TestDynAny.testShortSeq(orb, factory);
        TestDynAny.testBoundedString10Seq(orb, factory);
        TestDynAny.testAnySeq(orb, factory);
        TestDynAny.testStringArray(orb, factory);
        TestDynAny.testStructBox(orb, factory);
        TestDynAny.testStringBox(orb, factory);
        TestDynAny.testValue1(orb, factory);
        TestDynAny.testValue2(orb, factory);
        TestDynAny.testValue3(orb, factory);
        TestDynAny.testValue4(orb, factory);
        TestDynAny.testValueStruct(orb, factory);
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        try {
            orb = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            TYPECODE_VALUE = orb.get_primitive_tc(TCKind.tk_float);
            System.out.print("Testing DynAny... ");
            System.out.flush();
            new TestDynAny(orb);
            System.out.println("Done!");
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }

    static class TestValue4Factory_impl
    implements ValueFactory {
        TestValue4Factory_impl() {
        }

        public Serializable read_value(InputStream in) {
            TestValue4_impl result = new TestValue4_impl();
            result._read((org.omg.CORBA.portable.InputStream)in);
            return result;
        }
    }

    static class TestValue4_impl
    extends TestValue4 {
        TestValue4_impl() {
        }
    }

    static class TestValue3Factory_impl
    implements ValueFactory {
        TestValue3Factory_impl() {
        }

        public Serializable read_value(InputStream in) {
            TestValue3_impl result = new TestValue3_impl();
            result._read((org.omg.CORBA.portable.InputStream)in);
            return result;
        }
    }

    static class TestValue3_impl
    extends TestValue3 {
        TestValue3_impl() {
        }
    }

    static class TestValue2Factory_impl
    implements ValueFactory {
        TestValue2Factory_impl() {
        }

        public Serializable read_value(InputStream in) {
            TestValue2_impl result = new TestValue2_impl();
            result._read((org.omg.CORBA.portable.InputStream)in);
            return result;
        }
    }

    static class TestValue2_impl
    extends TestValue2 {
        TestValue2_impl() {
        }
    }

    static class TestValue1Factory_impl
    implements ValueFactory {
        TestValue1Factory_impl() {
        }

        public Serializable read_value(InputStream in) {
            return new TestValue1_impl();
        }
    }

    static class TestValue1_impl
    extends TestValue1 {
        TestValue1_impl() {
        }
    }
}

