/*
 * Decompiled with CFR 0.152.
 */
package test.retry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import test.retry.FwdLocator_impl;
import test.retry.Retry;
import test.retry.RetryServer;
import test.retry.RetryServer_impl;
import test.retry.Retry_impl;
import test.retry.Test;
import test.retry.TestHelper;

public class Server {
    public static int run(ORB orb, String[] args) throws UserException {
        POA rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        POAManager manager = rootPOA.the_POAManager();
        manager.activate();
        Policy[] policies = new Policy[]{rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION)};
        POA poa1 = rootPOA.create_POA("poa1", null, policies);
        POA poa2 = rootPOA.create_POA("poa2", null, policies);
        Object obj1 = poa1.create_reference("IDL:Test:1.0");
        Object obj2 = poa2.create_reference("IDL:Test:1.0");
        FwdLocator_impl locator1 = new FwdLocator_impl(obj2);
        FwdLocator_impl locator2 = new FwdLocator_impl(obj1);
        poa1.set_servant_manager((ServantManager)locator1);
        poa2.set_servant_manager((ServantManager)locator2);
        Test test = TestHelper.narrow(obj1);
        Retry_impl retryImpl = new Retry_impl(rootPOA);
        Retry retry = retryImpl._this(orb);
        RetryServer_impl serverImpl = new RetryServer_impl(rootPOA, test, retry);
        RetryServer server = serverImpl._this(orb);
        String refFile = "Test.ref";
        try {
            String ref = orb.object_to_string((Object)server);
            FileOutputStream file = new FileOutputStream(refFile);
            PrintWriter out = new PrintWriter(file);
            out.println(ref);
            out.flush();
            file.close();
        }
        catch (IOException ex) {
            System.err.println("Can't write to `" + ex.getMessage() + "'");
            return 1;
        }
        POAManager mgr = poa1.the_POAManager();
        mgr.activate();
        mgr = poa2.the_POAManager();
        mgr.activate();
        orb.run();
        new File(refFile).delete();
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            status = Server.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

