/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import test.common.TestBase;
import test.poa.TestInfo;
import test.poa.TestServer;
import test.poa.TestServerHelper;

public final class TestMultipleOrbsClient
extends TestBase {
    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            BufferedReader in = new BufferedReader(new FileReader("Test.ref"));
            String ref1 = in.readLine();
            Object obj = orb.string_to_object(ref1);
            if (obj == null) {
                System.err.println("TestMultipleOrbsClient:  cannot read IOR from Test.ref");
                System.exit(1);
            }
            TestServer server1 = TestServerHelper.narrow(obj);
            String ref2 = in.readLine();
            obj = orb.string_to_object(ref2);
            if (obj == null) {
                System.err.println("TestMultipleOrbsClient:  cannot read IOR from Test.ref");
                System.exit(1);
            }
            TestServer server2 = TestServerHelper.narrow(obj);
            in.close();
            TestInfo[] info1 = server1.get_info();
            TestInfo[] info2 = server2.get_info();
            info1[0].obj.aMethod();
            info2[0].obj.aMethod();
            info1[0].obj.aMethod();
            info2[0].obj.aMethod();
            server1.deactivate();
            server2.deactivate();
        }
        catch (FileNotFoundException ex) {
            System.err.println("TestMultipleOrbsClient: cannot open Test.ref");
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("TestMultipleOrbsClient: File input error");
            System.exit(1);
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

