/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import test.common.TestBase;
import test.poa.TestInfo;
import test.poa.TestServer;
import test.poa.TestServerHelper;

public final class TestDispatchStrategyClient
extends TestBase {
    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            Request req;
            int idx;
            orb = ORB.init((String[])args, (Properties)props);
            Object obj = orb.string_to_object("relfile:/Test.ref");
            if (obj == null) {
                System.err.println("TestDispatchStrategyClient: cannot read IOR from Test.ref");
                System.exit(1);
            }
            TestServer server = TestServerHelper.narrow(obj);
            TestInfo[] info = server.get_info();
            for (idx = 0; idx < info.length; ++idx) {
                TestDispatchStrategyClient.TEST(info[idx].obj != null);
                for (int idx2 = 0; idx2 < 4; ++idx2) {
                    req = info[idx].obj._request("aMethod");
                    req.send_deferred();
                }
            }
            idx = info.length * 4;
            do {
                req = orb.get_next_response();
            } while (--idx != 0);
            server.deactivate();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

