/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosPropertyService;

import com.ooc.CORBA.ORB;
import com.ooc.CosPropertyService.PropertySetDefFactory_impl;
import com.ooc.OB.Assert;
import com.ooc.OB.BootManager;
import com.ooc.OB.BootManagerHelper;
import com.ooc.OB.BootManagerPackage.AlreadyExists;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.StringSeqHolder;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class Server {
    private static String progName = "com.ooc.CosPropertyService.Server";

    static void usage() {
        System.err.println("Usage:");
        System.err.println(progName + " [options]\n" + "\n" + "Options:\n" + "-h, --help             " + "Show this message.\n" + "-v, --version          " + "Show version number.\n" + "-i, --ior              " + "Print IOR on standard output.");
    }

    static int run(org.omg.CORBA.ORB orb, String[] args) {
        Object poaObj = null;
        try {
            poaObj = orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        POA rootPOA = POAHelper.narrow((Object)poaObj);
        POAManager manager = rootPOA.the_POAManager();
        POA poa = null;
        try {
            Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            poa = rootPOA.create_POA("PropertyServicePOA", manager, policies);
        }
        catch (AdapterAlreadyExists ex) {
        }
        catch (InvalidPolicy ex) {
            // empty catch block
        }
        Assert._OB_assert((poa != null ? 1 : 0) != 0);
        BootManager bootManager = null;
        try {
            bootManager = BootManagerHelper.narrow((Object)orb.resolve_initial_references("BootManager"));
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        boolean ior = false;
        for (int i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                Server.usage();
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.err.println("ORBacus Property Service 4.1.3");
                return 0;
            }
            if (!args[i].equals("--ior") && !args[i].equals("-i")) {
                System.err.println(progName + ": Unknown option `" + args[i] + "'\n");
                Server.usage();
                return 1;
            }
            ior = true;
        }
        PropertySetDefFactory_impl defFactory = new PropertySetDefFactory_impl(rootPOA, orb);
        byte[] oid = "PropertyService".getBytes();
        try {
            poa.activate_object_with_id(oid, (Servant)defFactory);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ObjectAlreadyActive ex) {
            throw new RuntimeException();
        }
        catch (ServantAlreadyActive ex) {
            throw new RuntimeException();
        }
        Object obj = null;
        try {
            obj = poa.id_to_reference(oid);
            bootManager.add_binding(oid, obj);
        }
        catch (ObjectNotActive ex) {
            throw new RuntimeException();
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (AlreadyExists ex) {
            throw new RuntimeException();
        }
        try {
            manager.activate();
        }
        catch (AdapterInactive ex) {
            throw new RuntimeException();
        }
        if (ior) {
            String s = orb.object_to_string(obj);
            System.out.println(s);
        }
        orb.run();
        return 0;
    }

    public static void main(String[] args) {
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        try {
            args = ORB.ParseArgs((String[])args, (Properties)props, null);
            String propRoot = "ooc.property.";
            Enumeration<java.lang.Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(propRoot)) continue;
                String value = props.getProperty(key);
                Assert._OB_assert((value != null ? 1 : 0) != 0);
                if (key.equals("ooc.property.endpoint")) {
                    String oaEndpoint = props.getProperty("ooc.orb.oa.endpoint");
                    if (oaEndpoint != null) continue;
                    props.put("ooc.orb.oa.endpoint", value);
                    continue;
                }
                System.err.println(progName + ": " + key + "': unknown property");
            }
            props.put("ooc.orb.conc_model", "blocking");
            StringSeqHolder argsH = new StringSeqHolder(args);
            orb = ORB.init((StringSeqHolder)argsH, (Properties)props, null);
            status = Server.run(orb, argsH.value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

