/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectIdHasher;
import com.ooc.OBPortableServer.ActiveObjectOnlyStrategy;
import com.ooc.OBPortableServer.DefaultServantHolder;
import com.ooc.OBPortableServer.POAPolicies;
import com.ooc.OBPortableServer.ServantActivatorStrategy;
import com.ooc.OBPortableServer.ServantManagerStrategy;
import com.ooc.OBPortableServer.TableEntry;
import com.ooc.PortableServer.Current_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

class RetainStrategy
extends ActiveObjectOnlyStrategy {
    private ServantActivatorStrategy servantManager_;
    private DefaultServantHolder defaultServant_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etherealize(ObjectIdHasher oid, POA poa, Servant servant, boolean cleanup) {
        if (this.servantManager_ != null) {
            boolean remaining = false;
            ServantActivatorStrategy servantActivatorStrategy = this.servantManager_;
            synchronized (servantActivatorStrategy) {
                if (this.servantIdTable_ == null) {
                    Enumeration keys = this.activeObjectTable_.keys();
                    while (keys.hasMoreElements()) {
                        TableEntry entry = (TableEntry)this.activeObjectTable_.get(keys.nextElement());
                        if (entry == null) continue;
                        TableEntry tableEntry = entry;
                        synchronized (tableEntry) {
                            if (entry.state() != 3 && entry.state() != 0 && entry.getServant() == servant) {
                                remaining = true;
                                break;
                            }
                        }
                    }
                }
            }
            this.servantManager_.etherealize(oid.getObjectId(), poa, servant, cleanup, remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupEntry(ObjectIdHasher oid, TableEntry entry) {
        this.activeObjectTable_.remove(oid);
        TableEntry tableEntry = entry;
        synchronized (tableEntry) {
            entry.setDeactivated();
        }
    }

    protected void completeDeactivate(POA poa, ObjectIdHasher oid, TableEntry entry) {
        Servant servant = entry.getServant();
        super.completeDeactivate(poa, oid, entry);
        this.etherealize(oid, poa, servant, false);
    }

    RetainStrategy(POAPolicies policies, ORBInstance orbInstance, ServantActivatorStrategy servantManager, DefaultServantHolder defaultServant) {
        super(policies, orbInstance);
        this.servantManager_ = servantManager;
        this.defaultServant_ = defaultServant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(POA poa, boolean e) {
        if (this.servantManager_ != null && e) {
            Enumeration keys = this.activeObjectTable_.keys();
            while (keys.hasMoreElements()) {
                Servant servant = null;
                TableEntry entry = null;
                ObjectIdHasher key = (ObjectIdHasher)keys.nextElement();
                block8: while ((entry = (TableEntry)this.activeObjectTable_.get(key)) != null) {
                    TableEntry tableEntry = entry;
                    synchronized (tableEntry) {
                        switch (entry.state()) {
                            case 1: {
                                entry.setDeactivatePending();
                                servant = entry.getServant();
                                break;
                            }
                            case 0: 
                            case 2: {
                                entry.waitForStateChange();
                                continue block8;
                            }
                        }
                        break;
                    }
                }
                if (servant == null) continue;
                super.completeDeactivate(poa, key, entry);
                this.etherealize(key, poa, servant, true);
                this.activeObjectTable_.remove(key);
            }
        }
        super.destroy(poa, e);
        if (this.servantManager_ != null) {
            this.servantManager_.destroy();
        }
        if (this.defaultServant_ != null) {
            this.defaultServant_.destroy();
        }
    }

    public void etherealize(POA poa) {
        this.destroy(poa, true);
    }

    public byte[] servantToId(Servant servant, Current_impl poaCurrent) {
        byte[] oid = super.servantToId(servant, poaCurrent);
        if (oid == null && this.defaultServant_ != null) {
            return this.defaultServant_.servantToId(servant, poaCurrent);
        }
        return oid;
    }

    public Servant idToServant(byte[] oid, boolean useDefaultServant) {
        Servant servant = super.idToServant(oid, useDefaultServant);
        if (servant == null && useDefaultServant && this.defaultServant_ != null) {
            servant = this.defaultServant_.getDefaultServant();
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant locate(byte[] rawoid, POA poa, String op, CookieHolder cookie) throws LocationForward {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        block14: while (true) {
            TableEntry entry;
            boolean incarnate = false;
            Hashtable hashtable = this.activeObjectTable_;
            synchronized (hashtable) {
                entry = (TableEntry)this.activeObjectTable_.get(oid);
                if (entry == null) {
                    if (this.defaultServant_ != null) {
                        Servant servant = this.defaultServant_.getDefaultServant();
                        if (servant == null) {
                            throw new OBJ_ADAPTER(MinorCodes.describeObjAdapter(1330446339), 1330446339, CompletionStatus.COMPLETED_NO);
                        }
                        return servant;
                    }
                    entry = new TableEntry();
                    this.activeObjectTable_.put(oid, entry);
                    incarnate = true;
                }
            }
            Servant servant = null;
            if (incarnate) {
                try {
                    byte[] oid2;
                    servant = this.servantManager_.incarnate(oid.getObjectId(), poa);
                    if (this.servantIdTable_ != null && this.servantIdTable_.containsKey(servant) && !ObjectIdHasher.comp(rawoid, oid2 = (byte[])this.servantIdTable_.get(servant))) {
                        throw new OBJ_ADAPTER("ServantActivator returned a servant that is already active for a different object ID");
                    }
                }
                catch (LocationForward l) {
                    this.cleanupEntry(oid, entry);
                    throw l;
                }
                catch (SystemException e) {
                    this.cleanupEntry(oid, entry);
                    throw e;
                }
            }
            TableEntry tableEntry = entry;
            synchronized (tableEntry) {
                switch (entry.state()) {
                    case 0: {
                        if (incarnate) {
                            this.completeActivation(oid, servant, entry);
                            return servant;
                        }
                        entry.waitForStateChange();
                        continue block14;
                    }
                    case 2: {
                        entry.waitForStateChange();
                        continue block14;
                    }
                    case 1: {
                        Servant s = entry.getServant();
                        if (incarnate) {
                            if (s != servant) {
                                throw new OBJ_ADAPTER("ServantActivator returned a servant that does not match the active object map");
                            }
                            return servant;
                        }
                        return s;
                    }
                }
            }
        }
    }

    public ServantManagerStrategy getServantManagerStrategy() {
        return this.servantManager_;
    }

    public DefaultServantHolder getDefaultServantHolder() {
        return this.defaultServant_;
    }
}

