/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.ClientManager;
import com.ooc.OB.DispatchStrategyFactory;
import com.ooc.OB.DispatchStrategyFactory_impl;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.Logger;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerFactory;
import com.ooc.OBPortableServer.POAManagerFactoryHelper;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.POAManagerAlreadyExists;
import com.ooc.OBPortableServer.POAManagerFactory_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.InvalidParam;
import com.ooc.PortableServer.Current_impl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;

public final class ORBControl {
    ORBInstance orbInstance_;
    private static final int StateNotRunning = 0;
    private static final int StateRunning = 1;
    private static final int StateServerShutdown = 2;
    private static final int StateClientShutdown = 3;
    private static final int StateDestroyed = 4;
    private int state_ = 0;
    private boolean shutdown_ = false;
    private java.lang.Object shutdownCond_ = new java.lang.Object();
    private POA rootPOA_;
    private Thread mainThread_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void completeServerShutdown() {
        ThreadGroup group;
        if (!this.shutdown_ || this.state_ == 2) {
            return;
        }
        Assert._OB_assert(this.state_ != 3 && this.state_ != 4);
        Assert._OB_assert(this.state_ == 0 || this.mainThread_ == Thread.currentThread());
        POAManagerFactory pmFactory = this.orbInstance_.getPOAManagerFactory();
        POAManagerFactory_impl factory = (POAManagerFactory_impl)pmFactory;
        factory._OB_deactivate();
        ThreadGroup threadGroup = group = this.orbInstance_.getServerWorkerGroup();
        synchronized (threadGroup) {
            while (group.activeCount() > 0) {
                try {
                    group.wait();
                }
                catch (InterruptedException ex) {}
            }
            DispatchStrategyFactory dsFactory = this.orbInstance_.getDispatchStrategyFactory();
            DispatchStrategyFactory_impl dsFactoryImpl = (DispatchStrategyFactory_impl)dsFactory;
            dsFactoryImpl._OB_destroy();
            this.state_ = 2;
            if (this.rootPOA_ != null) {
                this.rootPOA_.destroy(true, true);
                this.rootPOA_ = null;
            }
            this.notifyAll();
        }
    }

    private synchronized void validateState() {
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 2 || this.state_ == 3) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 0) {
            this.mainThread_ = Thread.currentThread();
            this.state_ = 1;
        }
    }

    private synchronized void blockServerShutdownComplete() {
        while (this.state_ == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void destroy() {
        Assert._OB_assert(this.state_ == 3);
        this.state_ = 4;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public boolean workPending() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return false;
        }
        return this.shutdown_;
    }

    public void performWork() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return;
        }
        this.completeServerShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        if (this.shutdown_) {
            this.completeServerShutdown();
            return;
        }
        do {
            java.lang.Object object = this.shutdownCond_;
            synchronized (object) {
                try {
                    this.shutdownCond_.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.completeServerShutdown();
        } while (this.state_ == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownServer(boolean waitForCompletion) {
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 2 || this.state_ == 3) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (waitForCompletion) {
            boolean inInvocation = false;
            try {
                InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
                Object o = initialServiceManager.resolveInitialReferences("POACurrent");
                Current_impl current = (Current_impl)o;
                inInvocation = current._OB_inUpcall();
                if (inInvocation) {
                    try {
                        POA_impl p = (POA_impl)current.get_POA();
                        inInvocation = p._OB_ORBInstance() == this.orbInstance_;
                    }
                    catch (NoContext ex) {}
                }
            }
            catch (ClassCastException ex) {
            }
            catch (InvalidName invalidName) {
                // empty catch block
            }
            if (inInvocation) {
                throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446339), 1330446339, CompletionStatus.COMPLETED_NO);
            }
        }
        this.shutdown_ = true;
        java.lang.Object object = this.shutdownCond_;
        synchronized (object) {
            this.shutdownCond_.notifyAll();
        }
        if (!waitForCompletion) {
            return;
        }
        if (this.state_ == 1 && this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        this.completeServerShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownServerClient() {
        if (this.state_ == 4) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.state_ == 3) {
            return;
        }
        if (this.orbInstance_ != null) {
            ThreadGroup group;
            if (this.state_ != 2) {
                this.shutdownServer(true);
            }
            Assert._OB_assert(this.state_ == 2);
            ClientManager clientManager = this.orbInstance_.getClientManager();
            clientManager.destroy();
            ThreadGroup threadGroup = group = this.orbInstance_.getClientWorkerGroup();
            synchronized (threadGroup) {
                while (group.activeCount() > 0) {
                    try {
                        group.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        this.state_ = 3;
        this.notifyAll();
    }

    public void initializeRootPOA(ORB orb) {
        String serverId = this.orbInstance_.getServerId();
        if (serverId.length() == 0) {
            serverId = "_RootPOA";
        }
        InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
        POAManagerFactory factory = null;
        try {
            factory = POAManagerFactoryHelper.narrow(ism.resolveInitialReferences("POAManagerFactory"));
        }
        catch (InvalidName ex) {
            Assert._OB_assert(false);
        }
        POAManager manager = null;
        POAManager[] managers = factory.get_poa_managers();
        for (int i = 0; i < managers.length; ++i) {
            if (!managers[i].name().equals("RootPOAManager")) continue;
            manager = managers[i];
            break;
        }
        if (manager == null) {
            try {
                manager = factory.create_poa_manager("RootPOAManager");
            }
            catch (POAManagerAlreadyExists ex) {
                Assert._OB_assert(false);
            }
            catch (InvalidParam ex) {
                Logger logger = this.orbInstance_.getLogger();
                String err = "invalid configuration parameter for RootPOAManager: " + ex.reason;
                logger.error(err);
                throw new INITIALIZE(err);
            }
        }
        POA_impl root = new POA_impl(orb, this.orbInstance_, serverId, manager);
        root._OB_addPolicyFactory();
        this.rootPOA_ = root;
        try {
            ism.addInitialReference("RootPOA", root, true);
        }
        catch (InvalidName ex) {
            Assert._OB_assert(false);
        }
        POAManagerFactory_impl factoryImpl = (POAManagerFactory_impl)factory;
        factoryImpl._OB_initializeIMR(root, this);
    }
}

