/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.ORB;
import com.ooc.OB.Assert;
import com.ooc.OB.HexConverter;
import com.ooc.OB.IORUtil;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ConFactory;
import com.ooc.OCI.ConFactoryRegistryHelper;
import com.ooc.OCI.ConFactoryRegistryOperations;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;

public class IORDump {
    static void PrintObjref(org.omg.CORBA.ORB orb, PrintStream out, IOR ior) {
        out.println("type_id: " + ior.type_id);
        ConFactoryRegistryOperations conFactoryRegistry = null;
        try {
            Object obj = orb.resolve_initial_references("OCIConFactoryRegistry");
            conFactoryRegistry = ConFactoryRegistryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            Assert._OB_assert(false);
        }
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (int i = 0; i < ior.profiles.length; ++i) {
            int j;
            out.print("Profile #" + (i + 1) + ": ");
            if (ior.profiles[i].tag == 1) {
                out.print("multiple components");
                byte[] data = ior.profiles[i].profile_data;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                int cnt = in.read_ulong();
                if (cnt == 0) {
                    out.println();
                    continue;
                }
                for (int j2 = 0; j2 < cnt; ++j2) {
                    TaggedComponent comp = TaggedComponentHelper.read(in);
                    String desc = IORUtil.describe_component(comp);
                    out.println(desc);
                }
                continue;
            }
            for (j = 0; j < factories.length; ++j) {
                if (factories[j].tag() != ior.profiles[i].tag) continue;
                out.println(factories[j].id());
                String desc = factories[j].describe_profile(ior.profiles[i]);
                out.print(desc);
                break;
            }
            if (j < factories.length) continue;
            out.println("unknown profile tag " + ior.profiles[i].tag);
            out.println("profile_data: (" + ior.profiles[i].profile_data.length + ")");
            String data = IORUtil.dump_octets(ior.profiles[i].profile_data, 0, ior.profiles[i].profile_data.length);
            out.print(data);
        }
    }

    static void DumpIOR(org.omg.CORBA.ORB orb, String ref, boolean hasEndian) {
        InputStream in;
        if (!ref.startsWith("IOR:")) {
            System.out.println("IOR is invalid");
            return;
        }
        byte[] data = HexConverter.asciiToOctets(ref, 4);
        Buffer buf = new Buffer(data, data.length);
        boolean endian = (in = new InputStream(buf)).read_boolean();
        in._OB_swap(endian);
        IOR ior = IORHelper.read(in);
        System.out.print("byteorder: ");
        if (hasEndian) {
            System.out.println((endian ? "little" : "big") + " endian");
        } else {
            System.out.println("n/a");
        }
        IORDump.PrintObjref(orb, System.out, ior);
        System.out.flush();
    }

    static void usage() {
        System.err.println("Usage:");
        System.err.println("com.ooc.OB.IORDump [options] [-f FILE ... | IOR ...]\n\nOptions:\n-h, --help          Show this message.\n-v, --version       Show ORBacus version.\n-f                  Read IORs from files instead of from the\n                    command line.");
    }

    static int run(org.omg.CORBA.ORB orb, String[] args) throws UserException {
        int i;
        boolean files = false;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                IORDump.usage();
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.out.println("ORBacus 4.1.3");
                return 0;
            }
            if (!args[i].equals("-f")) {
                System.err.println("IORDump: unknown option `" + args[i] + "'");
                IORDump.usage();
                return 1;
            }
            files = true;
        }
        if (i == args.length) {
            System.err.println("IORDump: no IORs");
            System.err.println();
            IORDump.usage();
            return 1;
        }
        if (!(files || args[i].startsWith("IOR:") || args[i].startsWith("corbaloc:") || args[i].startsWith("corbaname:") || args[i].startsWith("file:") || args[i].startsWith("relfile:"))) {
            System.err.println("[No valid IOR found on the command line, assuming -f]");
            files = true;
        }
        if (!files) {
            int count = 0;
            while (i < args.length) {
                if (count > 0) {
                    System.out.println();
                }
                System.out.println("IOR #" + ++count + ':');
                try {
                    if (args[i].startsWith("IOR:")) {
                        IORDump.DumpIOR(orb, args[i], true);
                    } else {
                        Object obj = orb.string_to_object(args[i]);
                        String s = orb.object_to_string(obj);
                        IORDump.DumpIOR(orb, s, false);
                    }
                }
                catch (BAD_PARAM ex) {
                    System.err.println("IOR is invalid");
                }
                ++i;
            }
        } else {
            int count = 0;
            while (i < args.length) {
                try {
                    String line;
                    FileReader fin = new FileReader(args[i]);
                    BufferedReader in = new BufferedReader(fin);
                    while ((line = in.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        if (count > 0) {
                            System.out.println();
                        }
                        System.out.println("IOR #" + ++count + ':');
                        if (line.startsWith("IOR:")) {
                            IORDump.DumpIOR(orb, line, true);
                            continue;
                        }
                        Object obj = orb.string_to_object(line);
                        String s = orb.object_to_string(obj);
                        IORDump.DumpIOR(orb, s, false);
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("IORDump: can't open `" + args[i] + "': " + ex);
                    return 1;
                }
                catch (IOException ex) {
                    System.err.println("IORDump: can't read `" + args[i] + "': " + ex);
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        try {
            args = ORB.ParseArgs(args, props, null);
            orb = org.omg.CORBA.ORB.init(args, props);
            status = IORDump.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

