/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.Downcall;
import com.ooc.OB.GIOPClient;
import com.ooc.OB.GIOPClientWorker;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.SendReceiveMode;
import com.ooc.OCI.Transport;
import java.util.Properties;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.MsgType_1_1;

final class GIOPClientWorkerThreaded
extends GIOPClientWorker {
    protected int connectionTimeout_;
    protected long timestamp_;
    protected Object sendMutex_ = new Object();
    protected Thread shutdownThread_;
    protected Thread receiverThread_;

    protected void add(Buffer buf) {
        this.updateTimestamp();
        super.add(buf);
    }

    protected void add(Downcall down) {
        if (down.responseExpected()) {
            down.initStateMonitor();
        }
        this.updateTimestamp();
        super.add(down);
    }

    protected void gracefulShutdown() {
        try {
            ThreadGroup group = this.orbInstance_.getClientWorkerGroup();
            this.shutdownThread_ = new ShutdownThread(group, this);
            this.shutdownThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.exception(4, new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO));
        }
    }

    protected void abortiveShutdown() {
        try {
            Buffer buf = new Buffer(12);
            OutputStream out = new OutputStream(buf);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.major = 1;
            profileInfo.minor = this.minor_;
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
            out._OB_pos(0);
            this.transport_.send(out._OB_buffer(), true);
            Assert._OB_assert(out._OB_buffer().is_full());
        }
        catch (SystemException ex) {
            this.exception(4, ex);
            return;
        }
        this.exception(4, new TRANSIENT(MinorCodes.describeTransient(0x4F4F0004), 0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
    }

    protected void updateTimestamp() {
        if (this.connectionTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    GIOPClientWorkerThreaded(ORBInstance orbInstance, GIOPClient client, Transport transport) {
        super(orbInstance, client, transport);
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.client_timeout");
        if (value != null) {
            this.connectionTimeout_ = Integer.parseInt(value);
            this.updateTimestamp();
        } else {
            this.connectionTimeout_ = 0;
            this.timestamp_ = 0L;
        }
        if (transport.mode() == SendReceiveMode.SendReceive) {
            try {
                ThreadGroup group = this.orbInstance_.getClientWorkerGroup();
                this.receiverThread_ = new ReceiverThread(group, this);
                this.receiverThread_.start();
            }
            catch (OutOfMemoryError ex) {
                this.transport_.close();
                this.state_ = 4;
                throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    synchronized void destroy() {
        this.exception(1, new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Downcall down, boolean block) {
        if (block) {
            boolean downcallAdded = false;
            Downcall downcallToSend = null;
            int t = down.policies().requestTimeout;
            try {
                do {
                    Buffer buf;
                    Object object = this;
                    synchronized (object) {
                        if (!downcallAdded) {
                            this.add(down);
                            if (!down.unsent()) {
                                return !down.responseExpected();
                            }
                            downcallAdded = true;
                        }
                        buf = ((GIOPClientWorker.UnsentMessage)this.unsent_.firstElement()).buf;
                        downcallToSend = this.moveFirstUnsentToPending();
                    }
                    object = this.sendMutex_;
                    synchronized (object) {
                        if (t < 0) {
                            this.transport_.send(buf, true);
                            Assert._OB_assert(buf.is_full());
                        } else {
                            this.transport_.send_timeout(buf, t);
                            if (!buf.is_full()) {
                                throw new NO_RESPONSE();
                            }
                        }
                    }
                } while (down.unsent());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    if (downcallToSend != null) {
                        this.movePendingToUnsent(downcallToSend);
                    }
                    this.exception(4, ex);
                    return true;
                }
            }
        }
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.add(down);
            try {
                while (down.unsent()) {
                    Buffer buf = ((GIOPClientWorker.UnsentMessage)this.unsent_.firstElement()).buf;
                    Object t = this.sendMutex_;
                    synchronized (t) {
                        this.transport_.send(buf, false);
                        if (!buf.is_full()) {
                            return false;
                        }
                    }
                    Downcall sent = this.moveFirstUnsentToPending();
                }
            }
            catch (SystemException ex) {
                this.exception(4, ex);
                return true;
            }
        }
        return !down.responseExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(Downcall down, boolean block) {
        try {
            return down.waitUntilCompleted(block);
        }
        catch (SystemException ex) {
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                this.exception(4, ex);
                return true;
            }
        }
    }

    public boolean sendReceive(Downcall down) {
        if (this.send(down, true)) {
            return true;
        }
        return this.receive(down, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiverRun() {
        while (true) {
            Assert._OB_assert(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                this.transport_.receive(this.buf_, true);
                Assert._OB_assert(this.buf_.is_full());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(2, ex);
                    return;
                }
            }
            if (!this.buf_.is_full()) {
                try {
                    this.transport_.receive(this.buf_, true);
                    Assert._OB_assert(this.buf_.is_full());
                }
                catch (SystemException ex) {
                    GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                    synchronized (gIOPClientWorkerThreaded) {
                        this.exception(4, ex);
                        return;
                    }
                }
            }
            GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
            synchronized (gIOPClientWorkerThreaded) {
                if (this.state_ != 0 && this.state_ != 1) {
                    return;
                }
                this.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRun() {
        if (this.minor_ >= 2) {
            try {
                Buffer buf = new Buffer(12);
                OutputStream out = new OutputStream(buf);
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = 1;
                profileInfo.minor = this.minor_;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
                out._OB_pos(0);
                this.transport_.send(out._OB_buffer(), true);
                Assert._OB_assert(out._OB_buffer().is_full());
            }
            catch (SystemException ex) {
                GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
                synchronized (gIOPClientWorkerThreaded) {
                    this.exception(4, ex);
                }
            }
        }
        GIOPClientWorkerThreaded ex = this;
        synchronized (ex) {
            if (this.state_ == 1) {
                this.logCloseConnection();
                this.transport_.shutdown();
            }
        }
        if (this.transport_.mode() == SendReceiveMode.SendReceive) {
            while (true) {
                try {
                    if (this.shutdownTimeout_ > 0) {
                        this.receiverThread_.join(this.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.receiverThread_.join();
                }
                catch (InterruptedException ex2) {
                    continue;
                }
                break;
            }
        }
        GIOPClientWorkerThreaded gIOPClientWorkerThreaded = this;
        synchronized (gIOPClientWorkerThreaded) {
            this.exception(4, new TRANSIENT(0x4F4F0004, CompletionStatus.COMPLETED_MAYBE));
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        ReceiverThread(ThreadGroup group, GIOPClientWorkerThreaded worker) {
            super(group, "ORBacus:Client:ReceiverThread");
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert._OB_assert(false);
            }
            this.worker_ = null;
        }
    }

    protected static final class ShutdownThread
    extends Thread {
        private GIOPClientWorkerThreaded worker_;

        ShutdownThread(ThreadGroup group, GIOPClientWorkerThreaded worker) {
            super(group, "ORBacus:Client:ShutdownThread");
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.shutdownRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert._OB_assert(false);
            }
            this.worker_ = null;
        }
    }
}

