/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.OutputStreamHolder;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetInfo;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.GIOPClientWorker;
import com.ooc.OB.GIOPClientWorkerThreaded;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Connector;
import com.ooc.OCI.ConnectorInfo;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.SendReceiveMode;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

final class GIOPClient
extends Client {
    protected ORBInstance orbInstance_;
    protected int nextRequestId_;
    protected Object nextRequestIdMutex_ = new Object();
    protected Connector connector_;
    protected GIOPClientWorker worker_;
    protected ServiceContext codeSetSC_;
    protected boolean destroy_;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.destroy_);
        Assert._OB_assert(this.worker_ == null);
        super.finalize();
    }

    protected synchronized GIOPClientWorker getWorker(boolean create, int t) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.worker_ == null && create) {
            Transport transport;
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                ConnectorInfo info = this.connector_.get_info();
                String msg = "trying to establish connection\n";
                msg = msg + "timeout: ";
                if (t >= 0) {
                    msg = msg + t;
                    msg = msg + "ms\n";
                } else {
                    msg = msg + "none\n";
                }
                msg = msg + info.describe();
                this.orbInstance_.getLogger().trace("outgoing", msg);
            }
            if (t >= 0) {
                transport = this.connector_.connect_timeout(t);
                if (transport == null) {
                    throw new NO_RESPONSE("Connection timeout", 0, CompletionStatus.COMPLETED_NO);
                }
            } else {
                transport = this.connector_.connect();
                Assert._OB_assert(transport != null);
            }
            Assert._OB_assert(this.concModel_ == 2);
            this.worker_ = new GIOPClientWorkerThreaded(this.orbInstance_, this, transport);
            if (this.codeSetSC_ == null) {
                CodeSetContext ctx = new CodeSetContext();
                CodeConverters conv = this.codeConverters();
                ctx.char_data = conv.outputCharConverter != null ? conv.outputCharConverter.getTo().rgy_value : 65537;
                ctx.wchar_data = conv.outputWcharConverter != null ? conv.outputWcharConverter.getTo().rgy_value : this.orbInstance_.getNativeWcs();
                Buffer buf = new Buffer();
                OutputStream outCSC = new OutputStream(buf);
                outCSC._OB_writeEndian();
                CodeSetContextHelper.write(outCSC, ctx);
                this.codeSetSC_ = new ServiceContext();
                this.codeSetSC_.context_id = 1;
                int len = buf.length();
                byte[] data = buf.data();
                this.codeSetSC_.context_data = new byte[len];
                System.arraycopy(data, 0, this.codeSetSC_.context_data, 0, len);
            }
        }
        return this.worker_;
    }

    GIOPClient(ORBInstance orbInstance, Connector connector, int concModel, CodeConverters conv) {
        super(concModel, conv);
        this.orbInstance_ = orbInstance;
        this.connector_ = connector;
        this.destroy_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        GIOPClientWorker worker = null;
        GIOPClient gIOPClient = this;
        synchronized (gIOPClient) {
            if (this.destroy_) {
                return;
            }
            this.destroy_ = true;
            worker = this.worker_;
            this.worker_ = null;
        }
        if (worker != null) {
            worker.destroy();
        }
    }

    public synchronized void removeWorker(GIOPClientWorker worker) {
        if (this.worker_ == worker) {
            this.worker_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            return this.nextRequestId_++;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        ProfileInfo[] all = this.connector_.get_usable_profiles(ior, policies);
        Vector<ProfileInfo> vec = new Vector<ProfileInfo>();
        for (int i = 0; i < all.length; ++i) {
            CodeConverters conv = CodeSetUtil.getCodeConverters(this.orbInstance_, all[i]);
            if (!this.codeConverters().equals(conv)) continue;
            vec.addElement(all[i]);
        }
        Object[] result = new ProfileInfo[vec.size()];
        vec.copyInto(result);
        return result;
    }

    public ConnectorInfo connectorInfo() {
        return this.connector_.get_info();
    }

    public TransportInfo transportInfo() {
        GIOPClientWorker worker = this.getWorker(false, -1);
        if (worker == null) {
            return null;
        }
        Transport transport = worker.transport();
        return transport.get_info();
    }

    public DowncallEmitter startDowncall(Downcall down, OutputStreamHolder out) {
        GIOPClientWorker worker = null;
        try {
            worker = this.getWorker(true, down.policies().connectTimeout);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return null;
        }
        try {
            byte major = down.profileInfo().major;
            byte minor = down.profileInfo().minor;
            if (!(worker.messageSent() || major <= 1 && minor < 1)) {
                CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
                if (coreTraceLevels.traceConnections() >= 2) {
                    CodeSetInfo info;
                    CodeConverters conv = this.codeConverters();
                    String msg = "sending transmission code sets";
                    msg = msg + "\nchar code set: ";
                    if (conv.outputCharConverter != null) {
                        msg = msg + conv.outputCharConverter.getTo().description;
                    } else {
                        info = CodeSetDatabase.instance().getCodeSetInfo(this.orbInstance_.getNativeCs());
                        msg = msg + info.description;
                    }
                    msg = msg + "\nwchar code set: ";
                    if (conv.outputWcharConverter != null) {
                        msg = msg + conv.outputWcharConverter.getTo().description;
                    } else {
                        info = CodeSetDatabase.instance().getCodeSetInfo(this.orbInstance_.getNativeWcs());
                        msg = msg + info.description;
                    }
                    this.orbInstance_.getLogger().trace("outgoing", msg);
                }
                Assert._OB_assert(this.codeSetSC_ != null);
                down.addToRequestSCL(this.codeSetSC_);
            }
            ProfileInfo profileInfo = down.profileInfo();
            Buffer buf = new Buffer(12);
            buf.pos(12);
            out.value = new OutputStream(buf, this.codeConverters(), profileInfo.major << 8 | profileInfo.minor);
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out.value, profileInfo);
            String op = down.operation();
            if (op.charAt(0) == '_' && op.equals("_locate")) {
                outgoing.writeLocateRequestHeader(down.requestId());
            } else {
                outgoing.writeRequestHeader(down.requestId(), down.operation(), down.responseExpected(), down.getRequestSCL());
            }
            return worker;
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return null;
        }
    }

    public boolean equal(Client cl) {
        GIOPClient client = null;
        try {
            client = (GIOPClient)cl;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (!this.connector_.equal(client.connector_)) {
            return false;
        }
        return this.codeConverters().equals(client.codeConverters());
    }

    public void bind(int connectTimeout) {
        this.getWorker(true, connectTimeout);
    }

    public boolean twoway() {
        GIOPClientWorker worker = this.getWorker(false, -1);
        Assert._OB_assert(worker != null);
        Transport transport = worker.transport();
        return transport.mode() == SendReceiveMode.SendReceive;
    }
}

