/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.ClientManager;
import com.ooc.OB.ClientProfilePair;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.FailureException;
import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.PIArgsDowncall;
import com.ooc.OB.PIDIIDowncall;
import com.ooc.OB.PIDowncall;
import com.ooc.OB.PIManager;
import com.ooc.OB.ParameterDesc;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OCI.ConnectorInfo;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.ProfileInfoHolder;
import com.ooc.OCI.TransportInfo;
import java.util.Vector;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.IOR;

public final class DowncallStub {
    private ORBInstance orbInstance_;
    private IOR IOR_;
    private IOR origIOR_;
    private RefCountPolicyList policies_;
    private Vector clientProfilePairs_ = null;

    private synchronized Client getClientProfilePair(ProfileInfoHolder profileInfo) throws FailureException {
        if (this.clientProfilePairs_ == null) {
            ClientManager clientManager = this.orbInstance_.getClientManager();
            this.clientProfilePairs_ = clientManager.getClientProfilePairs(this.IOR_, this.policies_.value);
        }
        if (this.clientProfilePairs_.isEmpty()) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceRetry() >= 2) {
                this.orbInstance_.getLogger().trace("retry", "no profiles available");
            }
            throw new FailureException(new TRANSIENT(MinorCodes.describeTransient(1330446338), 1330446338, CompletionStatus.COMPLETED_NO));
        }
        ClientProfilePair clientProfilePair = (ClientProfilePair)this.clientProfilePairs_.elementAt(0);
        profileInfo.value = clientProfilePair.profile;
        return clientProfilePair.client;
    }

    private void destroy() {
        ClientManager clientManager = this.orbInstance_.getClientManager();
        if (clientManager != null && this.clientProfilePairs_ != null) {
            for (int i = 0; i < this.clientProfilePairs_.size(); ++i) {
                ClientProfilePair pair = (ClientProfilePair)this.clientProfilePairs_.elementAt(i);
                clientManager.releaseClient(pair.client);
            }
        }
        this.clientProfilePairs_.removeAllElements();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public DowncallStub(ORBInstance orbInstance, IOR ior, IOR origIOR, RefCountPolicyList policies) {
        this.orbInstance_ = orbInstance;
        this.IOR_ = ior;
        this.origIOR_ = origIOR;
        this.policies_ = policies;
    }

    public Downcall createDowncall(String op, boolean resp) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public Downcall createLocateRequestDowncall() throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, "_locate", true);
    }

    public Downcall createPIArgsDowncall(String op, boolean resp, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIArgsDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager, argDesc, retDesc, exceptionTC);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public Downcall createPIDIIDowncall(String op, boolean resp, NVList args, NamedValue result, ExceptionList exceptions) throws FailureException {
        ProfileInfoHolder profile = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profile);
        Assert._OB_assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
        }
        PIManager piManager = this.orbInstance_.getPIManager();
        if (piManager.haveClientInterceptors()) {
            return new PIDIIDowncall(this.orbInstance_, client, profile.value, this.policies_, op, resp, this.IOR_, this.origIOR_, piManager, args, result, exceptions);
        }
        return new Downcall(this.orbInstance_, client, profile.value, this.policies_, op, resp);
    }

    public OutputStream preMarshal(Downcall down) throws LocationForward, FailureException {
        return down.preMarshal();
    }

    public void marshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.marshalEx(ex);
    }

    public void postMarshal(Downcall down) throws LocationForward, FailureException {
        down.postMarshal();
    }

    public void locate(Downcall down) throws LocationForward, FailureException {
        down.locate();
    }

    public void request(Downcall down) throws LocationForward, FailureException {
        down.request();
    }

    public void oneway(Downcall down) throws LocationForward, FailureException {
        down.oneway();
    }

    public void deferred(Downcall down) throws LocationForward, FailureException {
        down.deferred();
    }

    public void response(Downcall down) throws LocationForward, FailureException {
        down.response();
    }

    public boolean poll(Downcall down) throws LocationForward, FailureException {
        return down.poll();
    }

    public InputStream preUnmarshal(Downcall down) throws LocationForward, FailureException {
        return down.preUnmarshal();
    }

    public InputStream preUnmarshal(Downcall down, BooleanHolder uex) throws LocationForward, FailureException {
        InputStream in = down.preUnmarshal();
        uex.value = down.userException();
        return in;
    }

    public void unmarshalEx(Downcall down, SystemException ex) throws LocationForward, FailureException {
        down.unmarshalEx(ex);
    }

    public void postUnmarshal(Downcall down) throws LocationForward, FailureException {
        down.postUnmarshal();
    }

    public String unmarshalExceptionId(Downcall down) {
        return down.unmarshalExceptionId();
    }

    public void setUserException(Downcall down, UserException ex, String exId) {
        down.setUserException(ex, exId);
    }

    public void setUserException(Downcall down, UserException ex) {
        down.setUserException(ex);
    }

    public synchronized void handleFailureException(Downcall down, FailureException ex) throws FailureException {
        String msg;
        CoreTraceLevels coreTraceLevels;
        Assert._OB_assert(ex.exception != null);
        Client client = down.client();
        ProfileInfo profile = down.profileInfo();
        for (int i = 0; i < this.clientProfilePairs_.size(); ++i) {
            ClientProfilePair pair = (ClientProfilePair)this.clientProfilePairs_.elementAt(i);
            if (pair.client != client || pair.profile != profile) continue;
            ClientManager clientManager = this.orbInstance_.getClientManager();
            if (clientManager == null) {
                throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            clientManager.releaseClient(pair.client);
            this.clientProfilePairs_.removeElementAt(i);
            break;
        }
        try {
            throw ex.exception;
        }
        catch (COMM_FAILURE e) {
        }
        catch (TRANSIENT e) {
        }
        catch (NO_RESPONSE e) {
        }
        catch (SystemException e) {
            throw ex;
        }
        if (this.policies_.retry.mode != 2 && ex.exception.completed != CompletionStatus.COMPLETED_NO) {
            throw ex;
        }
        if (this.clientProfilePairs_.isEmpty()) {
            coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceRetry() >= 2) {
                msg = "no profiles left to try\n" + ex.exception.getMessage();
                this.orbInstance_.getLogger().trace("retry", msg);
            }
            throw ex;
        }
        coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceRetry() >= 2) {
            msg = "trying next profile\n" + ex.exception.getMessage();
            this.orbInstance_.getLogger().trace("retry", msg);
        }
    }

    public boolean locate_request() throws LocationForward, FailureException {
        while (true) {
            Downcall down = this.createLocateRequestDowncall();
            try {
                try {
                    Client client = down.client();
                    client.bind(this.policies_.connectTimeout);
                    if (!this.policies_.locateRequest) {
                        return true;
                    }
                    if (!client.twoway()) {
                        return true;
                    }
                }
                catch (SystemException ex) {
                    throw new FailureException(ex);
                }
                this.preMarshal(down);
                this.postMarshal(down);
                this.locate(down);
                this.preUnmarshal(down);
                this.postUnmarshal(down);
                return true;
            }
            catch (OBJECT_NOT_EXIST ex) {
                return false;
            }
            catch (FailureException ex) {
                this.handleFailureException(down, ex);
                continue;
            }
            break;
        }
    }

    public ConnectorInfo get_oci_connector_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert._OB_assert(client != null);
            return client.connectorInfo();
        }
        catch (FailureException ex) {
            Assert._OB_assert(false);
            return null;
        }
    }

    public TransportInfo get_oci_transport_info() {
        try {
            ProfileInfoHolder profileInfo = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfo);
            Assert._OB_assert(client != null);
            return client.transportInfo();
        }
        catch (FailureException ex) {
            Assert._OB_assert(false);
            return null;
        }
    }

    public OutputStream setupRequest(Object self, String operation, boolean responseExpected) throws LocationForward, FailureException {
        while (true) {
            Downcall downcall = this.createDowncall(operation, responseExpected);
            try {
                OutputStream out = this.preMarshal(downcall);
                InvocationContext ctx = new InvocationContext();
                ctx.downcallStub = this;
                ctx.downcall = downcall;
                out._OB_invocationContext(ctx);
                return out;
            }
            catch (FailureException ex) {
                this.handleFailureException(downcall, ex);
                continue;
            }
            break;
        }
    }

    public InputStream invoke(Object self, OutputStream out) throws ApplicationException, RemarshalException, LocationForward, FailureException {
        OutputStream o = out;
        InvocationContext ctx = (InvocationContext)o._OB_invocationContext();
        Assert._OB_assert(ctx != null);
        if (ctx.downcallStub != this) {
            throw new RemarshalException();
        }
        Downcall down = ctx.downcall;
        try {
            down.postMarshal();
            boolean response = down.responseExpected();
            if (response) {
                down.request();
            } else {
                down.oneway();
            }
            if (response) {
                InputStream in = down.preUnmarshal();
                if (down.userException()) {
                    String id = null;
                    try {
                        id = down.unmarshalExceptionId();
                    }
                    catch (SystemException ex) {
                        down.unmarshalEx(ex);
                    }
                    down.setUserException(id);
                    down.postUnmarshal();
                    throw new ApplicationException(id, in);
                }
                down.postUnmarshal();
                return in;
            }
            down.preUnmarshal();
            down.postUnmarshal();
            return null;
        }
        catch (FailureException ex) {
            this.handleFailureException(down, ex);
            throw new RemarshalException();
        }
    }

    private class InvocationContext {
        DowncallStub downcallStub;
        Downcall downcall;

        private InvocationContext() {
        }
    }
}

