/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.ClientProfilePair;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.CollocatedClient;
import com.ooc.OB.CollocatedServer;
import com.ooc.OB.ConnectionReusePolicy;
import com.ooc.OB.ConnectionReusePolicyHelper;
import com.ooc.OB.GIOPClient;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ProtocolPolicy;
import com.ooc.OB.ProtocolPolicyHelper;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerFactory;
import com.ooc.OBPortableServer.POAManager_impl;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.ConFactory;
import com.ooc.OCI.ConFactoryRegistry;
import com.ooc.OCI.Connector;
import com.ooc.OCI.ConnectorInfo;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.IOR;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public final class ClientManager {
    private boolean destroy_ = false;
    private ORBInstance orbInstance_;
    private Vector allClients_ = new Vector();
    private Vector reusableClients_ = new Vector();
    private int concModel_;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.destroy_);
        Assert._OB_assert(this.allClients_.isEmpty());
        Assert._OB_assert(this.reusableClients_.isEmpty());
        super.finalize();
    }

    synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration e = this.allClients_.elements();
        while (e.hasMoreElements()) {
            Client client = (Client)e.nextElement();
            client.destroy();
        }
        this.orbInstance_ = null;
        this.allClients_.removeAllElements();
        this.reusableClients_.removeAllElements();
    }

    public ClientManager(int concModel) {
        this.concModel_ = concModel;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public synchronized Vector getClientProfilePairs(IOR ior, Policy[] policies) {
        int j;
        int i;
        Assert._OB_assert(ior.type_id != null);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            throw new INV_OBJREF("Object reference is nil");
        }
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        boolean privateClients = false;
        for (int i2 = 0; i2 < policies.length; ++i2) {
            if (policies[i2].policy_type() != 1330577411) continue;
            ConnectionReusePolicy p = ConnectionReusePolicyHelper.narrow(policies[i2]);
            if (p.value()) break;
            privateClients = true;
            break;
        }
        ProtocolPolicy protocolPolicy = null;
        for (int i3 = 0; i3 < policies.length; ++i3) {
            if (policies[i3].policy_type() != 1330577410) continue;
            protocolPolicy = ProtocolPolicyHelper.narrow(policies[i3]);
            break;
        }
        Vector<ClientProfilePair> pairs = new Vector<ClientProfilePair>();
        POAManagerFactory pmFactory = this.orbInstance_.getPOAManagerFactory();
        POAManager[] managers = pmFactory.get_poa_managers();
        for (i = 0; i < managers.length; ++i) {
            try {
                Acceptor[] acceptors = managers[i].get_acceptors();
                boolean local = false;
                for (j = 0; j < acceptors.length && !local; ++j) {
                    ProfileInfo[] localProfileInfos = acceptors[j].get_local_profiles(ior);
                    if (localProfileInfos.length <= 0) continue;
                    local = true;
                }
                if (!local) continue;
                POAManager_impl manager = (POAManager_impl)managers[i];
                CollocatedServer collocatedServer = manager._OB_getCollocatedServer();
                CodeConverters conv = new CodeConverters();
                CollocatedClient client = new CollocatedClient(collocatedServer, this.concModel_, conv);
                this.allClients_.addElement(client);
                ProfileInfo[] profileInfos = ((Client)client).getUsableProfiles(ior, policies);
                for (int j2 = 0; j2 < profileInfos.length; ++j2) {
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = client;
                    pair.profile = profileInfos[j2];
                    pairs.addElement(pair);
                }
                continue;
            }
            catch (AdapterInactive ex) {
                // empty catch block
            }
        }
        if (!privateClients) {
            for (i = 0; i < this.reusableClients_.size(); ++i) {
                ConnectorInfo info;
                Client reusableClient = (Client)this.reusableClients_.elementAt(i);
                if (protocolPolicy != null && (info = reusableClient.connectorInfo()) != null && !protocolPolicy.contains(info.id())) continue;
                ProfileInfo[] profileInfos = reusableClient.getUsableProfiles(ior, policies);
                for (j = 0; j < profileInfos.length; ++j) {
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = reusableClient;
                    pair.profile = profileInfos[j];
                    pairs.addElement(pair);
                }
            }
        }
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (int i4 = 0; i4 < factories.length; ++i4) {
            Connector[] connectors = factories[i4].create_connectors(ior, policies);
            for (int j3 = 0; j3 < connectors.length; ++j3) {
                if (protocolPolicy != null && !protocolPolicy.contains(connectors[j3].id())) continue;
                ProfileInfo[] profileInfos = connectors[j3].get_usable_profiles(ior, policies);
                Assert._OB_assert(profileInfos.length >= 1);
                for (int k = 0; k < profileInfos.length; ++k) {
                    CodeConverters conv = CodeSetUtil.getCodeConverters(this.orbInstance_, profileInfos[k]);
                    GIOPClient client = new GIOPClient(this.orbInstance_, connectors[j3], this.concModel_, conv);
                    if (!pairs.isEmpty()) {
                        int l;
                        for (l = 0; l < pairs.size(); ++l) {
                            ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(l);
                            if (pair.client.equal(client)) break;
                        }
                        if (l != pairs.size()) {
                            ((Client)client).destroy();
                            continue;
                        }
                    }
                    this.allClients_.addElement(client);
                    ProfileInfo[] clientProfileInfos = ((Client)client).getUsableProfiles(ior, policies);
                    for (int l = 0; l < clientProfileInfos.length; ++l) {
                        ClientProfilePair pair = new ClientProfilePair();
                        pair.client = client;
                        pair.profile = clientProfileInfos[l];
                        pairs.addElement(pair);
                    }
                    if (privateClients) continue;
                    this.reusableClients_.addElement(client);
                }
            }
        }
        if (!pairs.isEmpty() && protocolPolicy != null) {
            int i5;
            String[] protocols = protocolPolicy.value();
            Vector<ClientProfilePair> newPairs = new Vector<ClientProfilePair>();
            for (i5 = 0; i5 < pairs.size(); ++i5) {
                ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(i5);
                ConnectorInfo info = pair.client.connectorInfo();
                if (info != null) continue;
                newPairs.addElement(pair);
            }
            for (i5 = 0; i5 < protocols.length; ++i5) {
                for (int j4 = 0; j4 < pairs.size(); ++j4) {
                    ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(j4);
                    ConnectorInfo info = pair.client.connectorInfo();
                    if (info == null || !protocols[i5].equals(info.id())) continue;
                    newPairs.addElement(pair);
                }
            }
            pairs = newPairs;
        }
        if (pairs.isEmpty()) {
            throw new TRANSIENT(MinorCodes.describeTransient(1330446338) + "Unable to create client", 1330446338, CompletionStatus.COMPLETED_NO);
        }
        for (int i6 = 0; i6 < pairs.size(); ++i6) {
            ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(i6);
            pair.client.incUsage();
        }
        return pairs;
    }

    public synchronized void releaseClient(Client client) {
        if (this.destroy_) {
            return;
        }
        boolean inUse = client.decUsage();
        if (!inUse) {
            Client c;
            int i;
            for (i = 0; i < this.reusableClients_.size(); ++i) {
                c = (Client)this.reusableClients_.elementAt(i);
                if (c != client) continue;
                this.reusableClients_.removeElementAt(i);
                break;
            }
            for (i = 0; i < this.allClients_.size(); ++i) {
                c = (Client)this.allClients_.elementAt(i);
                if (c != client) continue;
                client.destroy();
                this.allClients_.removeElementAt(i);
                return;
            }
            Assert._OB_assert(false);
        }
    }

    public boolean equivalent(IOR ior1, IOR ior2) {
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (int i = 0; i < factories.length; ++i) {
            if (factories[i].equivalent(ior1, ior2)) continue;
            return false;
        }
        return true;
    }

    public int hash(IOR ior, int maximum) {
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        int hash = 0;
        for (int i = 0; i < factories.length; ++i) {
            hash ^= factories[i].hash(ior, maximum);
        }
        return hash % (maximum + 1);
    }
}

